/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.debug.client.renderer;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.wind.client.impl.ClientWindManager;
import net.minecraft.class_12021;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_863;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class WindDebugRenderer
implements class_863.class_864 {
    public void method_23109(class_4587 poseStack, class_4597 bufferSource, double cameraX, double cameraY, double cameraZ, class_12021 debugValueAccess, class_4604 frustum) {
        WindDebugRenderer.renderWindNodesFromList(poseStack, bufferSource, cameraX, cameraY, cameraZ, ClientWindManager.Debug.getDebugNodes(), frustum);
    }

    protected static void renderWindNodesFromList(class_4587 poseStack, class_4597 bufferSource, double cameraX, double cameraY, double cameraZ, @NotNull List<List<Pair<class_243, Integer>>> windNodes, class_4604 frustum) {
        windNodes.forEach(nodes -> WindDebugRenderer.renderWindNodes(poseStack, bufferSource, cameraX, cameraY, cameraZ, nodes, frustum));
    }

    protected static void renderWindNodes(class_4587 poseStack, class_4597 bufferSource, double cameraX, double cameraY, double cameraZ, @NotNull List<Pair<class_243, Integer>> windNodes, class_4604 frustum) {
        int size = windNodes.size();
        if (size <= 1) {
            return;
        }
        for (int i = 1; i < size; ++i) {
            Pair<class_243, Integer> startNode = windNodes.get(i - 1);
            Pair<class_243, Integer> endNode = windNodes.get(i);
            class_243 startVec = (class_243)startNode.getFirst();
            class_243 endVec = (class_243)endNode.getFirst();
            if (!frustum.method_74404(startVec.field_1352, startVec.field_1351, startVec.field_1350) && !frustum.method_74404(endVec.field_1352, endVec.field_1351, endVec.field_1350)) continue;
            WindDebugRenderer.drawLine(poseStack, bufferSource, cameraX, cameraY, cameraZ, startVec, endVec, (Integer)startNode.getSecond());
        }
    }

    private static void drawLine(@NotNull class_4587 poseStack, @NotNull class_4597 bufferSource, double cameraX, double cameraY, double cameraZ, @NotNull class_243 start, @NotNull class_243 target, int color) {
        class_4588 vertexConsumer = bufferSource.method_73477(class_1921.method_49043((double)24.0));
        vertexConsumer.method_56824(poseStack.method_23760(), (float)(start.field_1352 - cameraX), (float)(start.field_1351 - cameraY), (float)(start.field_1350 - cameraZ)).method_39415(color);
        vertexConsumer.method_56824(poseStack.method_23760(), (float)(target.field_1352 - cameraX), (float)(target.field_1351 - cameraY), (float)(target.field_1350 - cameraZ)).method_39415(color);
    }
}

