/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization.parser;

import java.util.ArrayList;
import net.frozenblock.lib.shadow.xjs.data.JsonArray;
import net.frozenblock.lib.shadow.xjs.data.JsonContainer;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;
import net.frozenblock.lib.shadow.xjs.data.exception.SyntaxException;
import net.frozenblock.lib.shadow.xjs.data.serialization.parser.ValueParser;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.Token;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.TokenStream;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.TokenType;
import net.frozenblock.lib.shadow.xjs.data.serialization.util.BufferedStack;
import org.jetbrains.annotations.ApiStatus;

public abstract class TokenParser
implements ValueParser {
    protected static final TokenStream EMPTY_VALUE = new TokenStream(0, 0, 0, 0, 0, TokenType.OPEN, new ArrayList<Token>());
    protected static final TokenStream.Itr EMPTY_ITERATOR = EMPTY_VALUE.iterator();
    protected final BufferedStack.OfTwo<TokenStream.Itr, JsonContainer> stack = BufferedStack.ofTwo();
    @ApiStatus.Experimental
    protected final TokenStream root;
    protected JsonContainer formatting;
    protected TokenStream.Itr iterator;
    protected Token current;
    protected int linesSkipped;

    protected TokenParser(TokenStream root) {
        this.root = root;
        this.formatting = new JsonArray();
        this.iterator = root.iterator();
        this.current = root;
    }

    protected void read() {
        TokenStream.Itr itr = this.iterator;
        if (itr == EMPTY_ITERATOR) {
            return;
        }
        this.current = itr.hasNext() ? this.iterator.next() : EMPTY_VALUE;
    }

    protected boolean push() {
        if (this.iterator.getParent() == this.current) {
            return false;
        }
        if (this.current instanceof TokenStream) {
            this.stack.push(this.iterator, this.formatting);
            this.iterator = ((TokenStream)this.current).iterator();
            this.formatting = new JsonArray();
            return true;
        }
        return false;
    }

    protected boolean pop() {
        this.expectEndOfContainer();
        if (this.stack.isEmpty()) {
            this.iterator = EMPTY_ITERATOR;
            return false;
        }
        this.stack.pop();
        this.iterator = this.stack.getFirst();
        this.formatting = this.stack.getSecond();
        return true;
    }

    protected boolean open() {
        this.push();
        if (this.isEndOfContainer()) {
            return false;
        }
        this.read();
        this.readWhitespace();
        return true;
    }

    protected <T extends JsonContainer> T close(T container) {
        this.setTrailing();
        this.takeFormatting(container);
        this.pop();
        this.read();
        return container;
    }

    protected void push(char opener) {
        this.expect(opener);
        this.stack.push(null, this.formatting);
        this.formatting = new JsonArray();
    }

    protected void pop(char closer) {
        this.expectEndOfContainer(closer);
        this.stack.pop();
        this.formatting = this.stack.getSecond();
    }

    protected boolean open(char opener, char closer) {
        this.push(opener);
        this.readWhitespace();
        return !this.isEndOfContainer(closer);
    }

    protected <T extends JsonContainer> T close(T container, char closer) {
        this.setTrailing();
        this.takeFormatting(container);
        this.pop(closer);
        this.read();
        return container;
    }

    protected boolean readIf(char symbol) {
        if (this.current.isSymbol(symbol)) {
            this.read();
            return true;
        }
        return false;
    }

    protected boolean readNl() {
        if (this.current.type() == TokenType.BREAK) {
            this.read();
            this.flagLineAsSkipped();
            return true;
        }
        return false;
    }

    protected void flagLineAsSkipped() {
        ++this.linesSkipped;
    }

    protected boolean isEndOfContainer() {
        return this.current == EMPTY_VALUE;
    }

    protected boolean isEndOfText() {
        return this.stack.isEmpty() && !this.iterator.hasNext();
    }

    protected boolean isEndOfContainer(char closer) {
        return this.current.isSymbol(closer);
    }

    protected void readWhitespace() {
        this.readWhitespace(true, true);
    }

    protected void readWhitespace(boolean resetLinesSkipped) {
        this.readWhitespace(resetLinesSkipped, true);
    }

    protected void readLineWhitespace() {
        this.readWhitespace(false, false);
    }

    protected void readWhitespace(boolean resetLinesSkipped, boolean nl) {
        TokenStream.Itr itr;
        if (resetLinesSkipped) {
            this.linesSkipped = 0;
        }
        if ((itr = this.iterator) == EMPTY_ITERATOR) {
            return;
        }
        Token t = this.current;
        int peekAmount = 0;
        while (t != EMPTY_VALUE && this.consumeWhitespace(t, nl)) {
            t = itr.peek(++peekAmount, EMPTY_VALUE);
        }
        this.current = t;
        itr.skip(peekAmount);
    }

    protected boolean consumeWhitespace(Token t, boolean nl) {
        if (nl && t.type() == TokenType.BREAK) {
            this.flagLineAsSkipped();
            return true;
        }
        return false;
    }

    protected boolean isLineWhitespace(char c) {
        return c == ' ' || c == '\r' || c == '\t';
    }

    protected int skipTo(char symbol, boolean nl, boolean eof) {
        TokenStream.Itr itr = this.iterator;
        if (!itr.hasNext()) {
            if (eof) {
                return 0;
            }
            throw this.expectedSymbolOrNL(symbol, nl);
        }
        Token t = itr.peek();
        Token lastRecorded = this.current;
        int peekAmount = 1;
        while (t != null) {
            if (t.isSymbol(symbol) || nl && t.type() == TokenType.BREAK) {
                itr.skip(peekAmount - 1);
                this.current = lastRecorded;
                return peekAmount - 1;
            }
            if (!this.consumeWhitespace(t, false)) {
                lastRecorded = t;
            }
            t = itr.peek(++peekAmount);
        }
        if (eof) {
            if (peekAmount > 1) {
                itr.skip(peekAmount - 1);
                this.current = lastRecorded;
            }
            return peekAmount;
        }
        throw this.expectedSymbolOrNL(symbol, nl);
    }

    protected void setAbove() {
        this.formatting.setLinesAbove(this.takeLinesSkipped());
    }

    protected void setBetween() {
        this.formatting.setLinesBetween(this.takeLinesSkipped());
    }

    protected void setTrailing() {
        this.formatting.setLinesTrailing(this.takeLinesSkipped());
    }

    protected void readAbove() {
        this.readWhitespace(false);
        this.setAbove();
    }

    protected void readBetween(char kvSeparator) {
        this.readWhitespace();
        this.expect(kvSeparator);
        this.readWhitespace();
        this.setBetween();
    }

    protected void readAfter() {
        this.readLineWhitespace();
    }

    protected void readBottom() {
        this.readWhitespace(false);
        this.expectEndOfText();
    }

    protected int takeLinesSkipped() {
        int skipped = this.linesSkipped;
        this.linesSkipped = 0;
        return skipped;
    }

    protected <T extends JsonValue> T takeFormatting(T value) {
        value.setDefaultMetadata(this.formatting);
        this.clearFormatting();
        return value;
    }

    protected void clearFormatting() {
        this.formatting.setLinesTrailing(-1).setLinesAbove(-1).setLinesBetween(-1).setComments(null);
    }

    protected void expect(char expected) {
        if (!this.readIf(expected)) {
            throw this.expected(expected);
        }
    }

    protected void expectEndOfText() {
        if (!this.isEndOfText()) {
            throw this.unexpected(String.valueOf(this.current.type()) + " before end of file");
        }
    }

    protected SyntaxException expectedSymbolOrNL(char symbol, boolean nl) {
        if (nl) {
            return this.expected("'" + symbol + "' or new line");
        }
        return this.expected(symbol);
    }

    protected void expectEndOfContainer() {
        if (!this.isEndOfContainer()) {
            throw this.tokensInContainer();
        }
    }

    protected void expectEndOfContainer(char closer) {
        if (!this.isEndOfContainer(closer)) {
            throw this.tokensInContainer();
        }
    }

    protected SyntaxException tokensInContainer() {
        return this.unexpected(String.valueOf(this.current.type()) + " before end of container (missing delimiter?)");
    }

    protected SyntaxException illegalToken(String text) {
        return SyntaxException.illegalToken(text, this.current.line(), this.current.offset());
    }

    protected SyntaxException expected(char expected) {
        return SyntaxException.expected(expected, this.current.line(), this.current.offset());
    }

    protected SyntaxException expected(String expected) {
        return SyntaxException.expected(expected, this.current.line(), this.current.offset());
    }

    protected SyntaxException unexpected(char unexpected) {
        return SyntaxException.unexpected(unexpected, this.current.line(), this.current.offset());
    }

    protected SyntaxException unexpected(String unexpected) {
        return SyntaxException.unexpected(unexpected, this.current.line(), this.current.offset());
    }
}

