/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization.token;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.TokenStream;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.Tokenizer;
import net.frozenblock.lib.shadow.xjs.data.serialization.util.PositionTrackingReader;

@FunctionalInterface
public interface TokenizingFunction {
    public TokenStream stream(PositionTrackingReader var1, boolean var2) throws IOException;

    default public TokenStream stream(PositionTrackingReader reader) throws IOException {
        return this.stream(reader, false);
    }

    default public TokenStream stream(String s) {
        try {
            return this.stream(PositionTrackingReader.fromString(s), false);
        }
        catch (IOException e) {
            throw new IllegalStateException("Tokenizer threw unexpected error", e);
        }
    }

    default public TokenStream stream(Reader reader) throws IOException {
        return this.stream(PositionTrackingReader.fromReader(reader), false);
    }

    default public TokenStream stream(InputStream is) throws IOException {
        return this.stream(PositionTrackingReader.fromIs(is), false);
    }

    default public TokenStream stream(Path file) throws IOException {
        return this.stream(Files.newBufferedReader(file));
    }

    default public TokenStream containerize(PositionTrackingReader reader) throws IOException {
        return this.stream(reader, true);
    }

    default public TokenStream containerize(String s) {
        try {
            return this.stream(PositionTrackingReader.fromString(s), true);
        }
        catch (IOException e) {
            throw new IllegalStateException("Tokenizer threw unexpected error", e);
        }
    }

    default public TokenStream containerize(Reader reader) throws IOException {
        return this.stream(PositionTrackingReader.fromReader(reader), false);
    }

    default public TokenStream containerize(InputStream is) throws IOException {
        return this.stream(PositionTrackingReader.fromIs(is), false);
    }

    default public TokenStream containerize(Path file) throws IOException {
        return this.containerize(Files.newBufferedReader(file));
    }

    public static TokenizingFunction fromTokenizer(Tokenizer.ReaderConstructor c) {
        return (reader, containerize) -> c.construct(reader, containerize).stream();
    }
}

