/*
 * Decompiled with CFR 0.152.
 */
package dev.pandasystems.pandalib.config;

import dev.pandasystems.pandalib.config.ConfigObject;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\b\u001a\u00020\u0007\"\b\b\u0000\u0010\u0004*\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\b\u0010\tJ-\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\"\b\b\u0000\u0010\u0004*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00028\u0000\u00a2\u0006\u0004\b\r\u0010\u000eJ'\u0010\u000f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005\"\b\b\u0000\u0010\u0004*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000f\u0010\u0010R$\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Ldev/pandasystems/pandalib/config/ConfigRegistry;", "", "<init>", "()V", "T", "Ldev/pandasystems/pandalib/config/ConfigObject;", "configObject", "", "register", "(Ldev/pandasystems/pandalib/config/ConfigObject;)V", "Lnet/minecraft/class_2960;", "resourceLocation", "configInstance", "create", "(Lnet/minecraft/class_2960;Ljava/lang/Object;)Ldev/pandasystems/pandalib/config/ConfigObject;", "get", "(Lnet/minecraft/class_2960;)Ldev/pandasystems/pandalib/config/ConfigObject;", "", "configObjects", "Ljava/util/Map;", "pandalib-common-1.21.10"})
public final class ConfigRegistry {
    @NotNull
    public static final ConfigRegistry INSTANCE = new ConfigRegistry();
    @NotNull
    private static final Map<class_2960, ConfigObject<?>> configObjects = new LinkedHashMap();

    private ConfigRegistry() {
    }

    public final <T> void register(@NotNull ConfigObject<T> configObject) {
        Intrinsics.checkNotNullParameter(configObject, (String)"configObject");
        class_2960 key = configObject.getResourceLocation();
        if (configObjects.containsKey(key)) {
            throw new IllegalArgumentException("ConfigObject with resource location " + key + " is already registered.");
        }
        configObjects.put(key, configObject);
    }

    @NotNull
    public final <T> ConfigObject<T> create(@NotNull class_2960 resourceLocation, @NotNull T configInstance) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"resourceLocation");
        Intrinsics.checkNotNullParameter(configInstance, (String)"configInstance");
        ConfigObject configObject = new ConfigObject(resourceLocation, configInstance, null, 4, null);
        class_2960 key = configObject.getResourceLocation();
        if (configObjects.containsKey(key)) {
            throw new IllegalArgumentException("ConfigObject with resource location " + key + " is already registered.");
        }
        configObjects.put(key, configObject);
        return configObject;
    }

    @Nullable
    public final <T> ConfigObject<T> get(@NotNull class_2960 resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"resourceLocation");
        ConfigObject<?> configObject = configObjects.get(resourceLocation);
        return configObject instanceof ConfigObject ? configObject : null;
    }
}

