/*
 * Decompiled with CFR 0.152.
 */
package dev.pandasystems.pandalib.config;

import dev.pandasystems.pandalib.PandaLib;
import dev.pandasystems.pandalib.config.ConfigObject;
import dev.pandasystems.pandalib.config.ConfigRegistry;
import dev.pandasystems.pandalib.event.server.ServerConfigurationConnectionEventsKt;
import dev.pandasystems.pandalib.networking.PayloadCodecRegistry;
import dev.pandasystems.pandalib.networking.ServerConfigurationNetworking;
import dev.pandasystems.pandalib.networking.ServerPlayNetworking;
import dev.pandasystems.pandalib.networking.payloads.config.ClientboundConfigRequestPayload;
import dev.pandasystems.pandalib.networking.payloads.config.CommonConfigPayload;
import dev.pandasystems.pandalib.utils.Event;
import dev.pandasystems.universalserializer.Serializer;
import dev.pandasystems.universalserializer.elements.TreeElement;
import dev.pandasystems.universalserializer.elements.TreeObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.reflect.KProperty0;
import kotlin.reflect.KType;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0003J!\u0010\u000b\u001a\u00020\n*\u0006\u0012\u0002\b\u00030\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0013\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0012\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017R4\u0010\u001b\u001a\u001c\u0012\u0004\u0012\u00020\u0014\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001a0\u00190\u00188\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Ldev/pandasystems/pandalib/config/ConfigSynchronizer;", "", "<init>", "()V", "", "init$pandalib_common_1_21_10", "init", "Ldev/pandasystems/pandalib/config/ConfigObject;", "Ljava/util/UUID;", "playerUuid", "Ldev/pandasystems/pandalib/networking/payloads/config/CommonConfigPayload;", "createConfigPayload", "(Ldev/pandasystems/pandalib/config/ConfigObject;Ljava/util/UUID;)Ldev/pandasystems/pandalib/networking/payloads/config/CommonConfigPayload;", "", "createConfigPayloadsWithClientConfigs", "()Ljava/util/Collection;", "Ldev/pandasystems/universalserializer/elements/TreeObject;", "tree", "applyConfigPayload", "(Ldev/pandasystems/pandalib/config/ConfigObject;Ldev/pandasystems/universalserializer/elements/TreeObject;Ljava/util/UUID;)V", "Lnet/minecraft/class_2960;", "resourceLocation", "createJsonObject", "(Lnet/minecraft/class_2960;)Ldev/pandasystems/universalserializer/elements/TreeObject;", "", "", "Ldev/pandasystems/pandalib/config/ConfigSynchronizer$SyncableOption;", "configs", "Ljava/util/Map;", "getConfigs$pandalib_common_1_21_10", "()Ljava/util/Map;", "SyncableOption", "pandalib-common-1.21.10"})
@SourceDebugExtension(value={"SMAP\nConfigSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigSynchronizer.kt\ndev/pandasystems/pandalib/config/ConfigSynchronizer\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n216#2:172\n216#2,2:174\n217#2:177\n126#2:178\n153#2,3:179\n126#2:183\n153#2,3:184\n1869#3:173\n1870#3:176\n1#4:182\n*S KotlinDebug\n*F\n+ 1 ConfigSynchronizer.kt\ndev/pandasystems/pandalib/config/ConfigSynchronizer\n*L\n103#1:172\n106#1:174,2\n103#1:177\n112#1:178\n112#1:179,3\n66#1:183\n66#1:184,3\n104#1:173\n104#1:176\n*E\n"})
public final class ConfigSynchronizer {
    @NotNull
    public static final ConfigSynchronizer INSTANCE = new ConfigSynchronizer();
    @NotNull
    private static final Map<class_2960, List<SyncableOption<Object>>> configs = new LinkedHashMap();

    private ConfigSynchronizer() {
    }

    @NotNull
    public final Map<class_2960, List<SyncableOption<Object>>> getConfigs$pandalib_common_1_21_10() {
        return configs;
    }

    public final void init$pandalib_common_1_21_10() {
        PandaLib.INSTANCE.getLogger().debug("Config Synchronizer is initializing...");
        PayloadCodecRegistry.INSTANCE.register(CommonConfigPayload.Companion.getTYPE(), CommonConfigPayload.Companion.getCODEC());
        PayloadCodecRegistry.INSTANCE.register(ClientboundConfigRequestPayload.Companion.getTYPE(), ClientboundConfigRequestPayload.Companion.getCODEC());
        ServerConfigurationNetworking.INSTANCE.registerHandler(CommonConfigPayload.Companion.getTYPE(), ConfigSynchronizer::init$lambda$2);
        if (!configs.isEmpty()) {
            Event.register$default(ServerConfigurationConnectionEventsKt.getServerConfigurationConnectionEvent(), 0, (Function)((Function2)ConfigSynchronizer::init$lambda$6), 1, null);
        }
        PandaLib.INSTANCE.getLogger().debug("Config Synchronizer initialized successfully.");
    }

    @NotNull
    public final CommonConfigPayload createConfigPayload(@NotNull ConfigObject<?> $this$createConfigPayload, @Nullable UUID playerUuid) {
        Intrinsics.checkNotNullParameter($this$createConfigPayload, (String)"<this>");
        class_2960 class_29602 = $this$createConfigPayload.getResourceLocation();
        TreeObject treeObject = this.createJsonObject($this$createConfigPayload.getResourceLocation());
        Optional<UUID> optional = Optional.ofNullable(playerUuid);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return new CommonConfigPayload(class_29602, treeObject, optional);
    }

    public static /* synthetic */ CommonConfigPayload createConfigPayload$default(ConfigSynchronizer configSynchronizer, ConfigObject configObject, UUID uUID, int n, Object object) {
        if ((n & 1) != 0) {
            uUID = null;
        }
        return configSynchronizer.createConfigPayload(configObject, uUID);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<CommonConfigPayload> createConfigPayloadsWithClientConfigs() {
        void $this$mapTo$iv$iv;
        Map payloadValues = new LinkedHashMap();
        Map<class_2960, List<SyncableOption<Object>>> $this$forEach$iv = configs;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry<class_2960, List<SyncableOption<Object>>> element$iv;
            Map.Entry<class_2960, List<SyncableOption<Object>>> entry = element$iv = object.next();
            boolean bl = false;
            class_2960 resourceLocation = entry.getKey();
            List<SyncableOption<Object>> options = entry.getValue();
            Iterable $this$forEach$iv2 = options;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                SyncableOption option = (SyncableOption)element$iv2;
                boolean bl2 = false;
                ConfigObject<?> configObject = option.getConfigObject();
                Map $this$forEach$iv3 = option.getPlayerValues$pandalib_common_1_21_10();
                boolean $i$f$forEach3 = false;
                Iterator iterator = $this$forEach$iv3.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv3;
                    Map.Entry entry2 = element$iv3 = iterator.next();
                    boolean bl3 = false;
                    UUID playerUuid = entry2.getKey();
                    Object value = entry2.getValue();
                    Map map = (Map)payloadValues.computeIfAbsent(playerUuid, arg_0 -> ConfigSynchronizer.createConfigPayloadsWithClientConfigs$lambda$11$lambda$10$lambda$9$lambda$8(arg_0 -> ConfigSynchronizer.createConfigPayloadsWithClientConfigs$lambda$11$lambda$10$lambda$9$lambda$7(resourceLocation, arg_0), arg_0)).getSecond();
                    String string = option.getId();
                    TreeElement treeElement = configObject.getSerializer().toTree(value, option.getValueType());
                    map.put(string, treeElement);
                }
            }
        }
        Map $this$map$iv = payloadValues;
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UUID uuid = (UUID)entry.getKey();
            Pair pair = (Pair)entry.getValue();
            class_2960 class_29602 = (class_2960)pair.getFirst();
            TreeObject treeObject = (TreeObject)pair.getSecond();
            Optional<UUID> optional = Optional.of(uuid);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
            collection.add(new CommonConfigPayload(class_29602, treeObject, optional));
        }
        return (List)destination$iv$iv;
    }

    public final void applyConfigPayload(@NotNull ConfigObject<?> $this$applyConfigPayload, @NotNull TreeObject tree, @Nullable UUID playerUuid) {
        Intrinsics.checkNotNullParameter($this$applyConfigPayload, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        System.out.println(tree);
        List<SyncableOption<Object>> list = configs.get($this$applyConfigPayload.getResourceLocation());
        if (list == null) {
            boolean $i$a$-requireNotNull-ConfigSynchronizer$applyConfigPayload$options$22 = false;
            String $i$a$-requireNotNull-ConfigSynchronizer$applyConfigPayload$options$22 = "Config " + $this$applyConfigPayload.getResourceLocation() + " is not registered";
            throw new IllegalArgumentException($i$a$-requireNotNull-ConfigSynchronizer$applyConfigPayload$options$22.toString());
        }
        List<SyncableOption<Object>> options = list;
        for (SyncableOption<Object> option : options) {
            Serializer serializer = $this$applyConfigPayload.getSerializer();
            Object object = tree.get((Object)option.getId());
            Intrinsics.checkNotNull((Object)object);
            Object deserialized = serializer.fromTree((TreeElement)object, option.getValueType());
            if (deserialized == null) {
                boolean bl = false;
                String string = "Failed to deserialize value for option " + option.getProperty().getName();
                throw new IllegalArgumentException(string.toString());
            }
            if (playerUuid != null) {
                option.getPlayerValues$pandalib_common_1_21_10().put(playerUuid, deserialized);
                continue;
            }
            option.setServerValue(deserialized);
        }
    }

    @NotNull
    public final TreeObject createJsonObject(@NotNull class_2960 resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"resourceLocation");
        List<SyncableOption<Object>> list = configs.get(resourceLocation);
        if (list == null) {
            boolean bl = false;
            String string = "Config " + resourceLocation + " is not registered";
            throw new IllegalArgumentException(string.toString());
        }
        List<SyncableOption<Object>> options = list;
        TreeObject tree = new TreeObject();
        for (SyncableOption<Object> option : options) {
            ConfigObject<?> configObject = option.getConfigObject();
            ((Map)tree).put(option.getId(), configObject.getSerializer().toTree(option.getInitialValue(), option.getValueType()));
        }
        return tree;
    }

    private static final Unit init$lambda$2$lambda$0(CommonConfigPayload $payload, UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PandaLib.INSTANCE.getLogger().debug("Sending config payload to player {}", (Object)it);
        ServerPlayNetworking.INSTANCE.sendToAll($payload, new class_8710[0]);
        return Unit.INSTANCE;
    }

    private static final void init$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void init$lambda$2(CommonConfigPayload payload, ServerConfigurationNetworking.Context context2) {
        ConfigObject configObject;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"<unused var>");
        class_2960 resourceLocation = payload.getResourceLocation();
        TreeObject jsonObject = payload.getOptionObject();
        Optional<UUID> playerId = payload.getPlayerId();
        PandaLib.INSTANCE.getLogger().debug("Received config payload for {}: {}", (Object)resourceLocation, (Object)jsonObject);
        ConfigObject configObject2 = configObject = ConfigRegistry.INSTANCE.get(resourceLocation);
        if (configObject2 != null) {
            INSTANCE.applyConfigPayload(configObject2, jsonObject, (UUID)OptionalsKt.getOrNull(playerId));
        } else {
            PandaLib.INSTANCE.getLogger().error("Received config payload for unknown config object: " + resourceLocation);
        }
        playerId.ifPresent(arg_0 -> ConfigSynchronizer.init$lambda$2$lambda$1(arg_0 -> ConfigSynchronizer.init$lambda$2$lambda$0(payload, arg_0), arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit init$lambda$6(class_8610 handler, MinecraftServer minecraftServer) {
        Collection<CommonConfigPayload> collection;
        Collection<CommonConfigPayload> collection2;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)minecraftServer, (String)"<unused var>");
        PandaLib.INSTANCE.getLogger().debug("Sending all server configs to {}", (Object)handler.method_52404().name());
        Map<class_2960, List<SyncableOption<Object>>> $this$map$iv = configs;
        boolean $i$f$map = false;
        Map<class_2960, List<SyncableOption<Object>>> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            ConfigObject configObject;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            class_2960 resourceLocation = (class_2960)entry.getKey();
            if (ConfigRegistry.INSTANCE.get(resourceLocation) == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            collection3.add(ConfigSynchronizer.createConfigPayload$default(INSTANCE, configObject, null, 1, null));
        }
        List payloads = (List)destination$iv$iv;
        ServerConfigurationNetworking.INSTANCE.send(handler, payloads);
        PandaLib.INSTANCE.getLogger().debug("Sending previous client configs to {}", (Object)handler.method_52404().name());
        Collection<CommonConfigPayload> it = collection2 = INSTANCE.createConfigPayloadsWithClientConfigs();
        boolean bl = false;
        Collection<CommonConfigPayload> collection4 = collection = !it.isEmpty() ? collection2 : null;
        if (collection != null) {
            it = collection;
            boolean bl2 = false;
            ServerConfigurationNetworking.INSTANCE.send(handler, it);
        }
        PandaLib.INSTANCE.getLogger().debug("Sending config request to {}", (Object)handler.method_52404().name());
        UUID uUID = handler.method_52404().id();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"id(...)");
        ServerConfigurationNetworking.INSTANCE.send(handler, new ClientboundConfigRequestPayload(uUID), new class_8710[0]);
        return Unit.INSTANCE;
    }

    private static final Pair createConfigPayloadsWithClientConfigs$lambda$11$lambda$10$lambda$9$lambda$7(class_2960 $resourceLocation, UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TuplesKt.to((Object)$resourceLocation, (Object)new TreeObject());
    }

    private static final Pair createConfigPayloadsWithClientConfigs$lambda$11$lambda$10$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        return (Pair)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\n\u0018\u0000*\n\b\u0000\u0010\u0002*\u0004\u0018\u00010\u00012\u00020\u0001B!\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000b\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\tH\u0086\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u000b\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\rH\u0086\u0002\u00a2\u0006\u0004\b\u000b\u0010\u000eR\u001b\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0016\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001b\u001a\u00020\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010!\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R&\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\"8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R$\u0010'\u001a\u0004\u0018\u00018\u00008F@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b'\u0010(\u001a\u0004\b)\u0010 \"\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Ldev/pandasystems/pandalib/config/ConfigSynchronizer$SyncableOption;", "", "T", "Ldev/pandasystems/pandalib/config/ConfigObject;", "configObject", "Lkotlin/reflect/KProperty0;", "property", "<init>", "(Ldev/pandasystems/pandalib/config/ConfigObject;Lkotlin/reflect/KProperty0;)V", "Ljava/util/UUID;", "player", "get", "(Ljava/util/UUID;)Ljava/lang/Object;", "Lnet/minecraft/class_1657;", "(Lnet/minecraft/class_1657;)Ljava/lang/Object;", "Ldev/pandasystems/pandalib/config/ConfigObject;", "getConfigObject", "()Ldev/pandasystems/pandalib/config/ConfigObject;", "Lkotlin/reflect/KProperty0;", "getProperty", "()Lkotlin/reflect/KProperty0;", "", "id", "Ljava/lang/String;", "getId", "()Ljava/lang/String;", "Lkotlin/reflect/KType;", "valueType", "Lkotlin/reflect/KType;", "getValueType", "()Lkotlin/reflect/KType;", "getInitialValue", "()Ljava/lang/Object;", "initialValue", "", "playerValues", "Ljava/util/Map;", "getPlayerValues$pandalib_common_1_21_10", "()Ljava/util/Map;", "serverValue", "Ljava/lang/Object;", "getServerValue", "setServerValue", "(Ljava/lang/Object;)V", "pandalib-common-1.21.10"})
    public static final class SyncableOption<T> {
        @NotNull
        private final ConfigObject<?> configObject;
        @NotNull
        private final KProperty0<T> property;
        @NotNull
        private final String id;
        @NotNull
        private final KType valueType;
        @NotNull
        private final Map<UUID, T> playerValues;
        @Nullable
        private T serverValue;

        public SyncableOption(@NotNull ConfigObject<?> configObject, @NotNull KProperty0<? extends T> property) {
            Intrinsics.checkNotNullParameter(configObject, (String)"configObject");
            Intrinsics.checkNotNullParameter(property, (String)"property");
            this.configObject = configObject;
            this.property = property;
            class_2960 class_29602 = this.configObject.getResourceLocation();
            String string = this.property.getName();
            List<SyncableOption<Object>> list = INSTANCE.getConfigs$pandalib_common_1_21_10().get(this.configObject.getResourceLocation());
            Intrinsics.checkNotNull(list);
            this.id = class_29602 + "#" + string + "." + list.size();
            this.valueType = this.property.getReturnType();
            this.playerValues = new LinkedHashMap();
        }

        @NotNull
        public final ConfigObject<?> getConfigObject() {
            return this.configObject;
        }

        @NotNull
        public final KProperty0<T> getProperty() {
            return this.property;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final KType getValueType() {
            return this.valueType;
        }

        public final T getInitialValue() {
            return (T)this.property.get();
        }

        @NotNull
        public final Map<UUID, T> getPlayerValues$pandalib_common_1_21_10() {
            return this.playerValues;
        }

        @Nullable
        public final T getServerValue() {
            T t = this.serverValue;
            if (t == null) {
                t = this.getInitialValue();
            }
            return t;
        }

        public final void setServerValue(@Nullable T t) {
            this.serverValue = t;
        }

        public final T get(@NotNull UUID player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            T playerValue = this.playerValues.get(player);
            if (playerValue != null) {
                return playerValue;
            }
            PandaLib.INSTANCE.getLogger().warn("No synced value for player " + player + " in config option " + this.property.getName());
            return this.getInitialValue();
        }

        public final T get(@NotNull class_1657 player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            UUID uUID = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            return this.get(uUID);
        }
    }
}

