/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.debug;

import dev.isxander.controlify.platform.main.PlatformMainUtil;
import dev.isxander.controlify.utils.CUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class DebugProperties {
    private static final List<DebugProperty<?>> properties = new ArrayList();
    public static final boolean DEBUG_LOGGING = DebugProperties.boolProp("controlify.debug.logging", false, true);
    public static final boolean PRINT_VID_PID = DebugProperties.boolProp("controlify.debug.print_vid_pid", false, true);
    public static final boolean DEBUG_SNAPPING = DebugProperties.boolProp("controlify.debug.snapping", false, false);
    public static final boolean FORCE_JOYSTICK = DebugProperties.boolProp("controlify.debug.force_joystick", false, false);
    public static final boolean INIT_DUMP = DebugProperties.boolProp("controlify.debug.init_dump", false, true);
    @Nullable
    public static final String STEAM_DECK_CUSTOM_CEF_URL = DebugProperties.strProp("controlify.debug.steam_deck_custom_cef_url", null, null);
    public static final boolean MIXIN_AUDIT = DebugProperties.boolProp("controlify.debug.mixin_audit", false, false);
    @Nullable
    public static final String SDL_NATIVES_OVERRIDE = DebugProperties.strProp("controlify.debug.sdl_natives_override", null, null);

    public static void printProperties() {
        if (properties.stream().noneMatch(prop -> prop.state() != prop.def())) {
            return;
        }
        String header = "*------------------------ Controlify Debug Properties ------------------------*";
        CUtil.LOGGER.error(header);
        int maxWidth = properties.stream().mapToInt(prop -> prop.name().length()).max().orElse(0);
        for (DebugProperty<?> prop2 : properties) {
            Object line = "| %s%s = %s".formatted(prop2.name(), " ".repeat(maxWidth - prop2.name().length()), prop2.state());
            line = (String)line + " ".repeat(Math.max(0, header.length() - ((String)line).length() - 1)) + "|";
            CUtil.LOGGER.error((String)line);
        }
        CUtil.LOGGER.error("*-----------------------------------------------------------------------------*");
    }

    private static boolean boolProp(String name, boolean defProd, boolean defDev) {
        boolean def = PlatformMainUtil.isDevEnv() ? defDev : defProd;
        boolean enabled = Boolean.parseBoolean(System.getProperty(name, Boolean.toString(def)));
        properties.add(new DebugProperty<Boolean>(name, enabled, def, b -> Boolean.toString(b)));
        return enabled;
    }

    private static String strProp(String name, String defProd, String defDev) {
        String def = PlatformMainUtil.isDevEnv() ? defDev : defProd;
        String enabled = System.getProperty(name, def);
        properties.add(new DebugProperty<String>(name, enabled, def, Function.identity()));
        return enabled;
    }

    private record DebugProperty<T>(String name, T state, T def, Function<T, String> typeToString) {
    }
}

