/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.input.handlers;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.input.KeyNameUtil;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.InputType;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.input.handlers.CombinedInputHandler;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserInputRouter {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String debugName;
    private final CombinedInputHandler combinedInputHandler;
    private final Map<class_3675.class_306, IUserInputHandler> pending = new HashMap<class_3675.class_306, IUserInputHandler>();

    public UserInputRouter(String debugName, IUserInputHandler ... inputHandlers) {
        this.debugName = debugName;
        this.combinedInputHandler = new CombinedInputHandler(debugName, inputHandlers);
    }

    public boolean handleUserInput(class_437 screen, IGuiProperties guiProperties, UserInput input, IInternalKeyMappings keyBindings) {
        if (DebugConfig.isDebugInputsEnabled()) {
            LOGGER.debug("{} received user input: {}", (Object)this.debugName, (Object)input);
        }
        return switch (input.getInputType()) {
            default -> throw new MatchException(null, null);
            case InputType.IMMEDIATE -> this.handleImmediateClick(screen, guiProperties, input, keyBindings);
            case InputType.SIMULATE -> this.handleSimulateClick(screen, guiProperties, input, keyBindings);
            case InputType.EXECUTE -> this.handleExecuteClick(screen, guiProperties, input, keyBindings);
        };
    }

    private boolean handleImmediateClick(class_437 screen, IGuiProperties guiProperties, UserInput input, IInternalKeyMappings keyBindings) {
        IUserInputHandler oldClick = this.pending.remove(input.getKey());
        if (oldClick != null && DebugConfig.isDebugInputsEnabled()) {
            LOGGER.debug("{} canceled previous user input: {}", (Object)this.debugName, (Object)oldClick);
        }
        return this.combinedInputHandler.handleUserInput(screen, guiProperties, input, keyBindings).map(callback -> {
            if (DebugConfig.isDebugInputsEnabled()) {
                LOGGER.debug("{} immediate click handled by: {}\n{}", (Object)this.debugName, callback, (Object)input);
            }
            return true;
        }).orElse(false);
    }

    private boolean handleSimulateClick(class_437 screen, IGuiProperties guiProperties, UserInput input, IInternalKeyMappings keyBindings) {
        IUserInputHandler oldClick = this.pending.remove(input.getKey());
        if (oldClick != null && DebugConfig.isDebugInputsEnabled()) {
            LOGGER.debug("{} canceled pending user input: {}", (Object)this.debugName, (Object)oldClick);
        }
        return this.combinedInputHandler.handleUserInput(screen, guiProperties, input, keyBindings).map(callback -> {
            this.pending.put(input.getKey(), (IUserInputHandler)callback);
            if (DebugConfig.isDebugInputsEnabled()) {
                LOGGER.debug("{} click successfully simulated by: {}\n{}", (Object)this.debugName, callback, (Object)input);
            }
            return true;
        }).orElse(false);
    }

    private boolean handleExecuteClick(class_437 screen, IGuiProperties guiProperties, UserInput input, IInternalKeyMappings keyBindings) {
        return Optional.ofNullable(this.pending.remove(input.getKey())).flatMap(inputHandler -> inputHandler.handleUserInput(screen, guiProperties, input, keyBindings)).map(callback -> {
            if (DebugConfig.isDebugInputsEnabled()) {
                LOGGER.debug("{} click successfully executed by: {}\n{}", (Object)this.debugName, callback, (Object)input);
            }
            return true;
        }).orElse(false);
    }

    public void handleGuiChange() {
        if (DebugConfig.isDebugInputsEnabled()) {
            LOGGER.debug("{}: The GUI has changed, clearing all pending clicks", (Object)this.debugName);
        }
        this.combinedInputHandler.unfocus();
        this.pending.clear();
    }

    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
        return this.combinedInputHandler.handleMouseScrolled(mouseX, mouseY, scrollDeltaX, scrollDeltaY).map(callback -> {
            if (DebugConfig.isDebugInputsEnabled()) {
                LOGGER.debug("{} scroll handled by: {}", (Object)this.debugName, callback);
            }
            return true;
        }).orElse(false);
    }

    public String toString() {
        String pendingString = this.pending.entrySet().stream().map(e -> String.valueOf(KeyNameUtil.getKeyDisplayName((class_3675.class_306)e.getKey())) + ": " + String.valueOf(e.getValue())).collect(Collectors.joining(", ", "[", "]"));
        return "UserInputRouter{debugName='" + this.debugName + "', combinedInputHandler=" + String.valueOf(this.combinedInputHandler) + ", pending=" + pendingString + "}";
    }
}

