/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.bookmarks;

import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.runtime.IJeiKeyMapping;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientToggleState;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.gui.bookmarks.BookmarkList;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.overlay.bookmarks.BookmarkOverlay;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class BookmarkButton
extends GuiIconToggleButton {
    private final BookmarkOverlay bookmarkOverlay;
    private final BookmarkList bookmarkList;
    private final IClientToggleState toggleState;
    private final IInternalKeyMappings keyBindings;

    public static BookmarkButton create(BookmarkOverlay bookmarkOverlay, BookmarkList bookmarkList, IClientToggleState toggleState, IInternalKeyMappings keyBindings) {
        Textures textures = Internal.getTextures();
        IDrawableStatic offIcon = textures.getBookmarkButtonDisabledIcon();
        IDrawableStatic onIcon = textures.getBookmarkButtonEnabledIcon();
        return new BookmarkButton(offIcon, onIcon, bookmarkOverlay, bookmarkList, toggleState, keyBindings);
    }

    private BookmarkButton(IDrawable offIcon, IDrawable onIcon, BookmarkOverlay bookmarkOverlay, BookmarkList bookmarkList, IClientToggleState toggleState, IInternalKeyMappings keyBindings) {
        super(offIcon, onIcon);
        this.bookmarkOverlay = bookmarkOverlay;
        this.bookmarkList = bookmarkList;
        this.toggleState = toggleState;
        this.keyBindings = keyBindings;
    }

    @Override
    protected void getTooltips(JeiTooltip tooltip) {
        if (this.toggleState.isBookmarkOverlayEnabled()) {
            tooltip.add((class_5348)class_2561.method_43471((String)"jei.tooltip.bookmarks.disable"));
        } else {
            tooltip.add((class_5348)class_2561.method_43471((String)"jei.tooltip.bookmarks.enable"));
        }
        IJeiKeyMapping bookmarkKey = this.keyBindings.getBookmark();
        if (bookmarkKey.isUnbound()) {
            class_5250 noKey = class_2561.method_43471((String)"jei.tooltip.bookmarks.usage.nokey");
            tooltip.add((class_5348)noKey.method_27692(class_124.field_1061));
        } else if (!this.bookmarkOverlay.hasRoom()) {
            class_5250 notEnoughSpace = class_2561.method_43471((String)"jei.tooltip.bookmarks.not.enough.space");
            tooltip.add((class_5348)notEnoughSpace.method_27692(class_124.field_1065));
        } else {
            tooltip.addKeyUsageComponent("jei.tooltip.bookmarks.usage.key", bookmarkKey);
        }
    }

    @Override
    protected boolean isIconToggledOn() {
        return this.toggleState.isBookmarkOverlayEnabled();
    }

    @Override
    protected boolean onMouseClicked(UserInput input) {
        if (!this.bookmarkList.isEmpty() && this.bookmarkOverlay.hasRoom()) {
            if (!input.isSimulate()) {
                this.toggleState.toggleBookmarkEnabled();
            }
            return true;
        }
        return false;
    }
}

