/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling;

import com.logisticscraft.occlusionculling.OcclusionCullingInstance;
import com.logisticscraft.occlusionculling.util.Vec3d;
import dev.tr7zw.entityculling.EntityCullingModBase;
import dev.tr7zw.entityculling.NMSCullingHelper;
import dev.tr7zw.entityculling.versionless.EntityCullingVersionlessBase;
import dev.tr7zw.entityculling.versionless.access.Cullable;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_310;

public class CullTask
implements Runnable {
    public boolean requestCull = false;
    public boolean disableEntityCulling = false;
    public boolean disableBlockEntityCulling = false;
    private final OcclusionCullingInstance culling;
    private final class_310 client = class_310.method_1551();
    private final int sleepDelay;
    private final int hitboxLimit;
    private final Set<class_2591<?>> blockEntityWhitelist;
    private final Set<class_1299<?>> entityWhistelist;
    public double lastTime;
    private Vec3d lastPos;
    private Vec3d aabbMin;
    private Vec3d aabbMax;
    private boolean ingame;
    private List<class_1297> entitiesForRendering;
    private Map<class_2338, class_2586> blockEntities;
    private class_243 cameraMC;

    public CullTask(OcclusionCullingInstance culling, Set<class_2591<?>> blockEntityWhitelist, Set<class_1299<?>> entityWhistelist) {
        this.sleepDelay = EntityCullingModBase.instance.config.sleepDelay;
        this.hitboxLimit = EntityCullingModBase.instance.config.hitboxLimit;
        this.lastTime = 0.0;
        this.lastPos = new Vec3d(0.0, 0.0, 0.0);
        this.aabbMin = new Vec3d(0.0, 0.0, 0.0);
        this.aabbMax = new Vec3d(0.0, 0.0, 0.0);
        this.ingame = false;
        this.entitiesForRendering = new ArrayList<class_1297>();
        this.blockEntities = new HashMap<class_2338, class_2586>();
        this.cameraMC = new class_243(0.0, 0.0, 0.0);
        this.culling = culling;
        this.blockEntityWhitelist = blockEntityWhitelist;
        this.entityWhistelist = entityWhistelist;
    }

    @Override
    public void run() {
        while (class_310.method_1551().method_22108()) {
            try {
                Thread.sleep(this.sleepDelay);
                if (EntityCullingVersionlessBase.enabled && this.ingame) {
                    if (!this.requestCull && this.cameraMC.field_1352 == this.lastPos.x && this.cameraMC.field_1351 == this.lastPos.y && this.cameraMC.field_1350 == this.lastPos.z) continue;
                    long start = System.nanoTime();
                    this.requestCull = false;
                    this.lastPos.set(this.cameraMC.field_1352, this.cameraMC.field_1351, this.cameraMC.field_1350);
                    Vec3d camera = this.lastPos;
                    this.culling.resetCache();
                    this.cullBlockEntities(this.cameraMC, camera);
                    this.cullEntities(this.cameraMC, camera);
                    this.lastTime = (double)(System.nanoTime() - start) / 1000000.0;
                    continue;
                }
                this.lastTime = 0.0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("Shutting down culling task!");
    }

    private void cullEntities(class_243 cameraMC, Vec3d camera) {
        if (this.disableEntityCulling) {
            return;
        }
        class_1297 entity2 = null;
        for (class_1297 entity2 : this.entitiesForRendering) {
            Cullable cullable;
            if (entity2 == null) break;
            if (!(entity2 instanceof Cullable) || this.entityWhistelist.contains(entity2.method_5864()) || EntityCullingModBase.instance.isDynamicWhitelisted(entity2) || (cullable = (Cullable)entity2).isForcedVisible()) continue;
            if (class_310.method_1551().method_27022(entity2)) {
                cullable.setCulled(false);
                continue;
            }
            if (!entity2.method_73189().method_24802((class_2374)cameraMC, (double)EntityCullingModBase.instance.config.tracingDistance)) {
                cullable.setCulled(false);
                continue;
            }
            class_238 boundingBox = NMSCullingHelper.getCullingBox(entity2);
            if (boundingBox == null || boundingBox.method_17939() > (double)this.hitboxLimit || boundingBox.method_17940() > (double)this.hitboxLimit || boundingBox.method_17941() > (double)this.hitboxLimit) {
                cullable.setCulled(false);
                continue;
            }
            this.aabbMin.set(boundingBox.field_1323, boundingBox.field_1322, boundingBox.field_1321);
            this.aabbMax.set(boundingBox.field_1320, boundingBox.field_1325, boundingBox.field_1324);
            boolean visible = this.culling.isAABBVisible(this.aabbMin, this.aabbMax, camera);
            cullable.setCulled(!visible);
        }
    }

    private void cullBlockEntities(class_243 cameraMC, Vec3d camera) {
        if (this.disableBlockEntityCulling) {
            return;
        }
        Iterator<Map.Entry<class_2338, class_2586>> iterator = this.blockEntities.entrySet().iterator();
        while (iterator.hasNext()) {
            class_2338 pos;
            Cullable cullable;
            Map.Entry<class_2338, class_2586> entry;
            try {
                entry = iterator.next();
            }
            catch (NullPointerException | ConcurrentModificationException ex) {
                break;
            }
            if (entry == null) break;
            if (this.blockEntityWhitelist.contains(entry.getValue().method_11017()) || this.client.method_31975().method_3550(entry.getValue()) == null || EntityCullingModBase.instance.isDynamicWhitelisted(entry.getValue()) || (cullable = (Cullable)entry.getValue()).isForcedVisible() || !CullTask.closerThan(pos = entry.getKey(), (class_2374)cameraMC, 64.0)) continue;
            class_238 boundingBox = EntityCullingModBase.instance.setupAABB(entry.getValue(), pos);
            if (boundingBox.method_17939() > (double)this.hitboxLimit || boundingBox.method_17940() > (double)this.hitboxLimit || boundingBox.method_17941() > (double)this.hitboxLimit) {
                cullable.setCulled(false);
                continue;
            }
            this.aabbMin.set(boundingBox.field_1323, boundingBox.field_1322, boundingBox.field_1321);
            this.aabbMax.set(boundingBox.field_1320, boundingBox.field_1325, boundingBox.field_1324);
            boolean visible = this.culling.isAABBVisible(this.aabbMin, this.aabbMax, camera);
            cullable.setCulled(!visible);
        }
    }

    private static boolean closerThan(class_2338 blockPos, class_2374 position, double d) {
        return CullTask.distSqr(blockPos, position.method_10216(), position.method_10214(), position.method_10215(), true) < d * d;
    }

    private static double distSqr(class_2338 blockPos, double d, double e, double f, boolean bl) {
        double g = bl ? 0.5 : 0.0;
        double h = (double)blockPos.method_10263() + g - d;
        double i = (double)blockPos.method_10264() + g - e;
        double j = (double)blockPos.method_10260() + g - f;
        return h * h + i * i + j * j;
    }

    @Generated
    public void setIngame(boolean ingame) {
        this.ingame = ingame;
    }

    @Generated
    public void setEntitiesForRendering(List<class_1297> entitiesForRendering) {
        this.entitiesForRendering = entitiesForRendering;
    }

    @Generated
    public void setBlockEntities(Map<class_2338, class_2586> blockEntities) {
        this.blockEntities = blockEntities;
    }

    @Generated
    public void setCameraMC(class_243 cameraMC) {
        this.cameraMC = cameraMC;
    }
}

