/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create;

import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.trains.schedule.condition.FluidThresholdCondition;
import com.zurrtum.create.content.trains.schedule.condition.IdleCargoCondition;
import com.zurrtum.create.content.trains.schedule.condition.ItemThresholdCondition;
import com.zurrtum.create.content.trains.schedule.condition.PlayerPassengerCondition;
import com.zurrtum.create.content.trains.schedule.condition.RedstoneLinkCondition;
import com.zurrtum.create.content.trains.schedule.condition.ScheduleWaitCondition;
import com.zurrtum.create.content.trains.schedule.condition.ScheduledDelay;
import com.zurrtum.create.content.trains.schedule.condition.StationPoweredCondition;
import com.zurrtum.create.content.trains.schedule.condition.StationUnloadedCondition;
import com.zurrtum.create.content.trains.schedule.condition.TimeOfDayCondition;
import com.zurrtum.create.content.trains.schedule.destination.ChangeThrottleInstruction;
import com.zurrtum.create.content.trains.schedule.destination.ChangeTitleInstruction;
import com.zurrtum.create.content.trains.schedule.destination.DeliverPackagesInstruction;
import com.zurrtum.create.content.trains.schedule.destination.DestinationInstruction;
import com.zurrtum.create.content.trains.schedule.destination.FetchPackagesInstruction;
import com.zurrtum.create.content.trains.schedule.destination.ScheduleInstruction;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2960;

public class AllSchedules {
    public static List<Pair<class_2960, Function<class_2960, ? extends ScheduleInstruction>>> INSTRUCTION_TYPES = new ArrayList<Pair<class_2960, Function<class_2960, ? extends ScheduleInstruction>>>();
    public static List<Pair<class_2960, Function<class_2960, ? extends ScheduleWaitCondition>>> CONDITION_TYPES = new ArrayList<Pair<class_2960, Function<class_2960, ? extends ScheduleWaitCondition>>>();
    public static final class_2960 DESTINATION = AllSchedules.registerInstruction("destination", DestinationInstruction::new);
    public static final class_2960 PACKAGE_DELIVERY = AllSchedules.registerInstruction("package_delivery", DeliverPackagesInstruction::new);
    public static final class_2960 PACKAGE_RETRIEVAL = AllSchedules.registerInstruction("package_retrieval", FetchPackagesInstruction::new);
    public static final class_2960 RENAME = AllSchedules.registerInstruction("rename", ChangeTitleInstruction::new);
    public static final class_2960 THROTTLE = AllSchedules.registerInstruction("throttle", ChangeThrottleInstruction::new);
    public static final class_2960 DELAY = AllSchedules.registerCondition("delay", ScheduledDelay::new);
    public static final class_2960 TIME_OF_DAY = AllSchedules.registerCondition("time_of_day", TimeOfDayCondition::new);
    public static final class_2960 FLUID_THRESHOLD = AllSchedules.registerCondition("fluid_threshold", FluidThresholdCondition::new);
    public static final class_2960 ITEM_THRESHOLD = AllSchedules.registerCondition("item_threshold", ItemThresholdCondition::new);
    public static final class_2960 REDSTONE_LINK = AllSchedules.registerCondition("redstone_link", RedstoneLinkCondition::new);
    public static final class_2960 PLAYER_COUNT = AllSchedules.registerCondition("player_count", PlayerPassengerCondition::new);
    public static final class_2960 IDLE = AllSchedules.registerCondition("idle", IdleCargoCondition::new);
    public static final class_2960 UNLOADED = AllSchedules.registerCondition("unloaded", StationUnloadedCondition::new);
    public static final class_2960 POWERED = AllSchedules.registerCondition("powered", StationPoweredCondition::new);

    public static ScheduleInstruction createScheduleInstruction(class_2960 location) {
        for (Pair<class_2960, Function<class_2960, ? extends ScheduleInstruction>> type : INSTRUCTION_TYPES) {
            if (!type.getFirst().equals((Object)location)) continue;
            return type.getSecond().apply(location);
        }
        return null;
    }

    public static ScheduleWaitCondition createScheduleWaitCondition(class_2960 location) {
        for (Pair<class_2960, Function<class_2960, ? extends ScheduleWaitCondition>> type : CONDITION_TYPES) {
            if (!type.getFirst().equals((Object)location)) continue;
            return type.getSecond().apply(location);
        }
        return null;
    }

    private static class_2960 registerInstruction(String name, Function<class_2960, ? extends ScheduleInstruction> factory) {
        class_2960 id = class_2960.method_60655((String)"create", (String)name);
        INSTRUCTION_TYPES.add(Pair.of(id, factory));
        return id;
    }

    private static class_2960 registerCondition(String name, Function<class_2960, ? extends ScheduleWaitCondition> factory) {
        class_2960 id = class_2960.method_60655((String)"create", (String)name);
        CONDITION_TYPES.add(Pair.of(id, factory));
        return id;
    }

    public static void register() {
    }
}

