/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.api.stress;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.registry.SimpleRegistry;
import java.util.function.DoubleSupplier;
import net.minecraft.class_2248;

public class BlockStressValues {
    public static final SimpleRegistry<class_2248, DoubleSupplier> IMPACTS = SimpleRegistry.create();
    public static final SimpleRegistry<class_2248, DoubleSupplier> CAPACITIES = SimpleRegistry.create();
    public static final SimpleRegistry<class_2248, GeneratedRpm> RPM = SimpleRegistry.create();

    public static double getImpact(class_2248 block) {
        DoubleSupplier supplier = IMPACTS.get(block);
        return supplier == null ? 0.0 : supplier.getAsDouble();
    }

    public static double getCapacity(class_2248 block) {
        DoubleSupplier supplier = CAPACITIES.get(block);
        return supplier == null ? 0.0 : supplier.getAsDouble();
    }

    public static void setGeneratorSpeed(class_2248 block, int value) {
        RPM.register(block, new GeneratedRpm(value, false));
    }

    public static void setGeneratorSpeed(class_2248 block, int value, boolean mayGenerateLess) {
        RPM.register(block, new GeneratedRpm(value, mayGenerateLess));
    }

    private BlockStressValues() {
        throw new AssertionError((Object)"This class should not be instantiated");
    }

    public static void register() {
        BlockStressValues.setGeneratorSpeed(AllBlocks.LARGE_WATER_WHEEL, 4);
        BlockStressValues.setGeneratorSpeed(AllBlocks.WATER_WHEEL, 8);
        BlockStressValues.setGeneratorSpeed(AllBlocks.WINDMILL_BEARING, 16, true);
        BlockStressValues.setGeneratorSpeed(AllBlocks.HAND_CRANK, 32);
        BlockStressValues.setGeneratorSpeed(AllBlocks.COPPER_VALVE_HANDLE, 32);
        BlockStressValues.setGeneratorSpeed(AllBlocks.WHITE_VALVE_HANDLE, 32);
        BlockStressValues.setGeneratorSpeed(AllBlocks.ORANGE_VALVE_HANDLE, 32);
        BlockStressValues.setGeneratorSpeed(AllBlocks.MAGENTA_VALVE_HANDLE, 32);
        BlockStressValues.setGeneratorSpeed(AllBlocks.LIGHT_BLUE_VALVE_HANDLE, 32);
        BlockStressValues.setGeneratorSpeed(AllBlocks.YELLOW_VALVE_HANDLE, 32);
        BlockStressValues.setGeneratorSpeed(AllBlocks.LIME_VALVE_HANDLE, 32);
        BlockStressValues.setGeneratorSpeed(AllBlocks.PINK_VALVE_HANDLE, 32);
        BlockStressValues.setGeneratorSpeed(AllBlocks.GRAY_VALVE_HANDLE, 32);
        BlockStressValues.setGeneratorSpeed(AllBlocks.LIGHT_GRAY_VALVE_HANDLE, 32);
        BlockStressValues.setGeneratorSpeed(AllBlocks.CYAN_VALVE_HANDLE, 32);
        BlockStressValues.setGeneratorSpeed(AllBlocks.PURPLE_VALVE_HANDLE, 32);
        BlockStressValues.setGeneratorSpeed(AllBlocks.BLUE_VALVE_HANDLE, 32);
        BlockStressValues.setGeneratorSpeed(AllBlocks.BROWN_VALVE_HANDLE, 32);
        BlockStressValues.setGeneratorSpeed(AllBlocks.GREEN_VALVE_HANDLE, 32);
        BlockStressValues.setGeneratorSpeed(AllBlocks.RED_VALVE_HANDLE, 32);
        BlockStressValues.setGeneratorSpeed(AllBlocks.BLACK_VALVE_HANDLE, 32);
        BlockStressValues.setGeneratorSpeed((class_2248)AllBlocks.STEAM_ENGINE, 64, true);
        BlockStressValues.setGeneratorSpeed(AllBlocks.CREATIVE_MOTOR, 256, true);
    }

    public record GeneratedRpm(int value, boolean mayGenerateLess) {
    }
}

