/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.eiv.view;

import com.zurrtum.create.client.compat.eiv.CreateView;
import com.zurrtum.create.client.compat.eiv.EivClientPlugin;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.CrushWheelRenderState;
import com.zurrtum.create.compat.eiv.display.CrushingDisplay;
import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11256;
import net.minecraft.class_332;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

@Environment(value=EnvType.CLIENT)
public class CrushingView
extends CreateView {
    private final List<SlotContent> results;
    private final SlotContent ingredient;
    private final List<Float> chances;

    public CrushingView(CrushingDisplay display) {
        this.results = display.results.stream().map(SlotContent::of).toList();
        this.chances = display.chances;
        this.ingredient = SlotContent.of(display.ingredient);
    }

    public IEivRecipeViewType getViewType() {
        return EivClientPlugin.CRUSHING;
    }

    public List<SlotContent> getIngredients() {
        return List.of(this.ingredient);
    }

    public List<SlotContent> getResults() {
        return this.results;
    }

    @Override
    protected int placeViewSlots(RecipeViewMenu.SlotDefinition slotDefinition) {
        slotDefinition.addItemSlot(0, 51, 1);
        int size = this.results.size();
        int start = (179 - 19 * size) / 2 + 3;
        for (int i = 0; i < size; ++i) {
            slotDefinition.addItemSlot(i + 1, start + i * 19, 81);
        }
        return size + 1;
    }

    @Override
    protected int bindViewSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        slotFillContext.bindOptionalSlot(0, this.ingredient, SLOT);
        int size = this.results.size();
        for (int i = 0; i < size; ++i) {
            float chance = this.chances.get(i).floatValue();
            if (chance == 1.0f) {
                slotFillContext.bindOptionalSlot(i + 1, this.results.get(i), SLOT);
                continue;
            }
            this.bindChanceSlot(slotFillContext, i + 1, this.results.get(i), chance);
        }
        return size + 1;
    }

    public void renderRecipe(RecipeViewScreen screen, IEivViewRecipe.RecipePosition position, class_332 context, int mouseX, int mouseY, float partialTicks) {
        AllGuiTextures.JEI_DOWN_ARROW.render(context, 72, 5);
        context.field_59826.method_70922((class_11256)new CrushWheelRenderState(new Matrix3x2f((Matrix3x2fc)context.method_51448()), 42, 22));
    }
}

