/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.eiv.view;

import com.zurrtum.create.client.compat.eiv.CreateView;
import com.zurrtum.create.client.compat.eiv.EivClientPlugin;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.SawRenderState;
import com.zurrtum.create.compat.eiv.display.SawingDisplay;
import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11256;
import net.minecraft.class_332;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

@Environment(value=EnvType.CLIENT)
public class SawingView
extends CreateView {
    private final List<SlotContent> results;
    private final List<Float> chances;
    private final SlotContent ingredient;

    public SawingView(SawingDisplay display) {
        this.results = display.results.stream().map(SlotContent::of).toList();
        this.chances = display.chances;
        this.ingredient = SlotContent.of(display.ingredient);
    }

    public IEivRecipeViewType getViewType() {
        return EivClientPlugin.SAWING;
    }

    public List<SlotContent> getIngredients() {
        return List.of(this.ingredient);
    }

    public List<SlotContent> getResults() {
        return this.results;
    }

    @Override
    public int placeViewSlots(RecipeViewMenu.SlotDefinition slotDefinition) {
        int i;
        int size = this.results.size();
        for (i = 0; i < size; ++i) {
            slotDefinition.addItemSlot(i, i % 2 == 0 ? 118 : 137, 44 + i / 2 * -19);
        }
        slotDefinition.addItemSlot(i++, 44, 1);
        return i;
    }

    @Override
    public int bindViewSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        int i;
        int size = this.results.size();
        for (i = 0; i < size; ++i) {
            float chance = this.chances.get(i).floatValue();
            if (chance == 1.0f) {
                slotFillContext.bindOptionalSlot(i, this.results.get(i), SLOT);
                continue;
            }
            this.bindChanceSlot(slotFillContext, i, this.results.get(i), chance);
        }
        slotFillContext.bindOptionalSlot(i++, this.ingredient, SLOT);
        return i;
    }

    public void renderRecipe(RecipeViewScreen screen, IEivViewRecipe.RecipePosition position, class_332 context, int mouseX, int mouseY, float partialTicks) {
        AllGuiTextures.JEI_DOWN_ARROW.render(context, 70, 2);
        AllGuiTextures.JEI_SHADOW.render(context, 55, 51);
        context.field_59826.method_70922((class_11256)new SawRenderState(new Matrix3x2f((Matrix3x2fc)context.method_51448()), 64, 27));
    }
}

