/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.bearing;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.contraptions.bearing.IBearingBlockEntity;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11683;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class BearingRenderer<T extends KineticBlockEntity>
extends KineticBlockEntityRenderer<T, BearingRenderState> {
    public BearingRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public BearingRenderState createRenderState() {
        return new BearingRenderState();
    }

    @Override
    public void updateRenderState(T be, BearingRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.updateRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        if (state.support) {
            return;
        }
        PartialModel top = ((IBearingBlockEntity)be).isWoodenTop() ? AllPartialModels.BEARING_TOP_WOODEN : AllPartialModels.BEARING_TOP;
        state.top = CachedBuffers.partial(top, state.field_62674);
        state.topAngle = (float)((double)(((IBearingBlockEntity)be).getInterpolatedAngle(tickProgress - 1.0f) / 180.0f) * Math.PI);
        state.upAngle = state.axis != class_2350.class_2351.field_11052 ? AngleHelper.rad(AngleHelper.horizontalAngle(state.facing.method_10153())) : -1.0f;
        state.eastAngle = AngleHelper.rad(-90.0f - AngleHelper.verticalAngle(state.facing));
    }

    @Override
    public void updateBaseRenderState(T be, BearingRenderState state, class_1937 world, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.updateBaseRenderState(be, state, world, crumblingOverlay);
        state.facing = (class_2350)state.field_62674.method_11654((class_2769)class_2741.field_12525);
    }

    @Override
    protected class_1921 getRenderType(T be, class_2680 state) {
        return class_1921.method_23577();
    }

    @Override
    protected SuperByteBuffer getRotatedModel(KineticBlockEntity be, BearingRenderState state) {
        return CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.field_62674, state.facing.method_10153());
    }

    @Environment(value=EnvType.CLIENT)
    public static class BearingRenderState
    extends KineticBlockEntityRenderer.KineticRenderState {
        public class_2350 facing;
        public SuperByteBuffer top;
        public float topAngle;
        public float upAngle;
        public float eastAngle;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            super.render(matricesEntry, vertexConsumer);
            this.top.light(this.field_62676);
            this.top.rotateCentered(this.topAngle, this.direction);
            this.top.color(this.color);
            if (this.upAngle != -1.0f) {
                this.top.rotateCentered(this.upAngle, class_2350.field_11036);
            }
            this.top.rotateCentered(this.eastAngle, class_2350.field_11034);
            this.top.renderInto(matricesEntry, vertexConsumer);
        }
    }
}

