/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.ponder.scenes;

import com.mojang.serialization.DynamicOps;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.foundation.ponder.element.BeltItemElement;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.EntityElement;
import com.zurrtum.create.client.ponder.api.element.ParrotElement;
import com.zurrtum.create.client.ponder.api.element.ParrotPose;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.depot.DepotBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2509;
import net.minecraft.class_2680;
import net.minecraft.class_6903;

@Environment(value=EnvType.CLIENT)
public class FanScenes {
    public static void direction(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("fan_direction", "Air flow of Encased Fans");
        scene.configureBasePlate(0, 1, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(3, 1, 0, 3, 1, 5).add(util.select().position(3, 2, 4)), class_2350.field_11033);
        scene.world().showSection(util.select().fromTo(2, 1, 5, 1, 1, 5), class_2350.field_11033);
        scene.idle(10);
        class_2338 fanPos = util.grid().at(1, 1, 4);
        scene.world().showSection(util.select().position(fanPos), class_2350.field_11035);
        scene.idle(40);
        scene.effects().rotationDirectionIndicator(fanPos.method_10072());
        ElementLink<ParrotElement> flappyBirb = scene.special().createBirb(util.vector().topOf(1, 0, 3), ParrotPose.FlappyPose::new);
        scene.idle(2);
        scene.special().rotateParrot(flappyBirb, 0.0, 235.0, 0.0, 30);
        scene.special().moveParrot(flappyBirb, util.vector().of(0.0, 0.0, -2.5), 30);
        scene.idle(20);
        scene.overlay().showText(80).text("Encased Fans use Rotational Force to create an Air Current").attachKeyFrame().placeNearTarget().pointAt(util.vector().topOf(fanPos));
        scene.idle(90);
        class_2338 leverPos = util.grid().at(3, 2, 4);
        Selection reverse = util.select().fromTo(3, 1, 5, 1, 1, 4);
        scene.world().toggleRedstonePower(util.select().fromTo(leverPos, leverPos.method_10074()));
        scene.effects().indicateRedstone(leverPos);
        scene.addKeyframe();
        scene.world().modifyKineticSpeed(reverse, f -> Float.valueOf(-f.floatValue()));
        scene.effects().rotationDirectionIndicator(fanPos.method_10072());
        scene.special().rotateParrot(flappyBirb, 0.0, 430.0, 0.0, 30);
        scene.special().moveParrot(flappyBirb, util.vector().of(0.0, 0.0, 2.5), 30);
        scene.idle(31);
        scene.overlay().showText(60).text("Strength and Direction of Flow depends on the Rotational Input").placeNearTarget().pointAt(util.vector().topOf(fanPos));
        scene.markAsFinished();
        scene.idle(70);
        scene.world().toggleRedstonePower(util.select().fromTo(leverPos, leverPos.method_10074()));
        scene.effects().indicateRedstone(leverPos);
        scene.world().modifyKineticSpeed(reverse, f -> Float.valueOf(-f.floatValue()));
        scene.world().modifyKineticSpeed(util.select().everywhere(), f -> Float.valueOf(4.0f * f.floatValue()));
        scene.effects().rotationSpeedIndicator(fanPos.method_10072());
        scene.special().rotateParrot(flappyBirb, 0.0, 980.0, 0.0, 30);
        scene.special().moveParrot(flappyBirb, util.vector().of(0.0, 0.0, -20.0), 30);
    }

    public static void processing(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("fan_processing", "Processing Items using Encased Fans");
        scene.configureBasePlate(1, 0, 5);
        scene.world().showSection(util.select().layer(0).substract(util.select().position(0, 0, 4)), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(6, 1, 2, 5, 1, 2).add(util.select().position(1, 1, 2)), class_2350.field_11033);
        scene.idle(25);
        class_2338 blockPos = util.grid().at(4, 1, 2);
        ElementLink<WorldSectionElement> blockInFront = scene.world().showIndependentSection(util.select().position(3, 1, 0), class_2350.field_11035);
        scene.world().moveSection(blockInFront, util.vector().of(1.0, 0.0, 2.0), 0);
        scene.world().setBlock(blockPos, class_2246.field_10164.method_9564(), false);
        scene.idle(10);
        scene.overlay().showOutlineWithText(util.select().fromTo(blockPos, blockPos.method_10088(2)), 80).colored(PonderPalette.RED).text("When passing through lava, the Air Flow becomes Heated");
        scene.idle(80);
        class_1799 stack = new class_1799((class_1935)class_1802.field_8775);
        class_1799 smelted = new class_1799((class_1935)class_1802.field_8695);
        ElementLink<EntityElement> entityLink = scene.world().createItemEntity(util.vector().centerOf(blockPos.method_10088(2).method_10086(2)), util.vector().of(0.0, 0.1, 0.0), stack);
        scene.idle(15);
        scene.world().modifyEntity(entityLink, e -> e.method_18800((double)-0.2f, 0.0, 0.0));
        class_243 itemVec = util.vector().blockSurface(util.grid().at(1, 1, 2), class_2350.field_11034).method_1031(0.1, 0.0, 0.0);
        scene.overlay().showControls(itemVec, Pointing.DOWN, 20).withItem(stack);
        scene.idle(20);
        scene.effects().emitParticles(itemVec.method_1031(0.0, (double)0.2f, 0.0), scene.effects().simpleParticleEmitter(class_2398.field_11237, class_243.field_1353), 1.0f, 60);
        scene.overlay().showText(80).colored(PonderPalette.WHITE).pointAt(itemVec).placeNearTarget().attachKeyFrame().text("Items caught in the area will be smelted");
        scene.idle(60);
        scene.world().modifyEntities(class_1542.class, ie -> ie.method_6979(smelted));
        scene.idle(40);
        scene.overlay().showControls(itemVec, Pointing.DOWN, 20).withItem(smelted);
        scene.idle(20);
        scene.world().modifyEntities(class_1542.class, class_1297::method_31472);
        scene.idle(20);
        scene.overlay().showText(80).colored(PonderPalette.RED).pointAt(itemVec).placeNearTarget().text("Food items thrown here would be incinerated");
        scene.idle(40);
        class_2680 campfire = class_2246.field_10036.method_9564();
        scene.world().hideIndependentSection(blockInFront, class_2350.field_11043);
        scene.idle(15);
        scene.world().setBlock(util.grid().at(3, 1, 0), campfire, false);
        scene.world().setBlock(blockPos, campfire, true);
        blockInFront = scene.world().showIndependentSection(util.select().position(3, 1, 0), class_2350.field_11043);
        scene.world().moveSection(blockInFront, util.vector().of(1.0, 0.0, 2.0), 0);
        scene.idle(50);
        scene.overlay().showOutlineWithText(util.select().fromTo(blockPos, blockPos.method_10088(2)), 60).colored(PonderPalette.BLACK).attachKeyFrame().text("Instead, a setup for Smoking using Fire should be used for them");
        scene.idle(80);
        class_2680 water = class_2246.field_10382.method_9564();
        scene.world().hideIndependentSection(blockInFront, class_2350.field_11043);
        scene.idle(15);
        scene.world().setBlock(util.grid().at(3, 1, 0), water, false);
        scene.world().setBlock(blockPos, water, true);
        blockInFront = scene.world().showIndependentSection(util.select().position(3, 1, 0), class_2350.field_11043);
        scene.world().moveSection(blockInFront, util.vector().of(1.0, 0.0, 2.0), 0);
        scene.idle(20);
        scene.overlay().showOutlineWithText(util.select().fromTo(blockPos, blockPos.method_10088(2)), 60).colored(PonderPalette.MEDIUM).attachKeyFrame().text("Air Flows passing through water create a Washing Setup");
        scene.idle(70);
        stack = new class_1799((class_1935)class_1802.field_8200, 16);
        class_1799 washed = new class_1799((class_1935)class_1802.field_8397, 16);
        entityLink = scene.world().createItemEntity(util.vector().centerOf(blockPos.method_10088(2).method_10086(2)), util.vector().of(0.0, 0.1, 0.0), stack);
        scene.idle(15);
        scene.world().modifyEntity(entityLink, e -> e.method_18800((double)-0.2f, 0.0, 0.0));
        scene.overlay().showControls(itemVec, Pointing.DOWN, 20).withItem(stack);
        scene.idle(20);
        scene.effects().emitParticles(itemVec.method_1031(0.0, (double)0.2f, 0.0), scene.effects().simpleParticleEmitter(class_2398.field_11228, class_243.field_1353), 1.0f, 60);
        scene.overlay().showText(50).colored(PonderPalette.WHITE).pointAt(itemVec).placeNearTarget().text("Some interesting new processing can be done with it");
        scene.idle(60);
        scene.world().modifyEntities(class_1542.class, ie -> ie.method_6979(washed));
        scene.overlay().showControls(itemVec, Pointing.DOWN, 20).withItem(washed);
        scene.idle(20);
        scene.world().modifyEntities(class_1542.class, class_1297::method_31472);
        scene.idle(20);
        scene.overlay().showText(100).colored(PonderPalette.RED).pointAt(util.vector().topOf(blockPos.method_10078())).placeNearTarget().attachKeyFrame().text("The Speed of the Fan does NOT affect the processing speed, only its range");
        scene.world().destroyBlock(util.grid().at(1, 1, 2));
        scene.idle(110);
        ElementLink<WorldSectionElement> cogs = scene.world().makeSectionIndependent(util.select().fromTo(6, 1, 2, 6, 0, 3).add(util.select().fromTo(4, 0, 2, 5, 0, 2)));
        scene.world().modifyKineticSpeed(util.select().position(5, 2, 2), f -> Float.valueOf(f.floatValue() / 3.0f));
        scene.world().moveSection(cogs, util.vector().of(0.0, 1.0, 0.0), 15);
        scene.world().moveSection(blockInFront, util.vector().of(0.0, 1.0, 0.0), 15);
        scene.world().destroyBlock(blockPos.method_10078());
        scene.world().showSection(util.select().position(blockPos.method_10078().method_10084()), class_2350.field_11033);
        scene.world().setBlock(blockPos.method_10084(), class_2246.field_10382.method_9564(), false);
        class_1799 sand = new class_1799((class_1935)class_1802.field_8858);
        class_1799 clay = new class_1799((class_1935)class_1802.field_8696);
        scene.idle(20);
        class_2338 depos = util.grid().at(3, 4, 2);
        ElementLink<WorldSectionElement> depot = scene.world().showIndependentSection(util.select().position(depos), class_2350.field_11033);
        scene.world().moveSection(depot, util.vector().of(-1.0, -3.0, 0.0), 0);
        scene.world().createItemOnBeltLike(depos, class_2350.field_11043, sand);
        scene.idle(10);
        class_243 depotTop = util.vector().topOf(2, 1, 2).method_1031(0.0, 0.25, 0.0);
        scene.effects().emitParticles(depotTop, scene.effects().simpleParticleEmitter(class_2398.field_11228, class_243.field_1353), 0.5f, 30);
        scene.idle(30);
        scene.world().modifyBlockEntityNBT(util.select().position(depos), DepotBlockEntity.class, nbt -> {
            class_6903 ops = scene.world().getHolderLookupProvider().method_57093((DynamicOps)class_2509.field_11560);
            nbt.method_67493("HeldItem", TransportedItemStack.CODEC, (DynamicOps)ops, (Object)new TransportedItemStack(clay));
        });
        scene.effects().emitParticles(depotTop, scene.effects().simpleParticleEmitter(class_2398.field_11228, class_243.field_1353), 0.5f, 30);
        scene.overlay().showText(90).pointAt(depotTop).attachKeyFrame().text("Fan Processing can also be applied to Items on Depots and Belts");
        scene.idle(100);
        scene.world().moveSection(depot, util.vector().of(-1.0, 0.0, 0.0), 15);
        scene.idle(15);
        ElementLink<WorldSectionElement> largeCog = scene.world().showIndependentSection(util.select().position(1, 2, 4), class_2350.field_11036);
        ElementLink<WorldSectionElement> belt = scene.world().showIndependentSection(util.select().fromTo(3, 3, 1, 1, 3, 3), class_2350.field_11033);
        scene.world().moveSection(largeCog, util.vector().of(-1.0, -2.0, 0.0), 0);
        scene.world().moveSection(belt, util.vector().of(-1.0, -2.0, 0.0), 0);
        ElementLink<BeltItemElement> transported = scene.world().createItemOnBelt(util.grid().at(3, 3, 3), class_2350.field_11035, sand);
        scene.idle(60);
        scene.effects().emitParticles(depotTop, scene.effects().simpleParticleEmitter(class_2398.field_11228, class_243.field_1353), 0.5f, 25);
        scene.idle(25);
        scene.world().changeBeltItemTo(transported, new class_1799((class_1935)class_1802.field_8696));
        scene.effects().emitParticles(depotTop, scene.effects().simpleParticleEmitter(class_2398.field_11228, class_243.field_1353), 0.5f, 25);
        scene.idle(60);
        scene.world().setKineticSpeed(util.select().position(1, 2, 4).add(util.select().fromTo(3, 3, 1, 1, 3, 3)), 0.0f);
    }
}

