/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.compat.eiv.display;

import com.zurrtum.create.compat.eiv.CreateDisplay;
import com.zurrtum.create.compat.eiv.EivCommonPlugin;
import com.zurrtum.create.content.kinetics.mixer.MixingRecipe;
import com.zurrtum.create.content.processing.recipe.HeatCondition;
import com.zurrtum.create.content.processing.recipe.ProcessingOutput;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import de.crafty.eiv.common.api.recipe.EivRecipeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_6903;
import net.minecraft.class_8786;

public class MixingDisplay
extends CreateDisplay {
    public List<class_1799> results;
    public List<Float> chances;
    public List<FluidStack> fluidResults;
    public List<List<class_1799>> ingredients;
    public List<FluidIngredient> fluidIngredients;
    public HeatCondition heat;

    public MixingDisplay() {
    }

    public MixingDisplay(class_8786<MixingRecipe> entry) {
        MixingRecipe recipe = (MixingRecipe)entry.comp_1933();
        List<ProcessingOutput> outputs = recipe.results();
        int size = outputs.size();
        this.results = new ArrayList<class_1799>(size);
        this.chances = new ArrayList<Float>(size);
        for (ProcessingOutput output : outputs) {
            this.results.add(output.create());
            this.chances.add(Float.valueOf(output.chance()));
        }
        this.fluidResults = recipe.fluidResults();
        this.ingredients = new ArrayList<List<class_1799>>(recipe.ingredients().size());
        MixingDisplay.addSizedIngredient(recipe.ingredients(), this.ingredients);
        this.fluidIngredients = recipe.fluidIngredients();
        this.heat = recipe.heat();
    }

    public void writeToTag(class_2487 tag) {
        class_6903<class_2520> ops = MixingDisplay.getServerOps();
        tag.method_67493("results", STACKS_CODEC, ops, this.results);
        tag.method_67493("chances", CreateCodecs.FLOAT_LIST_CODEC, ops, this.chances);
        if (!this.fluidResults.isEmpty()) {
            tag.method_67494("fluidResults", FLUID_STACKS_CODEC, this.fluidResults);
        }
        tag.method_67493("ingredients", STACKS_LIST_CODEC, ops, this.ingredients);
        if (!this.fluidIngredients.isEmpty()) {
            tag.method_67493("fluidIngredients", FLUID_INGREDIENTS_CODEC, ops, this.fluidIngredients);
        }
        if (this.heat != HeatCondition.NONE) {
            tag.method_67493("heat", HeatCondition.CODEC, ops, (Object)this.heat);
        }
    }

    public void loadFromTag(class_2487 tag) {
        class_6903<class_2520> ops = MixingDisplay.getClientOps();
        this.results = (List)tag.method_67492("results", STACKS_CODEC, ops).orElseThrow();
        this.chances = (List)tag.method_67492("chances", CreateCodecs.FLOAT_LIST_CODEC, ops).orElseThrow();
        this.fluidResults = tag.method_67492("fluidResults", FLUID_STACKS_CODEC, ops).orElse(List.of());
        this.fluidIngredients = tag.method_67492("fluidIngredients", FLUID_INGREDIENTS_CODEC, ops).orElse(List.of());
        this.ingredients = (List)tag.method_67492("ingredients", STACKS_LIST_CODEC, ops).orElseThrow();
        this.heat = tag.method_67492("heat", HeatCondition.CODEC, ops).orElse(HeatCondition.NONE);
    }

    public EivRecipeType<MixingDisplay> getRecipeType() {
        return EivCommonPlugin.MIXING;
    }
}

