/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.actors.roller;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.actors.roller.PaveTask;
import com.zurrtum.create.content.trains.graph.TrackEdge;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.track.BezierConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class TrackPaverV2 {
    public static void pave(PaveTask task, TrackGraph graph, TrackEdge edge, double from, double to) {
        if (edge.isTurn()) {
            TrackPaverV2.paveCurve(task, edge.getTurn(), from, to);
            return;
        }
        class_243 location1 = edge.node1.getLocation().getLocation();
        class_243 location2 = edge.node2.getLocation().getLocation();
        class_243 diff = location2.method_1020(location1);
        class_243 direction = VecHelper.clampComponentWise(diff, 1.0f);
        int extent = (int)Math.round((to - from) / direction.method_1033());
        double length = edge.getLength();
        class_2338 pos = class_2338.method_49638((class_2374)edge.getPosition(graph, class_3532.method_15350((double)from, (double)0.0625, (double)(length - 0.0625)) / length).method_1023(0.0, diff.field_1351 != 0.0 ? 1.0 : 0.5, 0.0));
        TrackPaverV2.paveStraight(task, pos, direction, extent);
    }

    public static void paveStraight(PaveTask task, class_2338 startPos, class_243 direction, int extent) {
        HashSet<class_2338> toPlaceOn = new HashSet<class_2338>();
        class_243 start = VecHelper.getCenterOf((class_2382)startPos);
        class_243 mainNormal = direction.method_1036(new class_243(0.0, 1.0, 0.0));
        class_243 normalizedDirection = direction.method_1029();
        boolean isDiagonalTrack = direction.method_18805(1.0, 0.0, 1.0).method_1033() > 1.125;
        double r1 = (Double)task.getHorizontalInterval().getFirst();
        int flip = (int)Math.signum(r1);
        double r2 = r1 + (double)flip;
        if (isDiagonalTrack) {
            r1 /= (double)class_3532.field_15724;
            r2 /= (double)class_3532.field_15724;
        }
        int currentOffset = (int)(Math.abs(r1) * 2.0 + 0.5);
        int nextOffset = (int)(Math.abs(r2) * 2.0 + 0.5);
        for (int i = 0; i < extent; ++i) {
            boolean placeSides;
            class_243 offset = direction.method_1021((double)i);
            class_243 mainPos = start.method_1031(offset.field_1352, offset.field_1351, offset.field_1350);
            class_243 targetVec = mainPos.method_1019(mainNormal.method_1021((double)(flip * (int)((double)currentOffset / 2.0))));
            if (!isDiagonalTrack) {
                toPlaceOn.add(class_2338.method_49638((class_2374)targetVec));
                continue;
            }
            boolean placeRow = currentOffset % 2 == 0 || nextOffset % 2 == 1;
            boolean bl = placeSides = currentOffset % 2 == 1 || nextOffset % 2 == 0;
            if (placeSides) {
                for (int side : Iterate.positiveAndNegative) {
                    class_243 sideOffset = normalizedDirection.method_1021((double)side).method_1019(mainNormal.method_1029().method_1021((double)flip)).method_1021(0.5);
                    toPlaceOn.add(class_2338.method_49638((class_2374)targetVec.method_1019(sideOffset)));
                }
            }
            if (!placeRow) continue;
            if (Math.abs(currentOffset % 2) == 1) {
                targetVec = mainPos.method_1019(mainNormal.method_1021((double)(flip * (int)((double)(currentOffset + 1) / 2.0))));
            }
            toPlaceOn.add(class_2338.method_49638((class_2374)targetVec));
        }
        toPlaceOn.forEach(task::put);
    }

    public static void paveCurve(PaveTask task, BezierConnection bc, double from, double to) {
        HashMap<Pair<Integer, Integer>, Double> yLevels = new HashMap<Pair<Integer, Integer>, Double>();
        HashMap<Pair<Integer, Integer>, Double> tLevels = new HashMap<Pair<Integer, Integer>, Double>();
        class_2338 bePosition = (class_2338)bc.bePositions.getFirst();
        double radius = -((Double)task.getHorizontalInterval().getFirst()).doubleValue();
        double r1 = radius - 0.575;
        double r2 = radius + 0.575;
        double handleLength = bc.getHandleLength();
        class_243 start = ((class_243)bc.starts.getFirst()).method_1020(class_243.method_24954((class_2382)bePosition)).method_1031(0.0, 0.1875, 0.0);
        class_243 end = ((class_243)bc.starts.getSecond()).method_1020(class_243.method_24954((class_2382)bePosition)).method_1031(0.0, 0.1875, 0.0);
        class_243 startHandle = ((class_243)bc.axes.getFirst()).method_1021(handleLength).method_1019(start);
        class_243 endHandle = ((class_243)bc.axes.getSecond()).method_1021(handleLength).method_1019(end);
        class_243 startNormal = (class_243)bc.normals.getFirst();
        class_243 endNormal = (class_243)bc.normals.getSecond();
        int segCount = bc.getSegmentCount();
        float[] lut = bc.getStepLUT();
        double localFrom = from / bc.getLength();
        double localTo = to / bc.getLength();
        for (int i = 0; i < segCount; ++i) {
            float t1;
            float t = i == segCount ? 1.0f : (float)i * lut[i] / (float)segCount;
            float f = t1 = i + 1 == segCount ? 1.0f : (float)(i + 1) * lut[i + 1] / (float)segCount;
            if ((double)t1 < localFrom || (double)t > localTo) continue;
            class_243 vt = VecHelper.bezier(start, end, startHandle, endHandle, t);
            class_243 vNormal = startNormal.equals((Object)endNormal) ? startNormal : VecHelper.slerp(t, startNormal, endNormal);
            class_243 hNormal = vNormal.method_1036(VecHelper.bezierDerivative(start, end, startHandle, endHandle, t).method_1029()).method_1029();
            vt = vt.method_1019(vNormal.method_1021((double)-1.175f));
            class_243 vt1 = VecHelper.bezier(start, end, startHandle, endHandle, t1);
            class_243 vNormal1 = startNormal.equals((Object)endNormal) ? startNormal : VecHelper.slerp(t1, startNormal, endNormal);
            class_243 hNormal1 = vNormal1.method_1036(VecHelper.bezierDerivative(start, end, startHandle, endHandle, t1).method_1029()).method_1029();
            vt1 = vt1.method_1019(vNormal1.method_1021((double)-1.175f));
            class_243 a3 = vt.method_1019(hNormal.method_1021(r2));
            class_243 b3 = vt1.method_1019(hNormal1.method_1021(r2));
            class_243 c3 = vt1.method_1019(hNormal1.method_1021(r1));
            class_243 d3 = vt.method_1019(hNormal.method_1021(r1));
            class_241 a = TrackPaverV2.vec2(a3);
            class_241 b = TrackPaverV2.vec2(b3);
            class_241 c = TrackPaverV2.vec2(c3);
            class_241 d = TrackPaverV2.vec2(d3);
            class_238 aabb = new class_238(a3, b3).method_991(new class_238(c3, d3));
            double y = vt.method_1019((class_243)vt1).field_1351 / 2.0;
            int scanX = class_3532.method_15357((double)aabb.field_1323);
            while ((double)scanX <= aabb.field_1320) {
                int scanZ = class_3532.method_15357((double)aabb.field_1321);
                while ((double)scanZ <= aabb.field_1324) {
                    Pair<Integer, Integer> key;
                    class_241 p = new class_241((float)scanX + 0.5f, (float)scanZ + 0.5f);
                    if ((TrackPaverV2.isInTriangle(a, b, c, p) || TrackPaverV2.isInTriangle(a, c, d, p)) && (!yLevels.containsKey(key = Pair.of(scanX, scanZ)) || (Double)yLevels.get(key) > y)) {
                        yLevels.put(key, y);
                        tLevels.put(key, (double)(t + t1) / 2.0);
                    }
                    ++scanZ;
                }
                ++scanX;
            }
        }
        for (Map.Entry entry : yLevels.entrySet()) {
            double yValue = (Double)entry.getValue();
            int floor = class_3532.method_15357((double)yValue);
            class_2338 targetPos = new class_2338(((Integer)((Pair)entry.getKey()).getFirst()).intValue(), floor, ((Integer)((Pair)entry.getKey()).getSecond()).intValue()).method_10081((class_2382)bePosition);
            task.put(targetPos.method_10263(), targetPos.method_10260(), (float)targetPos.method_10264() + (yValue - (double)floor >= 0.5 ? 0.5f : 0.0f));
        }
    }

    private static class_241 vec2(class_243 vec3) {
        return new class_241((float)vec3.field_1352, (float)vec3.field_1350);
    }

    private static boolean isInTriangle(class_241 a, class_241 b, class_241 c, class_241 p) {
        float pcx = p.field_1343 - c.field_1343;
        float pcy = p.field_1342 - c.field_1342;
        float cbx = c.field_1343 - b.field_1343;
        float bcy = b.field_1342 - c.field_1342;
        float d = bcy * (a.field_1343 - c.field_1343) + cbx * (a.field_1342 - c.field_1342);
        float s = bcy * pcx + cbx * pcy;
        float t = (c.field_1342 - a.field_1342) * pcx + (a.field_1343 - c.field_1343) * pcy;
        return d < 0.0f ? s <= 0.0f && t <= 0.0f && s + t >= d : s >= 0.0f && t >= 0.0f && s + t <= d;
    }

    public static double lineToPointDiff2d(class_243 l1, class_243 l2, class_243 p) {
        return Math.abs((l2.field_1352 - l1.field_1352) * (l1.field_1350 - p.field_1350) - (l1.field_1352 - p.field_1352) * (l2.field_1350 - l1.field_1350));
    }
}

