/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.armor;

import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllEnchantments;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import net.minecraft.class_6880;
import net.minecraft.class_9274;
import net.minecraft.class_9304;

public class BacktankUtil {
    private static final List<Function<class_1309, List<class_1799>>> BACKTANK_SUPPLIERS = new ArrayList<Function<class_1309, List<class_1799>>>();

    public static List<class_1799> getAllWithAir(class_1309 entity) {
        ArrayList<class_1799> all = new ArrayList<class_1799>();
        for (Function<class_1309, List<class_1799>> supplier : BACKTANK_SUPPLIERS) {
            List<class_1799> result = supplier.apply(entity);
            for (class_1799 stack : result) {
                if (!BacktankUtil.hasAirRemaining(stack)) continue;
                all.add(stack);
            }
        }
        all.sort((a, b) -> Float.compare(BacktankUtil.getAir(a), BacktankUtil.getAir(b)));
        return all;
    }

    public static boolean hasAirRemaining(class_1799 backtank) {
        return BacktankUtil.getAir(backtank) > 0;
    }

    public static int getAir(class_1799 backtank) {
        return Math.min((Integer)backtank.method_58695(AllDataComponents.BACKTANK_AIR, (Object)0), BacktankUtil.maxAir(backtank));
    }

    public static void consumeAir(class_1309 entity, class_1799 backtank, int i) {
        int maxAir = BacktankUtil.maxAir(backtank);
        int air = BacktankUtil.getAir(backtank);
        int newAir = Math.max(air - i, 0);
        backtank.method_57379(AllDataComponents.BACKTANK_AIR, (Object)Math.min(newAir, maxAir));
        if (!(entity instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)entity;
        BacktankUtil.sendWarning(player, air, newAir, (float)maxAir / 10.0f);
        BacktankUtil.sendWarning(player, air, newAir, 1.0f);
    }

    private static void sendWarning(class_3222 player, float air, float newAir, float threshold) {
        if (newAir > threshold) {
            return;
        }
        if (air <= threshold) {
            return;
        }
        boolean depleted = threshold == 1.0f;
        class_5250 component = class_2561.method_43471((String)(depleted ? "create.backtank.depleted" : "create.backtank.low"));
        AllSoundEvents.DENY.play((class_1937)player.method_51469(), null, (class_2382)player.method_24515(), 1.0f, 1.25f);
        AllSoundEvents.STEAM.play((class_1937)player.method_51469(), null, (class_2382)player.method_24515(), 0.5f, 0.5f);
        player.field_13987.method_14364((class_2596)new class_5905(10, 40, 10));
        player.field_13987.method_14364((class_2596)new class_5903((class_2561)class_2561.method_43470((String)"\u26a0 ").method_27692(depleted ? class_124.field_1061 : class_124.field_1065).method_10852((class_2561)component.method_27692(class_124.field_1080))));
        player.field_13987.method_14364((class_2596)new class_5904(class_5244.field_39003));
    }

    public static int maxAir(class_1799 backtank) {
        int enchantLevel = 0;
        class_9304 enchants = backtank.method_58657();
        for (Object2IntMap.Entry entry : enchants.method_57539()) {
            if (!((class_6880)entry.getKey()).method_40225(AllEnchantments.CAPACITY)) continue;
            enchantLevel = entry.getIntValue();
            break;
        }
        return BacktankUtil.maxAir(enchantLevel);
    }

    public static int maxAir(int enchantLevel) {
        return (Integer)AllConfigs.server().equipment.airInBacktank.get() + (Integer)AllConfigs.server().equipment.enchantedBacktankCapacity.get() * enchantLevel;
    }

    public static int maxAirWithoutEnchants() {
        return (Integer)AllConfigs.server().equipment.airInBacktank.get();
    }

    public static boolean canAbsorbDamage(class_1309 entity, int usesPerTank) {
        class_1657 playerEntity;
        if (usesPerTank == 0) {
            return true;
        }
        if (entity instanceof class_1657 && (playerEntity = (class_1657)entity).method_68878()) {
            return true;
        }
        List<class_1799> backtanks = BacktankUtil.getAllWithAir(entity);
        if (backtanks.isEmpty()) {
            return false;
        }
        int cost = Math.max(BacktankUtil.maxAirWithoutEnchants() / usesPerTank, 1);
        BacktankUtil.consumeAir(entity, backtanks.getFirst(), cost);
        return true;
    }

    public static boolean isBarVisible(class_1799 stack, int usesPerTank) {
        if (usesPerTank == 0) {
            return false;
        }
        class_1657 player = AllClientHandle.INSTANCE.getPlayer();
        if (player == null) {
            return false;
        }
        List<class_1799> backtanks = BacktankUtil.getAllWithAir((class_1309)player);
        if (backtanks.isEmpty()) {
            return stack.method_7986();
        }
        return true;
    }

    public static int getBarWidth(class_1799 stack, int usesPerTank) {
        if (usesPerTank == 0) {
            return 13;
        }
        class_1657 player = AllClientHandle.INSTANCE.getPlayer();
        if (player == null) {
            return 13;
        }
        List<class_1799> backtanks = BacktankUtil.getAllWithAir((class_1309)player);
        if (backtanks.isEmpty()) {
            return Math.round(13.0f - (float)stack.method_7919() / (float)stack.method_7936() * 13.0f);
        }
        if (backtanks.size() == 1) {
            return backtanks.getFirst().method_7909().method_31569(backtanks.getFirst());
        }
        int sumBarWidth = backtanks.stream().map(backtank -> backtank.method_7909().method_31569(backtank)).reduce(0, Integer::sum);
        return Math.round((float)sumBarWidth / (float)backtanks.size());
    }

    public static int getBarColor(class_1799 stack, int usesPerTank) {
        if (usesPerTank == 0) {
            return 0;
        }
        class_1657 player = AllClientHandle.INSTANCE.getPlayer();
        if (player == null) {
            return 0;
        }
        List<class_1799> backtanks = BacktankUtil.getAllWithAir((class_1309)player);
        if (backtanks.isEmpty()) {
            return class_3532.method_15369((float)(Math.max(0.0f, 1.0f - (float)stack.method_7919() / (float)stack.method_7936()) / 3.0f), (float)1.0f, (float)1.0f);
        }
        return backtanks.getFirst().method_7909().method_31571(backtanks.getFirst());
    }

    public static void addBacktankSupplier(Function<class_1309, List<class_1799>> supplier) {
        BACKTANK_SUPPLIERS.add(supplier);
    }

    static {
        BacktankUtil.addBacktankSupplier(entity -> {
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            for (class_1304 equipmentSlot : class_9274.field_49224) {
                class_1799 stack;
                if (equipmentSlot == class_1304.field_48824 || !(stack = entity.method_6118(equipmentSlot)).method_41409().method_40220(AllItemTags.PRESSURIZED_AIR_SOURCES)) continue;
                stacks.add(stack);
            }
            return stacks;
        });
    }
}

