/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids.transfer;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.BBHelper;
import com.zurrtum.create.content.fluids.transfer.FluidManipulationBehaviour;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3341;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_6756;
import net.minecraft.class_6757;
import net.minecraft.class_6862;

public class FluidFillingBehaviour
extends FluidManipulationBehaviour {
    public static final BehaviourType<FluidFillingBehaviour> TYPE = new BehaviourType();
    PriorityQueue<FluidManipulationBehaviour.BlockPosEntry> queue = new ObjectHeapPriorityQueue((p, p2) -> -this.comparePositions((FluidManipulationBehaviour.BlockPosEntry)p, (FluidManipulationBehaviour.BlockPosEntry)p2));
    List<FluidManipulationBehaviour.BlockPosEntry> infinityCheckFrontier;
    Set<class_2338> infinityCheckVisited;

    public FluidFillingBehaviour(SmartBlockEntity be) {
        super(be);
        this.revalidateIn = 1;
        this.infinityCheckFrontier = new ArrayList<FluidManipulationBehaviour.BlockPosEntry>();
        this.infinityCheckVisited = new HashSet<class_2338>();
    }

    @Override
    public void tick() {
        class_3611 fluid;
        super.tick();
        if (!this.infinityCheckFrontier.isEmpty() && this.rootPos != null && (fluid = this.getWorld().method_8316(this.rootPos).method_15772()) != class_3612.field_15906) {
            this.continueValidation(fluid);
        }
        if (this.revalidateIn > 0) {
            --this.revalidateIn;
        }
    }

    protected void continueValidation(class_3611 fluid) {
        try {
            this.search(fluid, this.infinityCheckFrontier, this.infinityCheckVisited, (p, d) -> this.infinityCheckFrontier.add(new FluidManipulationBehaviour.BlockPosEntry((class_2338)p, (int)d)), true);
        }
        catch (FluidManipulationBehaviour.ChunkNotLoadedException e) {
            this.infinityCheckFrontier.clear();
            this.infinityCheckVisited.clear();
            this.setLongValidationTimer();
            return;
        }
        int maxBlocks = this.maxBlocks();
        if (this.infinityCheckVisited.size() >= maxBlocks && maxBlocks != -1 && !this.fillInfinite()) {
            if (!this.infinite) {
                this.reset();
                this.infinite = true;
                this.blockEntity.sendData();
            }
            this.infinityCheckFrontier.clear();
            this.setLongValidationTimer();
            return;
        }
        if (!this.infinityCheckFrontier.isEmpty()) {
            return;
        }
        if (this.infinite) {
            this.reset();
            return;
        }
        this.infinityCheckVisited.clear();
    }

    public boolean tryDeposit(class_3611 fluid, class_2338 root, boolean simulate) {
        if (!Objects.equals(root, this.rootPos)) {
            this.reset();
            this.rootPos = root;
            this.queue.enqueue((Object)new FluidManipulationBehaviour.BlockPosEntry(root, 0));
            this.affectedArea = class_3341.method_34390((class_2382)this.rootPos, (class_2382)this.rootPos);
            return false;
        }
        if (this.counterpartActed) {
            this.counterpartActed = false;
            this.softReset(root);
            return false;
        }
        if (this.affectedArea == null) {
            this.affectedArea = class_3341.method_34390((class_2382)root, (class_2382)root);
        }
        if (this.revalidateIn == 0) {
            this.visited.clear();
            this.infinityCheckFrontier.clear();
            this.infinityCheckVisited.clear();
            this.infinityCheckFrontier.add(new FluidManipulationBehaviour.BlockPosEntry(root, 0));
            this.setValidationTimer();
            this.softReset(root);
        }
        class_1937 world = this.getWorld();
        int maxRange = this.maxRange();
        int maxRangeSq = maxRange * maxRange;
        int maxBlocks = this.maxBlocks();
        boolean evaporate = world.method_8597().comp_644() && FluidHelper.isTag(fluid, (class_6862<class_3611>)class_3486.field_15517);
        boolean canPlaceSources = (Boolean)AllConfigs.server().fluids.fluidFillPlaceFluidSourceBlocks.get();
        if (!this.fillInfinite() && this.infinite || evaporate || !canPlaceSources) {
            class_3610 fluidState = world.method_8316(this.rootPos);
            boolean equivalentTo = fluidState.method_15772().method_15780(fluid);
            if (!equivalentTo && !evaporate && canPlaceSources) {
                return false;
            }
            if (simulate) {
                return true;
            }
            this.playEffect(world, root, fluid, false);
            if (evaporate) {
                int i = root.method_10263();
                int j = root.method_10264();
                int k = root.method_10260();
                world.method_43128(null, (double)i, (double)j, (double)k, class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f + (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.8f);
            } else if (!canPlaceSources) {
                this.blockEntity.award(AllAdvancements.HOSE_PULLEY);
            }
            return true;
        }
        boolean success = false;
        for (int i = 0; !success && !this.queue.isEmpty() && i < 1024; ++i) {
            SpaceType spaceType;
            FluidManipulationBehaviour.BlockPosEntry entry = (FluidManipulationBehaviour.BlockPosEntry)this.queue.first();
            class_2338 currentPos = entry.pos();
            if (this.visited.contains(currentPos)) {
                this.queue.dequeue();
                continue;
            }
            if (!simulate) {
                this.visited.add(currentPos);
            }
            if (this.visited.size() >= maxBlocks && maxBlocks != -1) {
                this.infinite = true;
                if (!this.fillInfinite()) {
                    this.visited.clear();
                    this.queue.clear();
                    return false;
                }
            }
            if ((spaceType = this.getAtPos(world, currentPos, fluid)) == SpaceType.BLOCKING) continue;
            if (spaceType == SpaceType.FILLABLE) {
                success = true;
                if (!simulate) {
                    class_6756 pendingFluidTicks;
                    this.playEffect(world, currentPos, fluid, false);
                    class_2680 blockState = world.method_8320(currentPos);
                    if (blockState.method_28498((class_2769)class_2741.field_12508) && fluid.method_15780((class_3611)class_3612.field_15910)) {
                        if (!this.blockEntity.isVirtual()) {
                            world.method_8652(currentPos, this.updatePostWaterlogging((class_2680)blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true))), 18);
                        }
                    } else {
                        this.replaceBlock(world, currentPos, blockState);
                        if (!this.blockEntity.isVirtual()) {
                            world.method_8652(currentPos, FluidHelper.convertToStill(fluid).method_15785().method_15759(), 18);
                        }
                    }
                    if ((pendingFluidTicks = world.method_8405()) instanceof class_6757) {
                        class_6757 serverTickList = (class_6757)pendingFluidTicks;
                        serverTickList.method_39380(new class_3341(currentPos));
                    }
                    this.affectedArea = BBHelper.encapsulate(this.affectedArea, currentPos);
                }
            }
            if (simulate && success) {
                return true;
            }
            this.visited.add(currentPos);
            this.queue.dequeue();
            for (class_2350 side : Iterate.directions) {
                SpaceType nextSpaceType;
                class_2338 offsetPos;
                if (side == class_2350.field_11036 || this.visited.contains(offsetPos = currentPos.method_10093(side)) || offsetPos.method_10262((class_2382)this.rootPos) > (double)maxRangeSq || (nextSpaceType = this.getAtPos(world, offsetPos, fluid)) == SpaceType.BLOCKING) continue;
                this.queue.enqueue((Object)new FluidManipulationBehaviour.BlockPosEntry(offsetPos, entry.distance() + 1));
            }
        }
        if (!simulate && success) {
            this.blockEntity.award(AllAdvancements.HOSE_PULLEY);
        }
        return success;
    }

    protected void softReset(class_2338 root) {
        this.visited.clear();
        this.queue.clear();
        this.queue.enqueue((Object)new FluidManipulationBehaviour.BlockPosEntry(root, 0));
        this.infinite = false;
        this.setValidationTimer();
        this.blockEntity.sendData();
    }

    protected SpaceType getAtPos(class_1937 world, class_2338 pos, class_3611 toFill) {
        class_2680 blockState = world.method_8320(pos);
        class_3610 fluidState = blockState.method_26227();
        if (blockState.method_28498((class_2769)class_2741.field_12508)) {
            return toFill.method_15780((class_3611)class_3612.field_15910) ? (((Boolean)blockState.method_11654((class_2769)class_2741.field_12508)).booleanValue() ? SpaceType.FILLED : SpaceType.FILLABLE) : SpaceType.BLOCKING;
        }
        if (blockState.method_26204() instanceof class_2404) {
            return (Integer)blockState.method_11654((class_2769)class_2404.field_11278) == 0 ? (toFill.method_15780(fluidState.method_15772()) ? SpaceType.FILLED : SpaceType.BLOCKING) : SpaceType.FILLABLE;
        }
        if (fluidState.method_15772() != class_3612.field_15906 && blockState.method_26194((class_1922)this.getWorld(), pos, class_3726.method_16194()).method_1110()) {
            return toFill.method_15780(fluidState.method_15772()) ? SpaceType.FILLED : SpaceType.BLOCKING;
        }
        return this.canBeReplacedByFluid((class_1922)world, pos, blockState) ? SpaceType.FILLABLE : SpaceType.BLOCKING;
    }

    protected void replaceBlock(class_1937 world, class_2338 pos, class_2680 state) {
        class_2586 blockEntity = state.method_31709() ? world.method_8321(pos) : null;
        class_2248.method_9610((class_2680)state, (class_1936)world, (class_2338)pos, (class_2586)blockEntity);
    }

    protected boolean canBeReplacedByFluid(class_1922 world, class_2338 pos, class_2680 pState) {
        class_2248 block = pState.method_26204();
        if (!(block instanceof class_2323 || pState.method_26164(class_3481.field_41282) || pState.method_27852(class_2246.field_9983) || pState.method_27852(class_2246.field_10424) || pState.method_27852(class_2246.field_10422))) {
            if (!(pState.method_27852(class_2246.field_10316) || pState.method_27852(class_2246.field_10027) || pState.method_27852(class_2246.field_10613) || pState.method_27852(class_2246.field_10369))) {
                return !pState.method_51366();
            }
            return false;
        }
        return false;
    }

    protected class_2680 updatePostWaterlogging(class_2680 state) {
        if (state.method_28498((class_2769)class_2741.field_12548)) {
            state = (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    @Override
    public void reset() {
        super.reset();
        this.queue.clear();
        this.infinityCheckFrontier.clear();
        this.infinityCheckVisited.clear();
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    static enum SpaceType {
        FILLABLE,
        FILLED,
        BLOCKING;

    }
}

