/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.fan.processing;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllDamageSources;
import com.zurrtum.create.AllFluidTags;
import com.zurrtum.create.AllRecipeSets;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.content.kinetics.fan.processing.FanProcessingType;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.content.processing.burner.LitBlazeBurnerBlock;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.recipe.CreateRollableRecipe;
import com.zurrtum.create.foundation.recipe.RecipeApplier;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1498;
import net.minecraft.class_1506;
import net.minecraft.class_1560;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2388;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3610;
import net.minecraft.class_3730;
import net.minecraft.class_3862;
import net.minecraft.class_3922;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_8942;
import net.minecraft.class_9334;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import org.jetbrains.annotations.Nullable;

public class AllFanProcessingTypes {
    public static final BlastingType BLASTING = AllFanProcessingTypes.register("blasting", new BlastingType());
    public static final HauntingType HAUNTING = AllFanProcessingTypes.register("haunting", new HauntingType());
    public static final SmokingType SMOKING = AllFanProcessingTypes.register("smoking", new SmokingType());
    public static final SplashingType SPLASHING = AllFanProcessingTypes.register("splashing", new SplashingType());

    private static <T extends FanProcessingType> T register(String name, T type) {
        return (T)((FanProcessingType)class_2378.method_10230(CreateRegistries.FAN_PROCESSING_TYPE, (class_2960)class_2960.method_60655((String)"create", (String)name), type));
    }

    public static void register() {
    }

    public static class BlastingType
    implements FanProcessingType {
        @Override
        public boolean isValidAt(class_1937 level, class_2338 pos) {
            class_3610 fluidState = level.method_8316(pos);
            if (fluidState.method_15767(AllFluidTags.FAN_PROCESSING_CATALYSTS_BLASTING)) {
                return true;
            }
            class_2680 blockState = level.method_8320(pos);
            if (blockState.method_26164(AllBlockTags.FAN_PROCESSING_CATALYSTS_BLASTING)) {
                return !blockState.method_28498(BlazeBurnerBlock.HEAT_LEVEL) || ((BlazeBurnerBlock.HeatLevel)((Object)blockState.method_11654(BlazeBurnerBlock.HEAT_LEVEL))).isAtLeast(BlazeBurnerBlock.HeatLevel.FADING);
            }
            return false;
        }

        @Override
        public int getPriority() {
            return 100;
        }

        @Override
        public boolean canProcess(class_1799 stack, class_1937 level) {
            class_9696 input = new class_9696(stack);
            class_1863 recipeManager = ((class_3218)level).method_64577();
            Optional<class_8786<?>> smeltingRecipe = recipeManager.method_8132(class_3956.field_17546, (class_9695)input, level).filter(AllRecipeTypes.CAN_BE_AUTOMATED);
            if (smeltingRecipe.isPresent()) {
                return true;
            }
            Optional<class_8786<?>> blastingRecipe = recipeManager.method_8132(class_3956.field_17547, (class_9695)input, level).filter(AllRecipeTypes.CAN_BE_AUTOMATED);
            if (blastingRecipe.isPresent()) {
                return true;
            }
            return !stack.method_57826(class_9334.field_54273);
        }

        @Override
        @Nullable
        public List<class_1799> process(class_1799 stack, class_1937 level) {
            class_9696 input = new class_9696(stack);
            class_1863 recipeManager = ((class_3218)level).method_64577();
            Optional<class_8786<?>> smeltingRecipe = recipeManager.method_8132(class_3956.field_17546, (class_9695)input, level).filter(AllRecipeTypes.CAN_BE_AUTOMATED);
            if (smeltingRecipe.isEmpty()) {
                smeltingRecipe = recipeManager.method_8132(class_3956.field_17547, (class_9695)input, level).filter(AllRecipeTypes.CAN_BE_AUTOMATED);
            }
            if (smeltingRecipe.isPresent()) {
                Optional<class_8786<?>> smokingRecipe = recipeManager.method_8132(class_3956.field_17548, (class_9695)input, level).filter(AllRecipeTypes.CAN_BE_AUTOMATED);
                class_5455 registryAccess = level.method_30349();
                class_1799 result = smeltingRecipe.get().comp_1933().method_8116((class_9695)input, (class_7225.class_7874)registryAccess);
                if (smokingRecipe.isEmpty() || !class_1799.method_7984((class_1799)((class_3862)smokingRecipe.get().comp_1933()).method_59998(input, (class_7225.class_7874)registryAccess), (class_1799)result)) {
                    return ItemHelper.multipliedOutput(result, stack.method_7947());
                }
            }
            return Collections.emptyList();
        }

        @Override
        public void spawnProcessingParticles(class_1937 level, class_243 pos) {
            if (level.field_9229.method_43048(8) != 0) {
                return;
            }
            level.method_8406((class_2394)class_2398.field_11237, pos.field_1352, pos.field_1351 + 0.25, pos.field_1350, 0.0, 0.0625, 0.0);
        }

        @Override
        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, class_5819 random) {
            particleAccess.setColor(Color.mixColors(0xFF4400, 0xFF8855, random.method_43057()));
            particleAccess.setAlpha(0.5f);
            if (random.method_43057() < 0.03125f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_11240, 0.25f);
            }
            if (random.method_43057() < 0.0625f) {
                particleAccess.spawnExtraParticle((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10164.method_9564()), 0.25f);
            }
        }

        @Override
        public void affectEntity(class_1297 entity, class_1937 level) {
            if (level.method_8608()) {
                return;
            }
            if (!entity.method_5753()) {
                entity.method_5639(10.0f);
                entity.method_64397((class_3218)level, AllDamageSources.get((class_1937)level).fan_lava, 4.0f);
            }
        }
    }

    public static class HauntingType
    implements FanProcessingType {
        @Override
        public boolean isValidAt(class_1937 level, class_2338 pos) {
            class_3610 fluidState = level.method_8316(pos);
            if (fluidState.method_15767(AllFluidTags.FAN_PROCESSING_CATALYSTS_HAUNTING)) {
                return true;
            }
            class_2680 blockState = level.method_8320(pos);
            if (blockState.method_26164(AllBlockTags.FAN_PROCESSING_CATALYSTS_HAUNTING)) {
                if (blockState.method_26164(class_3481.field_23799) && blockState.method_28498((class_2769)class_3922.field_17352) && !((Boolean)blockState.method_11654((class_2769)class_3922.field_17352)).booleanValue()) {
                    return false;
                }
                return !blockState.method_28498(LitBlazeBurnerBlock.FLAME_TYPE) || blockState.method_11654(LitBlazeBurnerBlock.FLAME_TYPE) == LitBlazeBurnerBlock.FlameType.SOUL;
            }
            return false;
        }

        @Override
        public int getPriority() {
            return 300;
        }

        @Override
        public boolean canProcess(class_1799 stack, class_1937 level) {
            return level.method_8433().method_64678(AllRecipeSets.HAUNTING).method_64701(stack);
        }

        @Override
        @Nullable
        public List<class_1799> process(class_1799 stack, class_1937 level) {
            class_9696 input = new class_9696(stack);
            Optional recipe = ((class_3218)level).method_64577().method_8132(AllRecipeTypes.HAUNTING, (class_9695)input, level);
            return recipe.map(entry -> RecipeApplier.applyRecipeOn(level.method_8409(), stack.method_7947(), input, (CreateRollableRecipe)entry.comp_1933())).orElse(null);
        }

        @Override
        public void spawnProcessingParticles(class_1937 level, class_243 pos) {
            if (level.field_9229.method_43048(8) != 0) {
                return;
            }
            pos = pos.method_1019(VecHelper.offsetRandomly(class_243.field_1353, level.field_9229, 1.0f).method_18805(1.0, (double)0.05f, 1.0).method_1029().method_1021((double)0.15f));
            level.method_8406((class_2394)class_2398.field_22246, pos.field_1352, pos.field_1351 + (double)0.45f, pos.field_1350, 0.0, 0.0, 0.0);
            if (level.field_9229.method_43048(2) == 0) {
                level.method_8406((class_2394)class_2398.field_11251, pos.field_1352, pos.field_1351 + 0.25, pos.field_1350, 0.0, 0.0, 0.0);
            }
        }

        @Override
        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, class_5819 random) {
            particleAccess.setColor(Color.mixColors(0, 1205608, random.method_43057()));
            particleAccess.setAlpha(1.0f);
            if (random.method_43057() < 0.0078125f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_22246, 0.125f);
            }
            if (random.method_43057() < 0.03125f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_11251, 0.125f);
            }
        }

        @Override
        public void affectEntity(class_1297 entity, class_1937 level) {
            if (level.method_8608()) {
                if (entity instanceof class_1498) {
                    class_243 p = entity.method_30950(0.0f);
                    class_243 v = p.method_1031(0.0, 0.5, 0.0).method_1019(VecHelper.offsetRandomly(class_243.field_1353, level.field_9229, 1.0f).method_18805(1.0, (double)0.2f, 1.0).method_1029().method_1021(1.0));
                    level.method_8406((class_2394)class_2398.field_22246, v.field_1352, v.field_1351, v.field_1350, 0.0, (double)0.1f, 0.0);
                    if (level.field_9229.method_43048(3) == 0) {
                        level.method_8406((class_2394)class_2398.field_11237, p.field_1352, p.field_1351 + 0.5, p.field_1350, (double)((level.field_9229.method_43057() - 0.5f) * 0.5f), (double)0.1f, (double)((level.field_9229.method_43057() - 0.5f) * 0.5f));
                    }
                }
                return;
            }
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                livingEntity.method_6092(new class_1293(class_1294.field_5919, 30, 0, false, false));
                livingEntity.method_6092(new class_1293(class_1294.field_5909, 20, 1, false, false));
            }
            if (entity instanceof class_1498) {
                class_1498 horse = (class_1498)entity;
                int progress = AllSynchedDatas.HAUNTING.get((class_1297)horse);
                if (progress < 100) {
                    if (progress % 10 == 0) {
                        level.method_8396(null, entity.method_24515(), (class_3414)class_3417.field_23060.comp_349(), class_3419.field_15254, 1.0f, 1.5f * (float)progress / 100.0f);
                    }
                    AllSynchedDatas.HAUNTING.set((class_1297)horse, progress + 1);
                    return;
                }
                level.method_8396(null, entity.method_24515(), class_3417.field_15222, class_3419.field_15254, 1.25f, 0.65f);
                class_1506 skeletonHorse = (class_1506)class_1299.field_6075.method_5883(level, class_3730.field_16459);
                class_5455 registryManager = level.method_30349();
                try (class_8942.class_11340 logging = new class_8942.class_11340(skeletonHorse.method_71370(), Create.LOGGER);){
                    class_11362 view = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)registryManager);
                    horse.method_5647((class_11372)view);
                    class_2487 serializeNBT = view.method_71475();
                    serializeNBT.method_10551("UUID");
                    skeletonHorse.method_5651(class_11352.method_71417((class_8942)logging, (class_7225.class_7874)registryManager, (class_2487)serializeNBT));
                }
                if (!horse.method_56676().method_7960()) {
                    horse.method_5775((class_3218)level, horse.method_56676());
                }
                skeletonHorse.method_33574(horse.method_30950(0.0f));
                level.method_8649((class_1297)skeletonHorse);
                horse.method_31472();
            }
        }
    }

    public static class SmokingType
    implements FanProcessingType {
        @Override
        public boolean isValidAt(class_1937 level, class_2338 pos) {
            class_3610 fluidState = level.method_8316(pos);
            if (fluidState.method_15767(AllFluidTags.FAN_PROCESSING_CATALYSTS_SMOKING)) {
                return true;
            }
            class_2680 blockState = level.method_8320(pos);
            if (blockState.method_26164(AllBlockTags.FAN_PROCESSING_CATALYSTS_SMOKING)) {
                if (blockState.method_26164(class_3481.field_23799) && blockState.method_28498((class_2769)class_3922.field_17352) && !((Boolean)blockState.method_11654((class_2769)class_3922.field_17352)).booleanValue()) {
                    return false;
                }
                if (blockState.method_28498(LitBlazeBurnerBlock.FLAME_TYPE) && blockState.method_11654(LitBlazeBurnerBlock.FLAME_TYPE) != LitBlazeBurnerBlock.FlameType.REGULAR) {
                    return false;
                }
                return !blockState.method_28498(BlazeBurnerBlock.HEAT_LEVEL) || blockState.method_11654(BlazeBurnerBlock.HEAT_LEVEL) == BlazeBurnerBlock.HeatLevel.SMOULDERING;
            }
            return false;
        }

        @Override
        public int getPriority() {
            return 200;
        }

        @Override
        public boolean canProcess(class_1799 stack, class_1937 level) {
            return ((class_3218)level).method_64577().method_8132(class_3956.field_17548, (class_9695)new class_9696(stack), level).filter(AllRecipeTypes.CAN_BE_AUTOMATED).isPresent();
        }

        @Override
        @Nullable
        public List<class_1799> process(class_1799 stack, class_1937 level) {
            class_9696 input = new class_9696(stack);
            return ((class_3218)level).method_64577().method_8132(class_3956.field_17548, (class_9695)input, level).filter(AllRecipeTypes.CAN_BE_AUTOMATED).map(entry -> ItemHelper.multipliedOutput(((class_3862)entry.comp_1933()).method_59998(input, (class_7225.class_7874)level.method_30349()), stack.method_7947())).orElse(null);
        }

        @Override
        public void spawnProcessingParticles(class_1937 level, class_243 pos) {
            if (level.field_9229.method_43048(8) != 0) {
                return;
            }
            level.method_8406((class_2394)class_2398.field_11203, pos.field_1352, pos.field_1351 + 0.25, pos.field_1350, 0.0, 0.0625, 0.0);
        }

        @Override
        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, class_5819 random) {
            particleAccess.setColor(Color.mixColors(0, 0x555555, random.method_43057()));
            particleAccess.setAlpha(1.0f);
            if (random.method_43057() < 0.03125f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_11251, 0.125f);
            }
            if (random.method_43057() < 0.03125f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_11237, 0.125f);
            }
        }

        @Override
        public void affectEntity(class_1297 entity, class_1937 level) {
            if (level.method_8608()) {
                return;
            }
            if (!entity.method_5753()) {
                entity.method_5639(2.0f);
                entity.method_64397((class_3218)level, AllDamageSources.get((class_1937)level).fan_fire, 2.0f);
            }
        }
    }

    public static class SplashingType
    implements FanProcessingType {
        @Override
        public boolean isValidAt(class_1937 level, class_2338 pos) {
            class_3610 fluidState = level.method_8316(pos);
            if (fluidState.method_15767(AllFluidTags.FAN_PROCESSING_CATALYSTS_SPLASHING)) {
                return true;
            }
            class_2680 blockState = level.method_8320(pos);
            return blockState.method_26164(AllBlockTags.FAN_PROCESSING_CATALYSTS_SPLASHING);
        }

        @Override
        public int getPriority() {
            return 400;
        }

        @Override
        public boolean canProcess(class_1799 stack, class_1937 level) {
            return level.method_8433().method_64678(AllRecipeSets.SPLASHING).method_64701(stack);
        }

        @Override
        @Nullable
        public List<class_1799> process(class_1799 stack, class_1937 level) {
            class_9696 input = new class_9696(stack);
            return ((class_3218)level).method_64577().method_8132(AllRecipeTypes.SPLASHING, (class_9695)input, level).map(entry -> RecipeApplier.applyRecipeOn(level.method_8409(), stack.method_7947(), input, (CreateRollableRecipe)entry.comp_1933())).orElse(null);
        }

        @Override
        public void spawnProcessingParticles(class_1937 level, class_243 pos) {
            if (level.field_9229.method_43048(8) != 0) {
                return;
            }
            level.method_8406((class_2394)new class_2390(22015, 1.0f), pos.field_1352 + (double)((level.field_9229.method_43057() - 0.5f) * 0.5f), pos.field_1351 + 0.5, pos.field_1350 + (double)((level.field_9229.method_43057() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            level.method_8406((class_2394)class_2398.field_11228, pos.field_1352 + (double)((level.field_9229.method_43057() - 0.5f) * 0.5f), pos.field_1351 + 0.5, pos.field_1350 + (double)((level.field_9229.method_43057() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }

        @Override
        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, class_5819 random) {
            particleAccess.setColor(Color.mixColors(0x4499FF, 0x2277FF, random.method_43057()));
            particleAccess.setAlpha(1.0f);
            if (random.method_43057() < 0.03125f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_11247, 0.125f);
            }
            if (random.method_43057() < 0.03125f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_11241, 0.125f);
            }
        }

        @Override
        public void affectEntity(class_1297 entity, class_1937 level) {
            if (level.method_8608()) {
                return;
            }
            if (entity instanceof class_1560 || entity.method_5864() == class_1299.field_6047 || entity.method_5864() == class_1299.field_6099) {
                entity.method_64397((class_3218)level, entity.method_48923().method_48824(), 2.0f);
            }
            if (entity.method_5809()) {
                entity.method_5646();
                level.method_8396(null, entity.method_24515(), class_3417.field_15222, class_3419.field_15254, 0.7f, 1.6f + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.4f);
            }
        }
    }
}

