/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.millstone;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.millstone.MillingRecipe;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.infrastructure.items.SidedItemInventory;
import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3829;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import org.jetbrains.annotations.Nullable;

public class MillstoneBlockEntity
extends KineticBlockEntity
implements class_3829 {
    public MillstoneInventoryHandler capability = new MillstoneInventoryHandler();
    public int timer;
    private MillingRecipe lastRecipe;

    public MillstoneBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.MILLSTONE, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this));
        super.addBehaviours(behaviours);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.MILLSTONE);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        int size = this.capability.method_5439();
        for (int i = 1; i < size; ++i) {
            class_1799 stack = this.capability.method_5438(i);
            if (stack.method_7947() != this.capability.method_58350(stack)) continue;
            return;
        }
        if (this.timer > 0) {
            this.timer -= this.getProcessingSpeed();
            if (this.field_11863.method_8608()) {
                this.spawnParticles();
                return;
            }
            if (this.timer <= 0) {
                this.process();
            }
            return;
        }
        if (this.field_11863.method_8608()) {
            return;
        }
        class_1799 stack = this.capability.method_5438(0);
        if (stack.method_7960()) {
            return;
        }
        class_9696 input = new class_9696(stack);
        if (this.lastRecipe == null || !this.lastRecipe.matches(input, this.field_11863)) {
            Optional recipe = ((class_3218)this.field_11863).method_64577().method_8132(AllRecipeTypes.MILLING, (class_9695)input, this.field_11863);
            if (recipe.isEmpty()) {
                this.timer = 100;
                this.sendData();
            } else {
                this.lastRecipe = (MillingRecipe)((class_8786)recipe.get()).comp_1933();
                this.timer = this.lastRecipe.time();
                this.sendData();
            }
            return;
        }
        this.timer = this.lastRecipe.time();
        this.sendData();
    }

    public void method_5448() {
        this.capability.method_5448();
    }

    @Override
    public void destroy() {
        super.destroy();
        class_1264.method_5451((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1263)this.capability);
    }

    private void process() {
        class_1799 stack = this.capability.method_5438(0);
        class_9696 input = new class_9696(stack);
        if (this.lastRecipe == null || !this.lastRecipe.matches(input, this.field_11863)) {
            Optional recipe = ((class_3218)this.field_11863).method_64577().method_8132(AllRecipeTypes.MILLING, (class_9695)input, this.field_11863);
            if (recipe.isEmpty()) {
                return;
            }
            this.lastRecipe = (MillingRecipe)((class_8786)recipe.get()).comp_1933();
        }
        class_1799 recipeRemainder = stack.method_7909().method_7858();
        int count = stack.method_7947();
        if (count == 1) {
            this.capability.method_5447(0, class_1799.field_8037);
        } else {
            stack.method_7939(count - 1);
            this.capability.method_5447(0, stack);
        }
        this.capability.outputAllowInsertion();
        this.capability.insert(this.lastRecipe.craft(input, this.field_11863.method_8409()));
        if (!recipeRemainder.method_7960()) {
            this.capability.insert(recipeRemainder);
        }
        this.capability.outputForbidInsertion();
        this.award(AllAdvancements.MILLSTONE);
        this.sendData();
        this.method_5431();
    }

    public void spawnParticles() {
        class_1799 stackInSlot = this.capability.method_5438(0);
        if (stackInSlot.method_7960()) {
            return;
        }
        class_2392 data = new class_2392(class_2398.field_11218, stackInSlot);
        float angle = this.field_11863.field_9229.method_43057() * 360.0f;
        class_243 offset = new class_243(0.0, 0.0, 0.5);
        offset = VecHelper.rotate(offset, angle, class_2350.class_2351.field_11052);
        class_243 target = VecHelper.rotate(offset, this.getSpeed() > 0.0f ? 25.0 : -25.0, class_2350.class_2351.field_11052);
        class_243 center = offset.method_1019(VecHelper.getCenterOf((class_2382)this.field_11867));
        target = VecHelper.offsetRandomly(target.method_1020(offset), this.field_11863.field_9229, 0.0078125f);
        this.field_11863.method_8406((class_2394)data, center.field_1352, center.field_1351, center.field_1350, target.field_1352, target.field_1351, target.field_1350);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71465("Timer", this.timer);
        this.capability.write(view);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        this.timer = view.method_71424("Timer", 0);
        this.capability.read(view);
        super.read(view, clientPacket);
    }

    public int getProcessingSpeed() {
        return class_3532.method_15340((int)((int)Math.abs(this.getSpeed() / 16.0f)), (int)1, (int)512);
    }

    private boolean canProcess(class_1799 stack) {
        class_9696 input = new class_9696(stack);
        if (this.lastRecipe != null && this.lastRecipe.matches(input, this.field_11863)) {
            return true;
        }
        Optional recipe = ((class_3218)this.field_11863).method_64577().method_8132(AllRecipeTypes.MILLING, (class_9695)input, this.field_11863);
        if (recipe.isEmpty()) {
            return false;
        }
        this.lastRecipe = (MillingRecipe)((class_8786)recipe.get()).comp_1933();
        return true;
    }

    public class MillstoneInventoryHandler
    implements SidedItemInventory {
        private static final int[] SLOTS = SlotRangeCache.get(10);
        private final class_2371<class_1799> stacks = class_2371.method_10213((int)10, (Object)class_1799.field_8037);
        private boolean check = true;

        public void outputAllowInsertion() {
            this.check = false;
        }

        public void outputForbidInsertion() {
            this.check = true;
        }

        public int method_5439() {
            return 10;
        }

        public int[] method_5494(class_2350 side) {
            return SLOTS;
        }

        public boolean method_5437(int slot, class_1799 stack) {
            return !this.check || MillstoneBlockEntity.this.canProcess(stack);
        }

        public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
            return this.check ? slot == 0 : slot > 0;
        }

        public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
            return slot != 0;
        }

        public class_1799 method_5438(int slot) {
            if (slot >= 10) {
                return class_1799.field_8037;
            }
            return (class_1799)this.stacks.get(slot);
        }

        public void method_5447(int slot, class_1799 stack) {
            if (slot >= 10) {
                return;
            }
            this.stacks.set(slot, (Object)stack);
        }

        @Override
        public void method_5431() {
            MillstoneBlockEntity.this.method_5431();
        }

        public void write(class_11372 view) {
            class_11372.class_11373 list = view.method_71467("Inventory", class_1799.field_49266);
            list.method_71484((Object)((class_1799)this.stacks.getFirst()));
            for (int i = 1; i < 10; ++i) {
                class_1799 stack = (class_1799)this.stacks.get(i);
                if (stack.method_7960()) continue;
                list.method_71484((Object)stack);
            }
        }

        public void read(class_11368 view) {
            List list = view.method_71437("Inventory", class_1799.field_49266).method_71456().toList();
            int i = 0;
            for (class_1799 itemStack : list) {
                this.stacks.set(i++, (Object)itemStack);
            }
            while (i < 10) {
                this.method_5447(i, class_1799.field_8037);
                ++i;
            }
        }
    }
}

