/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.motor;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.zurrtum.create.content.kinetics.motor.CreativeMotorBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerKineticScrollValueBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class CreativeMotorBlockEntity
extends GeneratingKineticBlockEntity {
    public static final int DEFAULT_SPEED = 16;
    public static final int MAX_SPEED = 256;
    public ServerScrollValueBehaviour generatedSpeed;

    public CreativeMotorBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.MOTOR, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        int max = 256;
        this.generatedSpeed = new ServerKineticScrollValueBehaviour(this);
        this.generatedSpeed.between(-max, max);
        this.generatedSpeed.setValue(16);
        this.generatedSpeed.withCallback(i -> this.updateGeneratedRotation());
        behaviours.add(this.generatedSpeed);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    @Override
    public float getGeneratedSpeed() {
        if (!this.method_11010().method_27852((class_2248)AllBlocks.CREATIVE_MOTOR)) {
            return 0.0f;
        }
        return CreativeMotorBlockEntity.convertToDirection(this.generatedSpeed.getValue(), (class_2350)this.method_11010().method_11654((class_2769)CreativeMotorBlock.FACING));
    }
}

