/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.saw;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.BlockBreakingKineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.saw.SawBlock;
import com.zurrtum.create.content.kinetics.saw.TreeCutter;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.processing.recipe.ProcessingInventory;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.recipe.CreateSingleStackRollableRecipe;
import com.zurrtum.create.foundation.recipe.RecipeApplier;
import com.zurrtum.create.foundation.recipe.RecipeFinder;
import com.zurrtum.create.foundation.recipe.TimedRecipe;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2211;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2266;
import net.minecraft.class_2283;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2391;
import net.minecraft.class_2392;
import net.minecraft.class_2393;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2523;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3829;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9288;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import org.jetbrains.annotations.Nullable;

public class SawBlockEntity
extends BlockBreakingKineticBlockEntity
implements class_3829 {
    private static final Object cuttingRecipesKey = new Object();
    public ProcessingInventory inventory;
    private int recipeIndex;
    private ServerFilteringBehaviour filtering;
    public class_1799 playEvent;

    public SawBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.SAW, pos, state);
        this.inventory = new ProcessingInventory(this::start, direction -> direction != class_2350.field_11033).withSlotLimit((Boolean)AllConfigs.server().recipes.bulkCutting.get() == false);
        this.inventory.remainingTime = -1.0f;
        this.recipeIndex = 0;
        this.playEvent = class_1799.field_8037;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        this.filtering = new ServerFilteringBehaviour(this).forRecipes();
        behaviours.add(this.filtering);
        behaviours.add(new DirectBeltInputBehaviour(this).allowingBeltFunnelsWhen(this::canProcess));
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.SAW_PROCESSING);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        this.inventory.write(view);
        view.method_71465("RecipeIndex", this.recipeIndex);
        super.write(view, clientPacket);
        if (!clientPacket || this.playEvent.method_7960()) {
            return;
        }
        view.method_71468("PlayEvent", class_1799.field_24671, (Object)this.playEvent);
        this.playEvent = class_1799.field_8037;
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.inventory.read(view);
        this.recipeIndex = view.method_71424("RecipeIndex", 0);
        this.playEvent = view.method_71426("PlayEvent", class_1799.field_24671).orElse(class_1799.field_8037);
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(this.method_11016()).method_1014(0.125);
    }

    @Override
    public void tick() {
        if (this.shouldRun() && this.ticksUntilNextProgress < 0) {
            this.destroyNextTick();
        }
        super.tick();
        if (!this.canProcess()) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.inventory.remainingTime == -1.0f) {
            if (!this.inventory.method_5442() && !this.inventory.appliedRecipe) {
                this.start(this.inventory.method_5438(0));
            }
            return;
        }
        float processingSpeed = class_3532.method_15363((float)(Math.abs(this.getSpeed()) / 24.0f), (float)1.0f, (float)128.0f);
        this.inventory.remainingTime -= processingSpeed;
        if (this.inventory.remainingTime > 0.0f) {
            this.spawnParticles(this.inventory.method_5438(0));
        }
        if (this.inventory.remainingTime < 5.0f && !this.inventory.appliedRecipe) {
            if (this.field_11863.method_8608()) {
                return;
            }
            this.playEvent = this.inventory.method_5438(0);
            this.applyRecipe();
            this.inventory.appliedRecipe = true;
            this.inventory.recipeDuration = 20.0f;
            this.inventory.remainingTime = 20.0f;
            this.sendData();
            return;
        }
        if (this.inventory.remainingTime > 0.0f) {
            return;
        }
        this.inventory.remainingTime = 0.0f;
        class_243 itemMovement = this.getItemMovementVec();
        class_2350 itemMovementFacing = class_2350.method_10142((double)itemMovement.field_1352, (double)itemMovement.field_1351, (double)itemMovement.field_1350);
        int size = this.inventory.method_5439();
        for (int slot = 0; slot < size; ++slot) {
            class_1799 tryExportingToBeltFunnel;
            class_1799 stack = this.inventory.method_5438(slot);
            if (stack.method_7960() || (tryExportingToBeltFunnel = this.getBehaviour(DirectBeltInputBehaviour.TYPE).tryExportingToBeltFunnel(this.inventory.onExtract(stack.method_7972()), itemMovementFacing.method_10153(), false)) == null) continue;
            int count = tryExportingToBeltFunnel.method_7947();
            if (count != stack.method_7947()) {
                if (count == 0) {
                    this.inventory.method_5447(slot, class_1799.field_8037);
                } else {
                    stack.method_7939(count);
                }
                this.notifyUpdate();
                return;
            }
            if (tryExportingToBeltFunnel.method_7960()) continue;
            return;
        }
        class_2338 nextPos = this.field_11867.method_10081((class_2382)class_2338.method_49638((class_2374)itemMovement));
        DirectBeltInputBehaviour behaviour = BlockEntityBehaviour.get((class_1922)this.field_11863, nextPos, DirectBeltInputBehaviour.TYPE);
        if (behaviour != null) {
            boolean changed = false;
            if (!behaviour.canInsertFromSide(itemMovementFacing)) {
                return;
            }
            if (this.field_11863.method_8608()) {
                return;
            }
            int size2 = this.inventory.method_5439();
            for (int slot = 0; slot < size2; ++slot) {
                class_1799 remainder;
                int count;
                class_1799 stack = this.inventory.method_5438(slot);
                if (stack.method_7960() || (count = (remainder = behaviour.handleInsertion(this.inventory.onExtract(stack.method_7972()), itemMovementFacing, false)).method_7947()) == stack.method_7947()) continue;
                if (count == 0) {
                    this.inventory.method_5447(slot, class_1799.field_8037);
                } else {
                    stack.method_7939(count);
                }
                changed = true;
            }
            if (changed) {
                this.method_5431();
                this.sendData();
            }
            return;
        }
        class_243 outPos = VecHelper.getCenterOf((class_2382)this.field_11867).method_1019(itemMovement.method_1021(0.5).method_1031(0.0, 0.5, 0.0));
        class_243 outMotion = itemMovement.method_1021(0.0625).method_1031(0.0, 0.125, 0.0);
        int size3 = this.inventory.method_5439();
        for (int slot = 0; slot < size3; ++slot) {
            class_1799 stack = this.inventory.method_5438(slot);
            if (stack.method_7960()) continue;
            class_1542 entityIn = new class_1542(this.field_11863, outPos.field_1352, outPos.field_1351, outPos.field_1350, this.inventory.onExtract(stack));
            entityIn.method_18799(outMotion);
            this.field_11863.method_8649((class_1297)entityIn);
        }
        this.inventory.method_5448();
        this.field_11863.method_8455(this.field_11867, this.method_11010().method_26204());
        this.inventory.remainingTime = -1.0f;
        this.sendData();
    }

    public void method_5448() {
        this.inventory.method_5448();
        this.filtering.setFilter(class_1799.field_8037);
    }

    @Override
    public void destroy() {
        super.destroy();
        class_1264.method_5451((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1263)this.inventory);
    }

    public void spawnEventParticles(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return;
        }
        Object particleData = null;
        particleData = stack.method_7909() instanceof class_1747 ? new class_2388(class_2398.field_11217, ((class_1747)stack.method_7909()).method_7711().method_9564()) : new class_2392(class_2398.field_11218, stack);
        class_5819 r = this.field_11863.field_9229;
        class_243 v = VecHelper.getCenterOf((class_2382)this.field_11867).method_1031(0.0, 0.3125, 0.0);
        for (int i = 0; i < 10; ++i) {
            class_243 m = VecHelper.offsetRandomly(new class_243(0.0, 0.25, 0.0), r, 0.125f);
            this.field_11863.method_8406((class_2394)particleData, v.field_1352, v.field_1351, v.field_1350, m.field_1352, m.field_1351, m.field_1351);
        }
    }

    protected void spawnParticles(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return;
        }
        class_2392 particleData = null;
        float speed = 1.0f;
        if (stack.method_7909() instanceof class_1747) {
            particleData = new class_2388(class_2398.field_11217, ((class_1747)stack.method_7909()).method_7711().method_9564());
        } else {
            particleData = new class_2392(class_2398.field_11218, stack);
            speed = 0.125f;
        }
        class_5819 r = this.field_11863.field_9229;
        class_243 vec = this.getItemMovementVec();
        class_243 pos = VecHelper.getCenterOf((class_2382)this.field_11867);
        float offset = this.inventory.recipeDuration != 0.0f ? this.inventory.remainingTime / this.inventory.recipeDuration : 0.0f;
        offset /= 2.0f;
        if (this.inventory.appliedRecipe) {
            offset -= 0.5f;
        }
        this.field_11863.method_8406((class_2394)particleData, pos.method_10216() + -vec.field_1352 * (double)offset, pos.method_10214() + (double)0.45f, pos.method_10215() + -vec.field_1350 * (double)offset, -vec.field_1352 * (double)speed, (double)(r.method_43057() * speed), -vec.field_1350 * (double)speed);
    }

    public class_243 getItemMovementVec() {
        boolean alongX = (Boolean)this.method_11010().method_11654((class_2769)SawBlock.AXIS_ALONG_FIRST_COORDINATE) == false;
        int offset = this.getSpeed() < 0.0f ? -1 : 1;
        return new class_243((double)(offset * (alongX ? 1 : 0)), 0.0, (double)(offset * (alongX ? 0 : -1)));
    }

    private void applyRecipe() {
        class_1799 stack = this.inventory.method_5438(0);
        if (PackageItem.isPackage(stack)) {
            this.inventory.method_5448();
            this.inventory.outputAllowInsertion();
            class_9288 contents = (class_9288)stack.method_58695(AllDataComponents.PACKAGE_CONTENTS, (Object)class_9288.field_49334);
            this.inventory.insert(contents.method_57489().toList());
            this.inventory.outputForbidInsertion();
            return;
        }
        class_9696 input = new class_9696(stack);
        Pair<class_1860<class_9696>, class_1799> pair = this.updateRecipe(input, false);
        if (pair == null) {
            return;
        }
        this.inventory.method_5448();
        List<class_1799> list = SawBlockEntity.getResults(this.field_11863, input, stack, pair);
        int i = 1;
        for (class_1799 result : list) {
            this.inventory.method_5447(i++, result);
        }
        this.award(AllAdvancements.SAW_PROCESSING);
    }

    private static List<class_1799> getResults(class_1937 level, class_9696 input, class_1799 stack, Pair<class_1860<class_9696>, @Nullable class_1799> pair) {
        int rolls = stack.method_7947();
        class_1799 recipeRemainder = stack.method_7909().method_7858();
        class_1799 output = pair.getSecond();
        if (output == null) {
            class_1860<class_9696> recipe = pair.getFirst();
            if (recipe instanceof CreateSingleStackRollableRecipe) {
                CreateSingleStackRollableRecipe rollableRecipe = (CreateSingleStackRollableRecipe)recipe;
                return RecipeApplier.applyRecipeOn(level.method_8409(), rolls, input, rollableRecipe);
            }
            output = recipe.method_8116((class_9695)input, (class_7225.class_7874)level.method_30349());
        }
        if (recipeRemainder.method_7960()) {
            return ItemHelper.multipliedOutput(output, rolls);
        }
        return ItemHelper.multipliedOutput(List.of(output, recipeRemainder), rolls);
    }

    private static boolean matchCuttingRecipe(class_8786<? extends class_1860<?>> entry) {
        return entry.comp_1933().method_17716() == AllRecipeTypes.CUTTING && !AllRecipeTypes.shouldIgnoreInAutomation(entry);
    }

    private static boolean matchAllRecipe(class_8786<? extends class_1860<?>> entry) {
        class_3956 type = entry.comp_1933().method_17716();
        return (type == AllRecipeTypes.CUTTING || type == class_3956.field_17641) && !AllRecipeTypes.shouldIgnoreInAutomation(entry);
    }

    @Nullable
    private Pair<class_1860<class_9696>, class_1799> updateRecipe(class_9696 input, boolean plus) {
        List<class_8786<?>> startedSearch = RecipeFinder.get(cuttingRecipesKey, (class_3218)this.field_11863, (Boolean)AllConfigs.server().recipes.allowStonecuttingOnSaw.get() != false ? SawBlockEntity::matchAllRecipe : SawBlockEntity::matchCuttingRecipe);
        int index = 0;
        class_1860 first = null;
        if (this.filtering.getFilter().method_7960()) {
            for (class_8786<?> entry : startedSearch) {
                class_1860 recipe = entry.comp_1933();
                if (!recipe.method_8115((class_9695)input, this.field_11863)) continue;
                if (first == null) {
                    first = recipe;
                }
                if (index == this.recipeIndex) {
                    if (plus) {
                        ++this.recipeIndex;
                    }
                    return Pair.of(recipe, null);
                }
                ++index;
            }
        } else {
            class_5455 registryManager = this.field_11863.method_30349();
            for (class_8786<?> entry : startedSearch) {
                class_1860 recipe = entry.comp_1933();
                if (!recipe.method_8115((class_9695)input, this.field_11863)) continue;
                if (recipe instanceof CreateSingleStackRollableRecipe) {
                    CreateSingleStackRollableRecipe rollableRecipe = (CreateSingleStackRollableRecipe)recipe;
                    if (!this.filtering.test(rollableRecipe.results().getFirst().create())) continue;
                    return Pair.of(recipe, null);
                }
                class_1799 output = recipe.method_8116((class_9695)input, (class_7225.class_7874)registryManager);
                if (!this.filtering.test(output)) continue;
                return Pair.of(recipe, output);
            }
        }
        this.recipeIndex = 0;
        return first == null ? null : Pair.of(first, null);
    }

    public void insertItem(class_1542 entity) {
        if (!this.canProcess()) {
            return;
        }
        if (!this.inventory.method_5442()) {
            return;
        }
        if (!entity.method_5805()) {
            return;
        }
        if (this.field_11863.method_8608()) {
            return;
        }
        this.inventory.method_5448();
        class_1799 stack = entity.method_6983();
        int count = stack.method_7947();
        int insert = this.inventory.insert(stack);
        if (insert == count) {
            entity.method_31472();
        } else if (insert != 0) {
            stack.method_7934(insert);
            entity.method_6979(stack);
        }
    }

    public void start(class_1799 inserted) {
        if (!this.canProcess()) {
            return;
        }
        if (this.inventory.method_5442()) {
            return;
        }
        if (this.field_11863.method_8608()) {
            return;
        }
        class_9696 input = new class_9696(this.inventory.method_5438(0));
        Pair<class_1860<class_9696>, class_1799> pair = this.updateRecipe(input, true);
        int time = 50;
        if (pair == null) {
            this.inventory.recipeDuration = 10.0f;
            this.inventory.remainingTime = 10.0f;
            this.inventory.appliedRecipe = false;
            this.sendData();
            return;
        }
        class_1860<class_9696> class_18602 = pair.getFirst();
        if (class_18602 instanceof TimedRecipe) {
            TimedRecipe recipe = (TimedRecipe)class_18602;
            time = recipe.time();
        }
        this.inventory.recipeDuration = this.inventory.remainingTime = (float)(time * Math.max(1, inserted.method_7947() / 5));
        this.inventory.appliedRecipe = false;
        this.sendData();
    }

    protected boolean canProcess() {
        return this.method_11010().method_11654((class_2769)SawBlock.FACING) == class_2350.field_11036;
    }

    @Override
    protected boolean shouldRun() {
        return ((class_2350)this.method_11010().method_11654((class_2769)SawBlock.FACING)).method_10166().method_10179();
    }

    @Override
    protected class_2338 getBreakingPos() {
        return this.method_11016().method_10093((class_2350)this.method_11010().method_11654((class_2769)SawBlock.FACING));
    }

    @Override
    public void onBlockBroken(class_2680 stateToBreak) {
        super.onBlockBroken(stateToBreak);
        TreeCutter.findTree((class_1922)this.field_11863, this.breakingPos, stateToBreak).destroyBlocks(this.field_11863, null, this::dropItemFromCutTree);
    }

    public void dropItemFromCutTree(class_2338 pos, class_1799 stack) {
        float distance = (float)Math.sqrt(pos.method_10262((class_2382)this.breakingPos));
        class_243 dropPos = VecHelper.getCenterOf((class_2382)pos);
        class_1542 entity = new class_1542(this.field_11863, dropPos.field_1352, dropPos.field_1351, dropPos.field_1350, stack);
        entity.method_18799(class_243.method_24954((class_2382)this.breakingPos.method_10059((class_2382)this.field_11867)).method_1021((double)(distance / 20.0f)));
        this.field_11863.method_8649((class_1297)entity);
    }

    @Override
    public boolean canBreak(class_2680 stateToBreak, float blockHardness) {
        boolean sawable = SawBlockEntity.isSawable(stateToBreak);
        return super.canBreak(stateToBreak, blockHardness) && sawable;
    }

    public static boolean isSawable(class_2680 stateToBreak) {
        if (stateToBreak.method_26164(class_3481.field_15462)) {
            return false;
        }
        if (TreeCutter.isLog(stateToBreak) || stateToBreak.method_26164(class_3481.field_15503)) {
            return true;
        }
        if (TreeCutter.isRoot(stateToBreak)) {
            return true;
        }
        class_2248 block = stateToBreak.method_26204();
        if (block instanceof class_2211) {
            return true;
        }
        if (block.equals(class_2246.field_46282) || block.equals(class_2246.field_46283)) {
            return true;
        }
        if (block instanceof class_2266) {
            return true;
        }
        if (block instanceof class_2523) {
            return true;
        }
        if (block instanceof class_2391) {
            return true;
        }
        if (block instanceof class_2393) {
            return true;
        }
        return block instanceof class_2283;
    }
}

