/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.packager.repackager;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.compat.computercraft.AbstractComputerBehaviour;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.crate.BottomlessItemHandler;
import com.zurrtum.create.content.logistics.packager.PackagerBlockEntity;
import com.zurrtum.create.content.logistics.packager.PackagerItemHandler;
import com.zurrtum.create.content.logistics.packager.PackagingRequest;
import com.zurrtum.create.content.logistics.packager.repackager.PackageRepackageHelper;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class RepackagerBlockEntity
extends PackagerBlockEntity {
    public PackageRepackageHelper repackageHelper = new PackageRepackageHelper();

    public RepackagerBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.REPACKAGER, pos, state);
    }

    @Override
    public boolean unwrapBox(class_1799 box, boolean simulate) {
        int count;
        if (this.animationTicks > 0) {
            return false;
        }
        class_1263 targetInv = (class_1263)this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            return false;
        }
        boolean targetIsCreativeCrate = targetInv instanceof BottomlessItemHandler;
        boolean anySpace = simulate ? targetInv.countSpace(box, count = box.method_7947()) == count : targetInv.preciseInsert(box);
        if (!targetIsCreativeCrate && !anySpace) {
            return false;
        }
        if (simulate) {
            return true;
        }
        AbstractComputerBehaviour computer = AbstractComputerBehaviour.get(this);
        if (computer != null) {
            computer.queuePackageReceived(box);
        }
        this.previouslyUnwrapped = box;
        this.animationInward = true;
        this.animationTicks = 20;
        this.notifyUpdate();
        return true;
    }

    @Override
    public void recheckIfLinksPresent() {
    }

    @Override
    public boolean redstoneModeActive() {
        return true;
    }

    @Override
    public void attemptToSend(Collection<PackagingRequest> queuedRequests) {
        this.attemptToSend();
    }

    @Override
    public void attemptToSend() {
        if (!this.heldBox.method_7960() || this.animationTicks != 0 || this.buttonCooldown > 0) {
            return;
        }
        if (!this.queuedExitingPackages.isEmpty()) {
            return;
        }
        class_1263 targetInv = (class_1263)this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            return;
        }
        this.attemptToRepackage(targetInv);
        if (this.heldBox.method_7960()) {
            return;
        }
        this.updateSignAddress();
        if (!this.signBasedAddress.isBlank()) {
            PackageItem.addAddress(this.heldBox, this.signBasedAddress);
        }
    }

    protected void attemptToRepackage(class_1263 targetInv) {
        this.repackageHelper.clear();
        int completedOrderId = -1;
        for (class_1799 stack : targetInv) {
            if (stack.method_7960() || !PackageItem.isPackage(stack)) continue;
            if (!this.repackageHelper.isFragmented(stack)) {
                targetInv.extract(stack, 1);
                this.heldBox = stack.method_7972();
                this.animationInward = false;
                this.animationTicks = 20;
                this.notifyUpdate();
                return;
            }
            completedOrderId = this.repackageHelper.addPackageFragment(stack);
            if (completedOrderId == -1) continue;
            break;
        }
        if (completedOrderId == -1) {
            return;
        }
        List<BigItemStack> boxesToExport = this.repackageHelper.repack(completedOrderId, this.field_11863.method_8409());
        if (boxesToExport.isEmpty()) {
            return;
        }
        AbstractComputerBehaviour computer = AbstractComputerBehaviour.get(this);
        if (computer != null) {
            computer.queueRepackage(boxesToExport);
        }
        targetInv.extract(this.repackageHelper.collectedPackages.get(completedOrderId));
        this.queuedExitingPackages.addAll(boxesToExport);
        this.notifyUpdate();
    }
}

