/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.transfer;

import com.zurrtum.create.infrastructure.fluids.FluidItemInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.transfer.FluidInventoryWrapper;
import com.zurrtum.create.infrastructure.transfer.FluidItemContext;
import java.util.ArrayDeque;
import java.util.Deque;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;

public class FluidItemInventoryWrapper
extends FluidInventoryWrapper<Storage<FluidVariant>, StorageView<FluidVariant>>
implements FluidItemInventory {
    private static final Deque<FluidItemInventoryWrapper> POOL = new ArrayDeque<FluidItemInventoryWrapper>();
    private FluidItemContext context;
    private int size;

    private FluidItemInventoryWrapper(Storage<FluidVariant> storage) {
        super(storage);
    }

    public static FluidItemInventory of(Storage<FluidVariant> storage, FluidItemContext context) {
        FluidItemInventoryWrapper inventory = POOL.pollFirst();
        if (inventory == null) {
            inventory = new FluidItemInventoryWrapper(storage);
        } else {
            inventory.storage = storage;
            inventory.init();
        }
        inventory.context = context;
        return inventory;
    }

    @Override
    public void close() {
        this.context.close();
        this.storage = null;
        this.context = null;
        POOL.addLast(this);
    }

    @Override
    public class_1799 getContainer() {
        return this.context.getStack();
    }

    @Override
    public boolean isEmpty() {
        return this.context.getStack().method_7960();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int insert(FluidStack stack) {
        if (!this.storage.supportsInsertion()) {
            return 0;
        }
        return super.insert(stack);
    }

    @Override
    public int insert(FluidStack stack, int maxAmount) {
        if (!this.storage.supportsInsertion()) {
            return 0;
        }
        return super.insert(stack, maxAmount);
    }

    @Override
    public boolean preciseInsert(FluidStack stack) {
        if (!this.storage.supportsInsertion()) {
            return false;
        }
        return super.preciseInsert(stack);
    }

    @Override
    public int extract(FluidStack stack) {
        if (!this.storage.supportsExtraction()) {
            return 0;
        }
        return super.extract(stack);
    }

    @Override
    public int extract(FluidStack stack, int maxAmount) {
        if (!this.storage.supportsExtraction()) {
            return 0;
        }
        return super.extract(stack, maxAmount);
    }

    @Override
    public FluidStack extractAny(int maxAmount) {
        if (!this.storage.supportsExtraction()) {
            return FluidStack.EMPTY;
        }
        return super.extractAny(maxAmount);
    }

    @Override
    public boolean preciseExtract(FluidStack stack) {
        if (!this.storage.supportsExtraction()) {
            return false;
        }
        return super.preciseExtract(stack);
    }

    @Override
    public int count(FluidStack stack) {
        if (!this.storage.supportsExtraction()) {
            return 0;
        }
        return super.count(stack);
    }

    @Override
    public int count(FluidStack stack, int maxAmount) {
        if (!this.storage.supportsExtraction()) {
            return 0;
        }
        return super.count(stack, maxAmount);
    }

    @Override
    public int countSpace(FluidStack stack) {
        if (!this.storage.supportsInsertion()) {
            return 0;
        }
        return super.countSpace(stack);
    }

    @Override
    public int countSpace(FluidStack stack, int maxAmount) {
        if (!this.storage.supportsInsertion()) {
            return 0;
        }
        return super.countSpace(stack, maxAmount);
    }

    @Override
    public FluidStack removeStack(int slot) {
        if (!this.storage.supportsExtraction()) {
            return FluidStack.EMPTY;
        }
        return super.removeStack(slot);
    }

    @Override
    public FluidStack removeStack(int slot, int amount) {
        if (!this.storage.supportsExtraction()) {
            return FluidStack.EMPTY;
        }
        return super.removeStack(slot, amount);
    }

    @Override
    protected void insert(StorageView<FluidVariant> view, FluidVariant variant, int amount, Transaction transaction) {
        this.storage.insert((Object)variant, (long)amount, (TransactionContext)transaction);
    }

    @Override
    protected StorageView<FluidVariant> getSlot(int slot) {
        Storage storage = this.storage;
        if (storage instanceof SlottedStorage) {
            SlottedStorage slottedStorage = (SlottedStorage)storage;
            return slottedStorage.getSlot(slot);
        }
        int current = 0;
        for (StorageView view : this.storage) {
            if (current == slot) {
                return view;
            }
            ++current;
        }
        return null;
    }

    @Override
    protected void init() {
        Storage storage = this.storage;
        if (storage instanceof SlottedStorage) {
            SlottedStorage slottedStorage = (SlottedStorage)storage;
            this.size = slottedStorage.getSlotCount();
            super.init();
        } else {
            int count = 0;
            int max = 0;
            for (StorageView view : this.storage) {
                long capacity = view.getCapacity();
                if ((long)max < capacity) {
                    max = (int)capacity;
                }
                ++count;
            }
            this.size = count;
            this.capacity = max;
        }
    }
}

