/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.skyboxify.skybox;

import btw.lowercase.skyboxify.skybox.components.Biomes;
import btw.lowercase.skyboxify.skybox.components.Blend;
import btw.lowercase.skyboxify.skybox.components.Fade;
import btw.lowercase.skyboxify.skybox.components.Loop;
import btw.lowercase.skyboxify.skybox.components.Range;
import btw.lowercase.skyboxify.skybox.components.Weather;
import btw.lowercase.skyboxify.utils.CommonUtils;
import btw.lowercase.skyboxify.utils.ParserCodecs;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import org.joml.Vector3fc;

public record SkyLayer(class_2960 id, class_2960 texture, Biomes biomes, List<Range> heights, Blend blend, Fade fade, boolean rotate, float speed, Vector3fc axis, Loop loop, int transition, List<Weather> weatherConditions) {
    public static final Codec<SkyLayer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("_id").forGetter(SkyLayer::id), (App)class_2960.field_25139.fieldOf("texture").forGetter(SkyLayer::texture), (App)Biomes.CODEC.optionalFieldOf("biomes", (Object)Biomes.DEFAULT).forGetter(SkyLayer::biomes), (App)Range.CODEC.listOf().optionalFieldOf("heights", (Object)ImmutableList.of()).forGetter(SkyLayer::heights), (App)Blend.CODEC.optionalFieldOf("blend", (Object)Blend.ADD).forGetter(SkyLayer::blend), (App)Fade.CODEC.optionalFieldOf("fade", (Object)Fade.DEFAULT).forGetter(SkyLayer::fade), (App)Codec.BOOL.optionalFieldOf("rotate", (Object)true).forGetter(SkyLayer::rotate), (App)Codec.FLOAT.optionalFieldOf("speed", (Object)Float.valueOf(1.0f)).forGetter(SkyLayer::speed), (App)ParserCodecs.AXIS.optionalFieldOf("axis", (Object)class_3532.field_46243).forGetter(SkyLayer::axis), (App)Loop.CODEC.optionalFieldOf("loop", (Object)Loop.DEFAULT).forGetter(SkyLayer::loop), (App)Codec.INT.optionalFieldOf("transition", (Object)1).forGetter(SkyLayer::transition), (App)ParserCodecs.WEATHER.optionalFieldOf("weather", (Object)ImmutableList.of((Object)((Object)Weather.CLEAR))).forGetter(SkyLayer::weatherConditions)).apply((Applicative)instance, SkyLayer::new));

    private boolean getConditionCheck(class_638 level) {
        class_6880 currentBiome;
        class_1297 cameraEntity = class_310.method_1551().method_1560();
        if (cameraEntity == null) {
            return false;
        }
        class_2338 entityPos = cameraEntity.method_23312();
        if (!(this.biomes.locations().isEmpty() || (currentBiome = level.method_23753(entityPos)).method_40227() && !this.biomes.exclusion() && this.biomes.locations().contains((Object)((class_5321)level.method_23753(cameraEntity.method_24515()).method_40230().orElseThrow()).method_29177()))) {
            return false;
        }
        return this.heights == null || CommonUtils.checkRanges(entityPos.method_10264(), this.heights);
    }

    public float getPositionBrightness(class_638 level, float conditionAlpha) {
        if (this.biomes.locations().isEmpty() && this.heights.isEmpty()) {
            return 1.0f;
        }
        if (conditionAlpha == -1.0f) {
            return this.getConditionCheck(level) ? 1.0f : 0.0f;
        }
        return CommonUtils.calculateConditionAlphaValue(1.0f, 0.0f, conditionAlpha, this.transition * 20, this.getConditionCheck(level));
    }

    public boolean isActive(long dayTime, int clampedTimeOfDay) {
        if (!this.fade.alwaysOn() && CommonUtils.isInTimeInterval(clampedTimeOfDay, this.fade.endOut(), this.fade.startIn())) {
            return false;
        }
        if (this.loop.ranges() != null) {
            long adjustedTime;
            for (adjustedTime = dayTime - (long)this.fade.startIn(); adjustedTime < 0L; adjustedTime += 24000L * (long)this.loop.days()) {
            }
            int daysPassed = (int)(adjustedTime / 24000L);
            int currentDay = daysPassed % this.loop.days();
            return CommonUtils.checkRanges(currentDay, this.loop.ranges());
        }
        return true;
    }
}

