/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.skyboxify.skybox;

import btw.lowercase.skyboxify.api.SkyboxifyApi;
import btw.lowercase.skyboxify.skybox.Skybox;
import btw.lowercase.skyboxify.skybox.SkyboxRenderer;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

public final class SkyboxManager {
    private final List<Skybox> loaded = new ArrayList<Skybox>();
    private final List<Skybox> active = new LinkedList<Skybox>();
    private final SkyboxifyApi api;

    public SkyboxManager(SkyboxifyApi api) {
        this.api = api;
    }

    public void addSkybox(Skybox skybox) {
        if (this.api.getConfig().enabled.isEnabled()) {
            this.loaded.add((Skybox)Preconditions.checkNotNull((Object)skybox, (Object)"Skybox was null"));
        }
    }

    public void clearSkyboxes() {
        SkyboxRenderer.INSTANCE.clearCache();
        this.loaded.clear();
        this.active.clear();
    }

    public void tick(class_638 level) {
        if (this.api.getConfig().enabled.isEnabled()) {
            for (Skybox skybox : this.loaded) {
                skybox.tick(level);
            }
            this.active.removeIf(optiFineSkybox -> !optiFineSkybox.isActive());
            this.loaded.stream().filter(it -> !this.active.contains(it) && it.isActive()).forEach(this.active::add);
        }
    }

    public boolean isEnabled() {
        return this.api.getConfig().enabled.isEnabled() && !this.active.isEmpty();
    }

    public List<Skybox> getSkiesFor(class_5321<@NotNull class_1937> resourceKey) {
        return this.getActive().stream().filter(skybox -> resourceKey.equals(skybox.getDimension())).toList();
    }

    public boolean containsEnabled(class_5321<@NotNull class_1937> resourceKey) {
        return !this.getSkiesFor(resourceKey).isEmpty();
    }

    @Generated
    public List<Skybox> getLoaded() {
        return this.loaded;
    }

    @Generated
    public List<Skybox> getActive() {
        return this.active;
    }
}

