/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block;

import com.mojang.serialization.MapCodec;
import java.util.Objects;
import java.util.Optional;
import net.frozenblock.lib.math.api.AdvancedMath;
import net.frozenblock.wilderwild.block.entity.DisplayLanternBlockEntity;
import net.frozenblock.wilderwild.registry.WWBlockEntityTypes;
import net.frozenblock.wilderwild.registry.WWBlockStateProperties;
import net.frozenblock.wilderwild.registry.WWDataComponents;
import net.frozenblock.wilderwild.registry.WWItems;
import net.frozenblock.wilderwild.registry.WWSounds;
import net.frozenblock.wilderwild.registry.WilderWildRegistries;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayLanternBlock
extends class_2237
implements class_3737 {
    public static final int MAX_FIREFLIES = 4;
    public static final int LIGHT_PER_FIREFLY = 3;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 HANGING = class_2741.field_16561;
    public static final class_2758 DISPLAY_LIGHT = WWBlockStateProperties.DISPLAY_LIGHT;
    public static final MapCodec<DisplayLanternBlock> CODEC = DisplayLanternBlock.method_54094(DisplayLanternBlock::new);
    protected static final class_265 STANDING_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0), (class_265)class_2248.method_9541((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0));
    protected static final class_265 HANGING_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0), (class_265)class_2248.method_9541((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0));

    public DisplayLanternBlock(@NotNull class_4970.class_2251 settings) {
        super(settings.method_50012(class_3619.field_15971));
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)HANGING, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)DISPLAY_LIGHT, (Comparable)Integer.valueOf(0)));
    }

    private static class_2350 attachedDirection(@NotNull class_2680 state) {
        return (Boolean)state.method_11654((class_2769)HANGING) != false ? class_2350.field_11033 : class_2350.field_11036;
    }

    @NotNull
    protected MapCodec<? extends DisplayLanternBlock> method_53969() {
        return CODEC;
    }

    @NotNull
    public class_1269 method_55765(@NotNull class_1799 stack, @NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_1268 hand, @NotNull class_3965 hit) {
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        class_2586 entity = level.method_8321(pos);
        if (entity instanceof DisplayLanternBlockEntity) {
            Optional stack1;
            DisplayLanternBlockEntity lantern = (DisplayLanternBlockEntity)entity;
            if (lantern.invEmpty()) {
                if (stack.method_57826(WWDataComponents.FIREFLY_COLOR)) {
                    class_6880 colorData = (class_6880)stack.method_58694(WWDataComponents.FIREFLY_COLOR);
                    if (colorData != null && lantern.getFireflies().size() < 4) {
                        String name = "";
                        if (stack.method_57826(class_9334.field_49631)) {
                            name = stack.method_7964().getString();
                        }
                        lantern.addFirefly((class_1936)level, ((class_5321)colorData.method_40230().orElseThrow()).method_29177(), name);
                        player.method_5998(hand).method_57008(1, (class_1309)player);
                        player.method_31548().method_7398(new class_1799((class_1935)class_1802.field_8469));
                        level.method_8501(pos, (class_2680)state.method_11657((class_2769)DISPLAY_LIGHT, (Comparable)Integer.valueOf(class_3532.method_15340((int)(lantern.getFireflies().size() * 3), (int)0, (int)15))));
                        level.method_8396(null, pos, WWSounds.ITEM_BOTTLE_PUT_IN_LANTERN_FIREFLY, class_3419.field_15245, 1.0f, level.field_9229.method_43057() * 0.2f + 0.9f);
                        lantern.markForUpdate();
                        level.method_8455(pos, (class_2248)this);
                        return class_1269.field_5812;
                    }
                } else if (stack.method_31574(class_1802.field_8469) && !lantern.getFireflies().isEmpty()) {
                    DisplayLanternBlockEntity.Occupant fireflyInLantern = lantern.getFireflies().get(AdvancedMath.random().method_43048(lantern.getFireflies().size()));
                    level.method_8396(null, pos, WWSounds.ITEM_BOTTLE_CATCH_FIREFLY, class_3419.field_15245, 1.0f, level.field_9229.method_43057() * 0.2f + 0.9f);
                    player.method_5998(hand).method_57008(1, (class_1309)player);
                    class_1799 bottleStack = new class_1799((class_1935)WWItems.FIREFLY_BOTTLE);
                    bottleStack.method_57379(WWDataComponents.FIREFLY_COLOR, (Object)((class_6880)level.method_30349().method_30530(WilderWildRegistries.FIREFLY_COLOR).method_10223(fireflyInLantern.getColor()).orElseThrow()));
                    if (!Objects.equals(fireflyInLantern.customName, "")) {
                        bottleStack.method_57379(class_9334.field_49631, (Object)class_2561.method_30163((String)fireflyInLantern.customName));
                    }
                    player.method_31548().method_7398(bottleStack);
                    ((DisplayLanternBlockEntity)entity).removeFirefly(fireflyInLantern);
                    level.method_8501(pos, (class_2680)state.method_11657((class_2769)DISPLAY_LIGHT, (Comparable)Integer.valueOf(class_3532.method_15340((int)(lantern.getFireflies().size() * 3), (int)0, (int)15))));
                    lantern.markForUpdate();
                    level.method_8455(pos, (class_2248)this);
                    return class_1269.field_5812;
                }
                if (!stack.method_7960() && lantern.noFireflies()) {
                    int light = 0;
                    class_1792 class_17922 = stack.method_7909();
                    if (class_17922 instanceof class_1747) {
                        class_1747 blockItem = (class_1747)class_17922;
                        light = blockItem.method_7711().method_9564().method_26213();
                    } else if (stack.method_7942()) {
                        light = (int)Math.round((double)((class_9304)stack.method_58695(class_9334.field_49633, (Object)class_9304.field_49385)).method_57541() * 0.5);
                    }
                    level.method_8501(pos, (class_2680)state.method_11657((class_2769)DISPLAY_LIGHT, (Comparable)Integer.valueOf(class_3532.method_15340((int)light, (int)0, (int)15))));
                    lantern.inventory.set(0, (Object)stack.method_7971(1));
                    lantern.markForUpdate();
                    level.method_8455(pos, (class_2248)this);
                    return class_1269.field_5812;
                }
            } else if (lantern.noFireflies() && (stack1 = lantern.inventory.stream().findFirst()).isPresent()) {
                DisplayLanternBlock.method_9577((class_1937)level, (class_2338)pos, (class_1799)((class_1799)stack1.get()));
                lantern.inventory.clear();
                lantern.markForUpdate();
                level.method_8501(pos, (class_2680)state.method_11657((class_2769)DISPLAY_LIGHT, (Comparable)Integer.valueOf(0)));
                level.method_8455(pos, (class_2248)this);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_52423;
    }

    @Nullable
    public class_2680 method_9605(@NotNull class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        for (class_2350 direction : ctx.method_7718()) {
            class_2680 blockState;
            if (direction.method_10166() != class_2350.class_2351.field_11052 || !(blockState = (class_2680)this.method_9564().method_11657((class_2769)HANGING, (Comparable)Boolean.valueOf(direction == class_2350.field_11036))).method_26184((class_4538)ctx.method_8045(), ctx.method_8037())) continue;
            return (class_2680)blockState.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        }
        return null;
    }

    @NotNull
    public class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 context) {
        return (Boolean)state.method_11654((class_2769)HANGING) != false ? HANGING_SHAPE : STANDING_SHAPE;
    }

    protected void method_9515(@NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{HANGING, WATERLOGGED, DISPLAY_LIGHT});
    }

    public boolean method_9558(@NotNull class_2680 state, @NotNull class_4538 level, @NotNull class_2338 pos) {
        class_2350 direction = DisplayLanternBlock.attachedDirection(state).method_10153();
        return class_2248.method_20044((class_4538)level, (class_2338)pos.method_10093(direction), (class_2350)direction.method_10153());
    }

    @NotNull
    public class_2464 method_9604(@NotNull class_2680 blockState) {
        return class_2464.field_11458;
    }

    @NotNull
    protected class_2680 method_9559(@NotNull class_2680 blockState, class_4538 levelReader, class_10225 scheduledTickAccess, class_2338 blockPos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 randomSource) {
        if (((Boolean)blockState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.method_64312(blockPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(levelReader));
        }
        if (DisplayLanternBlock.attachedDirection(blockState).method_10153() == direction && !blockState.method_26184(levelReader, blockPos)) {
            class_2586 entity = levelReader.method_8321(blockPos);
            if (entity instanceof DisplayLanternBlockEntity) {
                DisplayLanternBlockEntity lanternEntity = (DisplayLanternBlockEntity)entity;
                lanternEntity.spawnFireflies();
            }
            return class_2246.field_10124.method_9564();
        }
        return super.method_9559(blockState, levelReader, scheduledTickAccess, blockPos, direction, neighborPos, neighborState, randomSource);
    }

    protected void method_66388(class_2680 state, @NotNull class_3218 level, class_2338 pos, boolean bl) {
        level.method_8455(pos, state.method_26204());
    }

    @NotNull
    public class_3610 method_9545(@NotNull class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public boolean method_9516(@NotNull class_2680 state, @NotNull class_10 type) {
        return false;
    }

    @Nullable
    public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return new DisplayLanternBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(@NotNull class_1937 level, @NotNull class_2680 state, @NotNull class_2591<T> type) {
        return !level.method_8608() ? DisplayLanternBlock.method_31618(type, WWBlockEntityTypes.DISPLAY_LANTERN, (levelx, pos, statex, blockEntity) -> blockEntity.serverTick(levelx, pos)) : DisplayLanternBlock.method_31618(type, WWBlockEntityTypes.DISPLAY_LANTERN, (levelx, pos, statex, blockEntity) -> blockEntity.clientTick(levelx));
    }

    public boolean method_9498(@NotNull class_2680 state) {
        return true;
    }

    protected int method_9572(@NotNull class_2680 state, class_1937 level, @NotNull class_2338 pos, class_2350 direction) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof DisplayLanternBlockEntity) {
            DisplayLanternBlockEntity displayLanternBlockEntity = (DisplayLanternBlockEntity)blockEntity;
            return displayLanternBlockEntity.getComparatorOutput();
        }
        return 0;
    }
}

