/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.client.renderer.blockentity;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.wilderwild.WWConstants;
import net.frozenblock.wilderwild.block.entity.impl.SculkSensorInterface;
import net.frozenblock.wilderwild.client.WWModelLayers;
import net.frozenblock.wilderwild.client.renderer.blockentity.state.SculkSensorRenderState;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_5704;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class SculkSensorRenderer<T extends class_5704>
implements class_827<T, SculkSensorRenderState> {
    private static final float RAD_25 = 0.43633232f;
    private static final float TENDRIL_ANGLE = 0.7853982f;
    private static final float TENDRIL_ANGLE_SOUTH = 3.9269907f;
    private static final class_1921 ACTIVE_SENSOR_LAYER = class_1921.method_23576((class_2960)WWConstants.id("textures/entity/sculk_sensor/active.png"));
    private final class_630 root;
    private final class_630 tendril1;
    private final class_630 tendril2;
    private final class_630 tendril3;
    private final class_630 tendril4;

    public SculkSensorRenderer(@NotNull class_5614.class_5615 ctx) {
        this.root = ctx.method_32140(WWModelLayers.SCULK_SENSOR);
        this.tendril1 = this.root.method_32086("tendril1");
        this.tendril2 = this.root.method_32086("tendril2");
        this.tendril3 = this.root.method_32086("tendril3");
        this.tendril4 = this.root.method_32086("tendril4");
    }

    @NotNull
    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 root = modelData.method_32111();
        SculkSensorRenderer.makeTendril(root, "tendril1", false, 3.0f, 3.0f, -0.7853982f);
        SculkSensorRenderer.makeTendril(root, "tendril2", true, 13.0f, 3.0f, 0.7853982f);
        SculkSensorRenderer.makeTendril(root, "tendril3", false, 13.0f, 13.0f, -3.9269907f);
        SculkSensorRenderer.makeTendril(root, "tendril4", true, 3.0f, 13.0f, 3.9269907f);
        return class_5607.method_32110((class_5609)modelData, (int)16, (int)16);
    }

    private static void makeTendril(class_5610 root, String name, boolean mirror, float xPos, float zPos, float rot) {
        class_5606 cubeListBuilder = class_5606.method_32108().method_32101(0, 0);
        if (mirror) {
            cubeListBuilder.method_32096();
        }
        cubeListBuilder.method_32097(-4.0f, -8.0f, 0.0f, 8.0f, 8.0f, 0.001f);
        root.method_32117(name, cubeListBuilder, class_5603.method_32091((float)xPos, (float)8.0f, (float)zPos, (float)0.0f, (float)rot, (float)((float)Math.PI)));
    }

    public void submit(@NotNull SculkSensorRenderState renderState, @NotNull class_4587 poseStack, @NotNull class_11659 submitNodeCollector, @NotNull class_12075 cameraRenderState) {
        float xRot;
        if (!renderState.active) {
            return;
        }
        poseStack.method_46416(0.5f, 0.5f, 0.5f);
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(renderState.blockYRot));
        poseStack.method_46416(-0.5f, -0.5f, -0.5f);
        this.tendril1.field_3654 = xRot = renderState.tendrilXRot;
        this.tendril2.field_3654 = xRot;
        this.tendril3.field_3654 = xRot;
        this.tendril4.field_3654 = xRot;
        submitNodeCollector.method_73492(this.root, poseStack, ACTIVE_SENSOR_LAYER, renderState.field_62676, class_4608.field_21444, null, -1, renderState.field_62677);
    }

    @NotNull
    public SculkSensorRenderState createRenderState() {
        return new SculkSensorRenderState();
    }

    public void extractRenderState(@NotNull T sculkSensor, @NotNull SculkSensorRenderState renderState, float partialTicks, @NotNull class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        SculkSensorInterface sculkSensorInterface;
        super.method_74331(sculkSensor, (class_11954)renderState, partialTicks, cameraPos, crumblingOverlay);
        if (!(WWConstants.MC_LIVE_TENDRILS && sculkSensor instanceof SculkSensorInterface && (sculkSensorInterface = (SculkSensorInterface)sculkSensor).wilderWild$isActive())) {
            renderState.active = false;
            return;
        }
        int prevTicks = sculkSensorInterface.wilderWild$getPrevAnimTicks();
        renderState.active = true;
        renderState.blockYRot = -sculkSensorInterface.wilderWild$getFacing().method_10144();
        renderState.tendrilXRot = ((float)prevTicks + partialTicks * (float)(sculkSensorInterface.wilderWild$getAnimTicks() - prevTicks)) * 0.1f * ((float)Math.cos(((float)sculkSensorInterface.wilderWild$getAge() + partialTicks) * 2.25f) * 0.43633232f);
    }
}

