/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.entity;

import com.mojang.serialization.Dynamic;
import java.util.Objects;
import java.util.Optional;
import net.frozenblock.lib.wind.api.WindManager;
import net.frozenblock.wilderwild.config.WWEntityConfig;
import net.frozenblock.wilderwild.entity.ai.firefly.FireflyAi;
import net.frozenblock.wilderwild.entity.impl.WWBottleable;
import net.frozenblock.wilderwild.entity.variant.firefly.FireflyColor;
import net.frozenblock.wilderwild.entity.variant.firefly.FireflyColors;
import net.frozenblock.wilderwild.registry.WWDataComponents;
import net.frozenblock.wilderwild.registry.WWItems;
import net.frozenblock.wilderwild.registry.WWMemoryModuleTypes;
import net.frozenblock.wilderwild.registry.WWSounds;
import net.frozenblock.wilderwild.registry.WilderWildRegistries;
import net.minecraft.class_10209;
import net.minecraft.class_10701;
import net.minecraft.class_10704;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1331;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1432;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3695;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_9331;
import net.minecraft.class_9473;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Firefly
extends class_1314
implements class_1432,
WWBottleable {
    public static final int RANDOM_FLICKER_AGE_MAX = 19;
    private static final class_2940<Boolean> FROM_BOTTLE = class_2945.method_12791(Firefly.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> AGE = class_2945.method_12791(Firefly.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> ANIM_SCALE = class_2945.method_12791(Firefly.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> PREV_ANIM_SCALE = class_2945.method_12791(Firefly.class, (class_2941)class_2943.field_13320);
    private static final class_2940<String> COLOR = class_2945.method_12791(Firefly.class, (class_2941)class_2943.field_13326);
    private Optional<FireflyColor> fireflyColor = Optional.empty();

    public Firefly(@NotNull class_1299<? extends Firefly> entityType, @NotNull class_1937 level) {
        super(entityType, level);
        this.method_5941(class_7.field_14, -1.0f);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
        this.method_5941(class_7.field_25418, 0.0f);
        this.field_6207 = new class_1331((class_1308)this, 20, true);
        this.setFlickerAge(this.field_5974.method_39332(0, 19));
        this.setAnimScale(1.5f);
    }

    public float method_6144(@NotNull class_2338 pos, @NotNull class_4538 level) {
        return -level.method_42309(pos);
    }

    public static boolean checkFireflySpawnRules(@NotNull class_1299<Firefly> type, @NotNull class_1936 level, class_3730 reason, @NotNull class_2338 pos, @NotNull class_5819 random) {
        if (!class_3730.method_54986((class_3730)reason) && !WWEntityConfig.get().firefly.spawnFireflies) {
            return false;
        }
        if (!class_3730.method_54987((class_3730)reason) && level.method_22339(pos) > 13) {
            return false;
        }
        if (!WWEntityConfig.get().firefly.firefliesNeedBush) {
            return true;
        }
        return (int)(random.method_43058() * (double)Firefly.getNearbyFireflyBushCount(level, pos, 3)) >= 1;
    }

    @NotNull
    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 1.0).method_26868(class_5134.field_23719, 0.08).method_26868(class_5134.field_23720, 0.08).method_26868(class_5134.field_23717, 32.0);
    }

    @Nullable
    public class_1315 method_5943(@NotNull class_5425 level, @NotNull class_1266 difficulty, @NotNull class_3730 reason, @Nullable class_1315 spawnData) {
        boolean shouldSetHome = Firefly.shouldSetHome(reason);
        if (shouldSetHome) {
            FireflyAi.rememberHome((class_1309)this, this.method_24515());
        } else {
            FireflyAi.setNatural(this);
        }
        if (spawnData instanceof FireflySpawnGroupData) {
            FireflySpawnGroupData fireflySpawnGroupData = (FireflySpawnGroupData)spawnData;
            this.setColor((FireflyColor)fireflySpawnGroupData.color.comp_349());
        } else {
            Optional optionalFireflyColor = class_10704.method_71969((class_10701)class_10701.method_67169((class_5425)level, (class_2338)this.method_24515()), WilderWildRegistries.FIREFLY_COLOR);
            if (optionalFireflyColor.isPresent()) {
                spawnData = new FireflySpawnGroupData((class_6880<FireflyColor>)((class_6880)optionalFireflyColor.get()));
                this.setColor((FireflyColor)((class_6880.class_6883)optionalFireflyColor.get()).comp_349());
            }
            if (!shouldSetHome) {
                FireflyAi.setSwarmLeader(this);
            }
        }
        return super.method_5943(level, difficulty, reason, spawnData);
    }

    private static boolean shouldSetHome(class_3730 reason) {
        return reason == class_3730.field_16470 || reason == class_3730.field_16473;
    }

    public int method_5945() {
        return 8;
    }

    public void method_5674(class_2940<?> entityDataAccessor) {
        super.method_5674(entityDataAccessor);
        if (COLOR.equals(entityDataAccessor)) {
            this.fireflyColor = Optional.of(this.getVariant());
        }
    }

    public int method_6130(int currentAir) {
        int newSupply = super.method_6130(currentAir);
        return newSupply == currentAir - 1 ? newSupply - 1 : newSupply;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(FROM_BOTTLE, (Object)false);
        builder.method_56912(AGE, (Object)0);
        builder.method_56912(ANIM_SCALE, (Object)Float.valueOf(1.5f));
        builder.method_56912(PREV_ANIM_SCALE, (Object)Float.valueOf(1.5f));
        builder.method_56912(COLOR, (Object)FireflyColors.DEFAULT.method_29177().toString());
    }

    public boolean method_33189() {
        return true;
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        class_1792 item = stack.method_7909();
        if (item instanceof class_1769) {
            Optional<FireflyColor> newFireflyColor;
            class_1767 fireflyDyeColor;
            class_1769 dyeItem = (class_1769)item;
            Optional<class_1767> optionalFireflyDyeColor = this.getVariant().dyeColor();
            if (!(optionalFireflyDyeColor.isPresent() && (fireflyDyeColor = optionalFireflyDyeColor.get()) == dyeItem.method_7802() || (newFireflyColor = FireflyColor.getByDyeColor(this.method_56673(), dyeItem.method_7802())).isEmpty())) {
                if (!this.method_73183().method_8608()) {
                    this.setColor(newFireflyColor.get());
                    this.method_5971();
                    stack.method_7934(1);
                }
                this.method_73183().method_43129((class_1297)player, (class_1297)this, class_3417.field_28391, class_3419.field_15248, 1.0f, 1.0f);
                return class_1269.field_5812;
            }
        }
        return WWBottleable.bottleMobPickup(player, hand, this).orElse(super.method_5992(player, hand));
    }

    public boolean method_5727(double x, double y, double z) {
        return true;
    }

    public boolean method_5931() {
        return false;
    }

    @NotNull
    protected class_4095.class_5303<Firefly> method_28306() {
        return FireflyAi.brainProvider();
    }

    @NotNull
    protected class_4095<?> method_18867(@NotNull Dynamic<?> dynamic) {
        return FireflyAi.makeBrain(this, (class_4095<Firefly>)this.method_28306().method_28335(dynamic));
    }

    @Override
    public boolean wilderWild$fromBottle() {
        return (Boolean)this.field_6011.method_12789(FROM_BOTTLE);
    }

    @Override
    public void wilderWild$setFromBottle(boolean value) {
        this.field_6011.method_12778(FROM_BOTTLE, (Object)value);
    }

    @Override
    public void wilderWild$saveToBottleTag(class_1799 itemStack) {
        WWBottleable.saveDefaultDataToBottleTag((class_1308)this, itemStack);
        itemStack.method_66697(WWDataComponents.FIREFLY_COLOR, (class_9473)this);
    }

    @Override
    public void wilderWild$loadFromBottleTag(@NotNull class_2487 compoundTag) {
        WWBottleable.loadDefaultDataFromBottleTag((class_1308)this, compoundTag);
    }

    @Nullable
    public <T> T method_58694(@NotNull class_9331<? extends T> dataComponentType) {
        if (dataComponentType == WWDataComponents.FIREFLY_COLOR) {
            return (T)Firefly.method_66651(dataComponentType, this.getColorAsHolder());
        }
        return (T)super.method_58694(dataComponentType);
    }

    protected void method_66649(@NotNull class_9473 dataComponentGetter) {
        this.method_66650(dataComponentGetter, WWDataComponents.FIREFLY_COLOR);
        super.method_66649(dataComponentGetter);
    }

    protected <T> boolean method_66654(@NotNull class_9331<T> dataComponentType, @NotNull T object) {
        if (dataComponentType == WWDataComponents.FIREFLY_COLOR) {
            this.setColor((FireflyColor)((class_6880)Firefly.method_66651(WWDataComponents.FIREFLY_COLOR, object)).comp_349());
            return true;
        }
        return super.method_66654(dataComponentType, object);
    }

    @Override
    public void wilderWild$onBottled() {
        if (this.isSwarmLeader()) {
            FireflyAi.transferLeadershipToRandomFirefly(this);
        }
    }

    @Override
    public void wilderWild$onBottleRelease() {
        FireflyAi.rememberHome((class_1309)this, this.method_24515());
    }

    @Override
    public class_1799 wilderWild$getBottleItemStack() {
        return new class_1799((class_1935)WWItems.FIREFLY_BOTTLE);
    }

    @Override
    public class_3414 wilderWild$getBottleCatchSound() {
        return WWSounds.ITEM_BOTTLE_CATCH_FIREFLY;
    }

    public boolean method_18410() {
        return this.method_18868().method_18896(class_4140.field_18438);
    }

    public int getFlickerAge() {
        return (Integer)this.field_6011.method_12789(AGE);
    }

    public void setFlickerAge(int value) {
        this.field_6011.method_12778(AGE, (Object)value);
    }

    public float getAnimScale() {
        return ((Float)this.field_6011.method_12789(ANIM_SCALE)).floatValue();
    }

    public void setAnimScale(float value) {
        this.field_6011.method_12778(ANIM_SCALE, (Object)Float.valueOf(value));
    }

    public float getPrevAnimScale() {
        return ((Float)this.field_6011.method_12789(PREV_ANIM_SCALE)).floatValue();
    }

    public void setPrevAnimScale(float value) {
        this.field_6011.method_12778(PREV_ANIM_SCALE, (Object)Float.valueOf(value));
    }

    public class_2960 getColorLocation() {
        return class_2960.method_60654((String)((String)this.field_6011.method_12789(COLOR)));
    }

    public FireflyColor getColorByLocation() {
        return (FireflyColor)this.method_56673().method_30530(WilderWildRegistries.FIREFLY_COLOR).method_63535(this.getColorLocation());
    }

    public class_6880<FireflyColor> getColorAsHolder() {
        return (class_6880)this.method_56673().method_30530(WilderWildRegistries.FIREFLY_COLOR).method_10223(this.getColorLocation()).orElseThrow();
    }

    public FireflyColor getColorForRendering() {
        return this.fireflyColor.orElse((FireflyColor)this.method_56673().method_30530(WilderWildRegistries.FIREFLY_COLOR).method_29107(FireflyColors.DEFAULT));
    }

    public void setColor(@NotNull FireflyColor color) {
        this.field_6011.method_12778(COLOR, (Object)Objects.requireNonNull(this.method_56673().method_30530(WilderWildRegistries.FIREFLY_COLOR).method_10221((Object)color)).toString());
    }

    public void setColor(@NotNull class_2960 color) {
        this.field_6011.method_12778(COLOR, (Object)color.toString());
    }

    public FireflyColor getVariant() {
        return this.getColorByLocation();
    }

    public boolean method_17326() {
        return super.method_17326() || this.wilderWild$fromBottle();
    }

    @NotNull
    public class_4095<Firefly> method_18868() {
        return super.method_18868();
    }

    public boolean method_6581() {
        return !this.method_24828();
    }

    public boolean shouldHide() {
        return this.isNatural() && this.method_73183().method_8530() && !this.method_5947() && !this.method_17326() && this.method_73183().method_8314(class_1944.field_9284, this.method_24515()) >= 7;
    }

    public boolean isSwarmLeader() {
        return this.isNatural() && this.method_18868().method_18904(WWMemoryModuleTypes.IS_SWARM_LEADER).orElse(false) != false;
    }

    public boolean isNatural() {
        return this.method_18868().method_18904(WWMemoryModuleTypes.NATURAL).orElse(false);
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 level) {
        class_1407 birdNavigation = new class_1407((class_1308)this, level);
        birdNavigation.method_70687(false);
        birdNavigation.method_6354(true);
        birdNavigation.method_6342().method_15(true);
        return birdNavigation;
    }

    public void method_6091(@NotNull class_243 travelVector) {
        if (this.method_6034() || this.method_66247()) {
            if (this.method_5805()) {
                if (this.method_5799()) {
                    this.method_5724(0.01f, travelVector);
                    this.method_5784(class_1313.field_6308, this.method_18798());
                    this.method_18799(this.method_18798().method_1021((double)0.8f));
                } else if (this.method_5771()) {
                    this.method_5724(0.01f, travelVector);
                    this.method_5784(class_1313.field_6308, this.method_18798());
                    this.method_18799(this.method_18798().method_1021(0.5));
                } else {
                    this.method_5724(this.method_6029(), travelVector);
                    this.method_5784(class_1313.field_6308, this.method_18798());
                    this.method_18799(this.method_18798().method_1021((double)0.91f));
                }
            } else {
                super.method_6091(travelVector);
            }
        }
    }

    public static int getNearbyFireflyBushCount(@NotNull class_1936 level, @NotNull class_2338 blockPos, int distance) {
        int count = 0;
        Iterable posesToCheck = class_2338.method_10097((class_2338)blockPos.method_10069(-distance, -distance, -distance), (class_2338)blockPos.method_10069(distance, distance, distance));
        for (class_2338 pos : posesToCheck) {
            if (!level.method_8320(pos).method_27852(class_2246.field_56455)) continue;
            ++count;
        }
        return count;
    }

    protected void method_5712(@NotNull class_2338 pos, @NotNull class_2680 state) {
    }

    protected void method_5623(double heightDifference, boolean onGround, @NotNull class_2680 state, @NotNull class_2338 landedPosition) {
    }

    protected class_3414 method_5994() {
        return null;
    }

    protected class_3414 method_6011(@NotNull class_1282 source) {
        return WWSounds.ENTITY_FIREFLY_HURT;
    }

    protected class_3414 method_6002() {
        return WWSounds.ENTITY_FIREFLY_HURT;
    }

    public void method_5773() {
        class_1937 class_19372;
        super.method_5773();
        if (!this.method_5805()) {
            this.method_5875(false);
        }
        this.setFlickerAge(this.getFlickerAge() + 1);
        float animScale = this.getAnimScale();
        this.setPrevAnimScale(animScale);
        if (animScale < 1.5f) {
            this.setAnimScale(Math.min(this.getAnimScale() + 0.025f, 1.5f));
        }
        if ((class_19372 = this.method_73183()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_243 wind = WindManager.getOrCreateWindManager((class_3218)serverLevel).getWindMovement(this.method_73189(), 1.0, 100.0, 100.0).method_1021(0.01);
            wind = wind.method_1023(0.0, wind.field_1351 * 0.7, 0.0);
            this.method_18799(this.method_18798().method_1019(wind.method_1021(0.02)));
        }
    }

    protected void method_5958(class_3218 level) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("fireflyBrain");
        this.method_18868().method_19542(level, (class_1309)this);
        profiler.method_15407();
        profiler.method_15396("fireflyActivityUpdate");
        FireflyAi.updateActivities(this);
        profiler.method_15407();
        super.method_5958(level);
    }

    public boolean method_5776() {
        return true;
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return !this.wilderWild$fromBottle() && !this.method_16914();
    }

    public void method_6078(class_1282 damageSource) {
        if (this.isSwarmLeader()) {
            FireflyAi.transferLeadershipToRandomFirefly(this);
        }
        super.method_6078(damageSource);
    }

    public void method_5652(@NotNull class_11372 valueOutput) {
        super.method_5652(valueOutput);
        this.getColorAsHolder().method_40230().ifPresent(resourceKey -> valueOutput.method_71469("color", resourceKey.method_29177().toString()));
        valueOutput.method_71472("fromBottle", this.wilderWild$fromBottle());
        valueOutput.method_71465("flickerAge", this.getFlickerAge());
        valueOutput.method_71464("scale", this.getAnimScale());
        valueOutput.method_71464("prevScale", this.getPrevAnimScale());
    }

    public void method_5749(@NotNull class_11368 valueInput) {
        super.method_5749(valueInput);
        valueInput.method_71441("color").flatMap(string -> Optional.ofNullable(class_2960.method_12829((String)string)).map(resourceLocation -> class_5321.method_29179(WilderWildRegistries.FIREFLY_COLOR, (class_2960)resourceLocation)).flatMap(resourceKey -> this.method_56673().method_30530(WilderWildRegistries.FIREFLY_COLOR).method_46746(resourceKey))).ifPresent(reference -> this.setColor((FireflyColor)reference.comp_349()));
        this.wilderWild$setFromBottle(valueInput.method_71433("fromBottle", false));
        valueInput.method_71439("flickerAge").ifPresent(this::setFlickerAge);
        this.setAnimScale(valueInput.method_71423("scale", 1.5f));
        this.setPrevAnimScale(valueInput.method_71423("prevScale", 1.5f));
    }

    protected boolean method_43689() {
        return false;
    }

    public boolean method_5747(double fallDistance, float damageMultiplier, @NotNull class_1282 source) {
        return false;
    }

    protected void method_6087(@NotNull class_1297 entity) {
    }

    protected void method_6070() {
    }

    public static class FireflySpawnGroupData
    implements class_1315 {
        public final class_6880<FireflyColor> color;

        public FireflySpawnGroupData(class_6880<FireflyColor> holder) {
            this.color = holder;
        }
    }
}

