/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.worldgen.impl.trunk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.frozenblock.wilderwild.config.WWWorldgenConfig;
import net.frozenblock.wilderwild.registry.WWFeatures;
import net.frozenblock.wilderwild.worldgen.impl.trunk.branch.TrunkBranchPlacement;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class MapleTrunkPlacer
extends class_5141 {
    private static final List<class_2350> EMPTY = ImmutableList.of();
    public static final MapCodec<MapleTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> MapleTrunkPlacer.method_28904((RecordCodecBuilder.Instance)instance).and((App)TrunkBranchPlacement.CODEC.fieldOf("trunk_branch_placement").forGetter(trunkPlacer -> trunkPlacer.trunkBranchPlacement)).and((App)TrunkBranchPlacement.CODEC.fieldOf("lower_trunk_branch_placement").forGetter(trunkPlacer -> trunkPlacer.lowerTrunkBranchPlacement)).and((App)class_5141.field_24972.fieldOf("alt_trunk_placer").forGetter(trunkPlacer -> trunkPlacer.altTrunkPlacer)).apply((Applicative)instance, MapleTrunkPlacer::new));
    private final TrunkBranchPlacement trunkBranchPlacement;
    private final TrunkBranchPlacement lowerTrunkBranchPlacement;
    private final class_5141 altTrunkPlacer;

    public MapleTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, @NotNull TrunkBranchPlacement trunkBranchPlacement, @NotNull TrunkBranchPlacement lowerTrunkBranchPlacement, @NotNull class_5141 altTrunkPlacer) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.trunkBranchPlacement = trunkBranchPlacement;
        this.lowerTrunkBranchPlacement = lowerTrunkBranchPlacement;
        this.altTrunkPlacer = altTrunkPlacer;
    }

    @NotNull
    protected class_5142<?> method_28903() {
        return WWFeatures.MAPLE_TRUNK_PLACER;
    }

    private static boolean containsNearbyBranchWithSameDirection(class_2338 pos, class_2350 direction, int distanceBelow, Map<class_2338, List<class_2350>> branches) {
        for (int i = 1; i <= distanceBelow; ++i) {
            if (!branches.getOrDefault(pos.method_10087(i), EMPTY).contains(direction)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<class_4647.class_5208> method_26991(@NotNull class_3746 level, @NotNull BiConsumer<class_2338, class_2680> replacer, @NotNull class_5819 random, int height, @NotNull class_2338 startPos, @NotNull class_4643 config) {
        if (!WWWorldgenConfig.NEW_MAPLES) {
            return this.altTrunkPlacer.method_26991(level, replacer, random, height, startPos, config);
        }
        MapleTrunkPlacer.method_27400((class_3746)level, replacer, (class_5819)random, (class_2338)startPos.method_10074(), (class_4643)config);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int branchCutoffFromTop = this.trunkBranchPlacement.getBranchCutoffFromTop().method_35008(random);
        ArrayList foliageAttachments = Lists.newArrayList();
        Object2ObjectLinkedOpenHashMap branches = new Object2ObjectLinkedOpenHashMap();
        for (int currentHeight = 0; currentHeight < height; ++currentHeight) {
            TrunkBranchPlacement branchPlacement;
            int worldHeight = startPos.method_10264() + currentHeight;
            TrunkBranchPlacement trunkBranchPlacement = branchPlacement = currentHeight < height / 2 ? this.lowerTrunkBranchPlacement : this.trunkBranchPlacement;
            if (!this.method_35375(level, replacer, random, (class_2338)mutable.method_10103(startPos.method_10263(), worldHeight, startPos.method_10260()), config) || currentHeight >= height - 1 || currentHeight <= branchCutoffFromTop) continue;
            class_2338 branchTrunkPos = mutable.method_10062();
            for (class_2350 direction : class_2350.class_2353.field_11062.method_43342(random)) {
                if (!branchPlacement.canPlaceBranch(random) || MapleTrunkPlacer.containsNearbyBranchWithSameDirection(branchTrunkPos, direction, 2, (Map<class_2338, List<class_2350>>)branches)) continue;
                branchPlacement.generateExtraBranch(level, replacer, random, config.field_21288, branchTrunkPos, direction, foliageAttachments);
                List branchDirections = branches.computeIfAbsent(branchTrunkPos, pos -> new ArrayList());
                branchDirections.add(direction);
                branches.put(branchTrunkPos, branchDirections);
            }
        }
        foliageAttachments.add(new class_4647.class_5208(startPos.method_10086(height), 1, false));
        return foliageAttachments;
    }
}

