/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.worldgen.modification;

import net.fabricmc.fabric.api.biome.v1.BiomeModificationContext;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.frozenblock.wilderwild.WWConstants;
import net.frozenblock.wilderwild.config.WWWorldgenConfig;
import net.frozenblock.wilderwild.registry.WWBiomes;
import net.frozenblock.wilderwild.tag.WWBiomeTags;
import net.frozenblock.wilderwild.worldgen.features.placed.WWMiscPlaced;
import net.frozenblock.wilderwild.worldgen.features.placed.WWPlacedFeatures;
import net.frozenblock.wilderwild.worldgen.impl.conditionsource.BetaBeachConditionSource;
import net.frozenblock.wilderwild.worldgen.impl.conditionsource.SnowUnderMountainConditionSource;
import net.frozenblock.wilderwild.worldgen.impl.treedecorators.WWTreeDecorators;
import net.frozenblock.wilderwild.worldgen.modification.WWAquaticGeneration;
import net.frozenblock.wilderwild.worldgen.modification.WWBiomeSettings;
import net.frozenblock.wilderwild.worldgen.modification.WWMiscGeneration;
import net.frozenblock.wilderwild.worldgen.modification.WWTreeGeneration;
import net.frozenblock.wilderwild.worldgen.modification.WWVegetationGeneration;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6814;
import net.minecraft.class_6819;
import net.minecraft.class_7923;

public final class WWWorldgen {
    private WWWorldgen() {
        throw new UnsupportedOperationException("WWWorldgen contains only static declarations.");
    }

    public static void generateWildWorldGen() {
        WWWorldgen.configureBuiltInBiomes();
        WWWorldgen.replaceFeatures();
        WWVegetationGeneration.generateFlower();
        WWVegetationGeneration.generateShrub();
        WWVegetationGeneration.generateCacti();
        WWAquaticGeneration.generateAquaticFeatures();
        WWVegetationGeneration.generateGrass();
        WWMiscGeneration.generateMisc();
        WWTreeDecorators.generateTreeDecorators();
        WWTreeGeneration.generateTrees();
        WWVegetationGeneration.generateMushroom();
        WWVegetationGeneration.generatePumpkin();
        WWBiomeSettings.init();
        WWWorldgen.generatePollen();
        class_2378.method_10230((class_2378)class_7923.field_41158, (class_2960)WWConstants.id("beta_beach_condition_source"), (Object)BetaBeachConditionSource.CODEC.comp_640());
        class_2378.method_10230((class_2378)class_7923.field_41158, (class_2960)WWConstants.id("snow_under_mountain_condition_source"), (Object)SnowUnderMountainConditionSource.CODEC.comp_640());
    }

    private static void configureBuiltInBiomes() {
        BiomeModifications.create((class_2960)WWConstants.id("remove_fallen_trees")).add(ModificationPhase.REMOVALS, BiomeSelectors.includeByKey((class_5321[])new class_5321[]{WWBiomes.CYPRESS_WETLANDS}), context -> {
            if (!WWWorldgenConfig.get().treeGeneration.fallenTrees) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(WWPlacedFeatures.FALLEN_OAK_AND_CYPRESS_PLACED.getKey());
            }
        }).add(ModificationPhase.REMOVALS, BiomeSelectors.includeByKey((class_5321[])new class_5321[]{WWBiomes.MIXED_FOREST}), context -> {
            if (!WWWorldgenConfig.get().treeGeneration.fallenTrees) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(WWPlacedFeatures.FALLEN_TREES_MIXED_PLACED.getKey());
            }
        });
        BiomeModifications.create((class_2960)WWConstants.id("flowers_rainforest")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.includeByKey((class_5321[])new class_5321[]{WWBiomes.RAINFOREST}), context -> {
            if (WWWorldgenConfig.get().vegetation.flowerGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(WWPlacedFeatures.FLOWER_RAINFOREST_VANILLA.getKey());
                generationSettings.removeFeature(WWPlacedFeatures.TALL_FLOWER_RAINFOREST_VANILLA.getKey());
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.FLOWER_RAINFOREST.getKey());
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TALL_FLOWER_RAINFOREST.getKey());
            }
        });
        BiomeModifications.create((class_2960)WWConstants.id("flowers_temperate_rainforest")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.includeByKey((class_5321[])new class_5321[]{WWBiomes.TEMPERATE_RAINFOREST}), context -> {
            if (WWWorldgenConfig.get().vegetation.flowerGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(WWPlacedFeatures.FLOWER_TEMPERATE_RAINFOREST_VANILLA.getKey());
                generationSettings.removeFeature(WWPlacedFeatures.TALL_FLOWER_TEMPERATE_RAINFOREST_VANILLA.getKey());
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.FLOWER_TEMPERATE_RAINFOREST.getKey());
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TALL_FLOWER_TEMPERATE_RAINFOREST.getKey());
            }
        });
    }

    private static void replaceFeatures() {
        BiomeModifications.create((class_2960)WWConstants.id("add_new_snow")).add(ModificationPhase.POST_PROCESSING, BiomeSelectors.all(), (biomeSelectionContext, context) -> {
            BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
            if (generationSettings.removeFeature(class_6814.field_36012)) {
                generationSettings.addFeature(class_2893.class_2895.field_13179, class_6814.field_36012);
                if (WWWorldgenConfig.get().snowBelowTrees) {
                    generationSettings.addFeature(class_2893.class_2895.field_13179, WWMiscPlaced.SNOW_BLANKET.getKey());
                }
                if (WWWorldgenConfig.get().transitionGeneration.snowTransitions) {
                    generationSettings.addFeature(class_2893.class_2895.field_13179, WWMiscPlaced.SNOW_AND_ICE_TRANSITION.getKey());
                }
            }
        });
        BiomeModifications.create((class_2960)WWConstants.id("replace_forest_grass")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WWBiomeTags.FOREST_GRASS), context -> {
            if (WWWorldgenConfig.get().vegetation.grassGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_36166);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.GRASS_PLACED.getKey());
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TALL_GRASS.getKey());
            }
        });
        BiomeModifications.create((class_2960)WWConstants.id("replace_plains_grass")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WWBiomeTags.PLAINS_GRASS), context -> {
            if (WWWorldgenConfig.get().vegetation.grassGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_36165);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.GRASS_PLAINS_PLACED.getKey());
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TALL_GRASS_PLAINS.getKey());
            }
        });
        BiomeModifications.create((class_2960)WWConstants.id("replace_cherry_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WWBiomeTags.CHERRY_TREES), context -> {
            if (WWWorldgenConfig.get().treeGeneration.treeGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_42965);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.CHERRY_TREES.getKey());
            }
        });
        BiomeModifications.create((class_2960)WWConstants.id("replace_forest_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9409}), context -> {
            if (WWWorldgenConfig.get().treeGeneration.treeGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_36154);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TREES_BIRCH_AND_OAK_ORIGINAL.getKey());
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TREES_BIRCH_AND_OAK.getKey());
            }
        });
        BiomeModifications.create((class_2960)WWConstants.id("replace_birch_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9412}), context -> {
            if (WWWorldgenConfig.get().treeGeneration.treeGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_36150);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TREES_BIRCH.getKey());
            }
        }).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_35112}), context -> {
            if (WWWorldgenConfig.get().treeGeneration.treeGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_36149);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TREES_BIRCH_TALL.getKey());
            }
        }).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9414}), context -> {
            if (WWWorldgenConfig.get().treeGeneration.treeGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_36154);
                generationSettings.removeFeature(class_6819.field_36139);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TREES_FLOWER_FOREST.getKey());
            }
        });
        BiomeModifications.create((class_2960)WWConstants.id("replace_plains_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WWBiomeTags.NON_FROZEN_PLAINS), context -> {
            if (WWWorldgenConfig.get().treeGeneration.treeGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_36135);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TREES_PLAINS.getKey());
            }
        });
        BiomeModifications.create((class_2960)WWConstants.id("replace_badlands_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_35110}), context -> {
            if (WWWorldgenConfig.get().treeGeneration.treeGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_36144);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.WOODED_BADLANDS_TREES.getKey());
            }
        });
        BiomeModifications.create((class_2960)WWConstants.id("replace_swamp_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WWBiomeTags.SWAMP_TREES), context -> {
            WWWorldgenConfig.TreeGeneration treeGeneration = WWWorldgenConfig.get().treeGeneration;
            BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
            if (treeGeneration.willow) {
                generationSettings.removeFeature(class_6819.field_36146);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TREES_SWAMP_SURFACE_WILLOW.getKey());
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TREES_SWAMP_WATER_SHALLOW.getKey());
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TREES_SWAMP_WATER.getKey());
            } else if (treeGeneration.treeGeneration) {
                generationSettings.removeFeature(class_6819.field_36146);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TREES_SWAMP.getKey());
            }
        });
        BiomeModifications.create((class_2960)WWConstants.id("replace_taiga_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WWBiomeTags.SHORT_TAIGA), context -> {
            if (WWWorldgenConfig.get().treeGeneration.treeGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_36142);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.SPRUCE_PLACED.getKey());
            }
        }).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WWBiomeTags.SHORT_TAIGA_SNOWY), context -> {
            if (WWWorldgenConfig.get().treeGeneration.treeGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_36142);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.SPRUCE_PLACED_NO_LITTER.getKey());
            }
        }).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WWBiomeTags.TALL_PINE_TAIGA), context -> {
            if (WWWorldgenConfig.get().treeGeneration.treeGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_36157);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TREES_OLD_GROWTH_PINE_TAIGA.getKey());
            }
        }).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WWBiomeTags.TALL_SPRUCE_TAIGA), context -> {
            if (WWWorldgenConfig.get().treeGeneration.treeGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_36156);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TREES_OLD_GROWTH_SPRUCE_TAIGA1.getKey());
            }
        });
        BiomeModifications.create((class_2960)WWConstants.id("replace_grove_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WWBiomeTags.GROVE), context -> {
            if (WWWorldgenConfig.get().treeGeneration.treeGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_36143);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TREES_GROVE.getKey());
            }
        });
        BiomeModifications.create((class_2960)WWConstants.id("replace_savanna_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WWBiomeTags.NORMAL_SAVANNA), context -> {
            WWWorldgenConfig.TreeGeneration treeGeneration = WWWorldgenConfig.get().treeGeneration;
            BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
            if (treeGeneration.treeGeneration) {
                generationSettings.removeFeature(class_6819.field_36148);
                if (treeGeneration.baobab) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.SAVANNA_TREES_BAOBAB.getKey());
                } else {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.SAVANNA_TREES.getKey());
                }
            } else if (treeGeneration.baobab) {
                generationSettings.removeFeature(class_6819.field_36148);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.SAVANNA_TREES_BAOBAB_VANILLA.getKey());
            }
        }).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WWBiomeTags.WINDSWEPT_SAVANNA), context -> {
            if (WWWorldgenConfig.get().treeGeneration.treeGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_36147);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.WINDSWEPT_SAVANNA_TREES.getKey());
            }
        });
        BiomeModifications.create((class_2960)WWConstants.id("replace_bamboo_jungle_trees")).add(ModificationPhase.ADDITIONS, BiomeSelectors.tag(WWBiomeTags.BAMBOO_JUNGLE_TREES), context -> {
            if (WWWorldgenConfig.get().treeGeneration.treeGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_36159);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.BAMBOO_VEGETATION.getKey());
            }
        });
        BiomeModifications.create((class_2960)WWConstants.id("replace_sparse_jungle_trees")).add(ModificationPhase.ADDITIONS, BiomeSelectors.tag(WWBiomeTags.SPARSE_JUNGLE_TREES), context -> {
            if (WWWorldgenConfig.get().treeGeneration.treeGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_36155);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TREES_SPARSE_JUNGLE.getKey());
            }
        });
        BiomeModifications.create((class_2960)WWConstants.id("replace_jungle_trees")).add(ModificationPhase.ADDITIONS, BiomeSelectors.tag(WWBiomeTags.JUNGLE_TREES), context -> {
            if (WWWorldgenConfig.get().treeGeneration.treeGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_36158);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TREES_JUNGLE.getKey());
            }
        });
        BiomeModifications.create((class_2960)WWConstants.id("replace_mangrove_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WWBiomeTags.MANGROVE_TREES), context -> {
            if (WWWorldgenConfig.get().treeGeneration.treeGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_38816);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TREES_MANGROVE.getKey());
            }
        });
        BiomeModifications.create((class_2960)WWConstants.id("replace_snowy_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WWBiomeTags.HAS_TREES_SNOWY), context -> {
            if (WWWorldgenConfig.get().treeGeneration.treeGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_36145);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TREES_SNOWY.getKey());
            }
        });
        BiomeModifications.create((class_2960)WWConstants.id("replace_windswept_hills_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WWBiomeTags.WINDSWEPT_HILLS), context -> {
            if (WWWorldgenConfig.get().treeGeneration.treeGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_36152);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TREES_WINDSWEPT_HILLS.getKey());
            }
        }).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WWBiomeTags.WINDSWEPT_FOREST), context -> {
            if (WWWorldgenConfig.get().treeGeneration.treeGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_36151);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TREES_WINDSWEPT_FOREST.getKey());
            }
        });
        BiomeModifications.create((class_2960)WWConstants.id("replace_dark_forest_vegetation")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WWBiomeTags.DARK_FOREST), context -> {
            if (WWWorldgenConfig.get().treeGeneration.treeGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_36136);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.DARK_FOREST_VEGETATION.getKey());
            }
        });
        BiomeModifications.create((class_2960)WWConstants.id("replace_pale_garden_vegetation")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WWBiomeTags.PALE_GARDEN), context -> {
            if (WWWorldgenConfig.get().treeGeneration.treeGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_54889);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TREES_PALE_GARDEN.getKey());
            }
        });
        BiomeModifications.create((class_2960)WWConstants.id("replace_meadow_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WWBiomeTags.MEADOW), context -> {
            if (WWWorldgenConfig.get().treeGeneration.treeGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_36141);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.TREES_MEADOW.getKey());
            }
        });
        BiomeModifications.create((class_2960)WWConstants.id("replace_water_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WWBiomeTags.HAS_WATER_SHRUBS), context -> {
            if (WWWorldgenConfig.get().treeGeneration.treeGeneration) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                generationSettings.removeFeature(class_6819.field_36153);
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.BIG_BUSHES_WATER.getKey());
            }
        });
    }

    private static void generatePollen() {
        BiomeModifications.create((class_2960)WWConstants.id("pollen_generation")).add(ModificationPhase.ADDITIONS, BiomeSelectors.all(), (biomeSelectionContext, context) -> {
            BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
            if (WWWorldgenConfig.GENERATE_POLLEN && biomeSelectionContext.hasTag(WWBiomeTags.HAS_POLLEN)) {
                generationSettings.addFeature(class_2893.class_2895.field_13178, WWPlacedFeatures.POLLEN_PLACED.getKey());
            }
        });
    }
}

