/*
 * Decompiled with CFR 0.152.
 */
package link.e4mc.dialtone;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.EventLoop;
import io.netty.util.internal.StringUtil;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import link.e4mc.dialtone.DialtoneAddress;
import link.e4mc.dialtone.DialtoneAmbientSession;
import link.e4mc.dialtone.DialtoneServerChannel;
import link.e4mc.iroh.Connection;
import link.e4mc.iroh.Endpoint;
import link.e4mc.iroh.Stream;

public class DialtoneChannel
extends AbstractChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private final ChannelConfig config = new DefaultChannelConfig((Channel)this);
    Endpoint endpoint;
    Connection connection;
    Stream stream;
    volatile boolean closed = false;
    AtomicBoolean readInFlight = new AtomicBoolean(false);
    AtomicBoolean writeInFlight = new AtomicBoolean(false);

    public DialtoneChannel() {
        super(null);
    }

    DialtoneChannel(DialtoneServerChannel parent) {
        super((Channel)parent);
        this.endpoint = parent.endpoint;
    }

    public byte[] exportKeyingMaterial(byte[] label, byte[] context, int length) {
        return this.connection.exportKeyingMaterial(label, context, length);
    }

    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new DialtoneUnsafe();
    }

    protected boolean isCompatible(EventLoop loop) {
        return true;
    }

    protected SocketAddress localAddress0() {
        return new DialtoneAddress(this.endpoint.address());
    }

    protected SocketAddress remoteAddress0() {
        return new DialtoneAddress(this.connection.peerAddress());
    }

    protected void doBind(SocketAddress localAddress) {
        throw new UnsupportedOperationException();
    }

    protected void doDisconnect() {
        this.doClose();
    }

    protected void doClose() {
        this.closed = true;
        this.stream.close();
        this.connection.close(0L, new byte[0]);
        this.stream = null;
        this.connection = null;
        this.pipeline().fireChannelInactive();
    }

    protected void doBeginRead() {
        if (!this.isActive()) {
            return;
        }
        if (this.readInFlight.compareAndExchange(false, true)) {
            return;
        }
        ((CompletableFuture)this.stream.readIrohStreamByteArray(65536L).thenAccept(arr -> {
            this.readInFlight.set(false);
            if (arr == null) {
                if (!this.closed) {
                    this.doClose();
                }
                return;
            }
            this.pipeline().fireChannelRead((Object)Unpooled.wrappedBuffer((byte[])arr));
            this.pipeline().fireChannelReadComplete();
        })).exceptionally(t -> {
            this.readInFlight.set(false);
            if (!this.closed) {
                this.pipeline().fireExceptionCaught(t);
            }
            return null;
        });
    }

    protected void doWrite(ChannelOutboundBuffer in) {
        if (this.writeInFlight.compareAndExchange(false, true)) {
            return;
        }
        while (true) {
            Object msg;
            if ((msg = in.current()) == null) break;
            if (msg instanceof ByteBuf) {
                ByteBuf buf = (ByteBuf)msg;
                if (!buf.isReadable()) {
                    in.remove();
                    this.writeInFlight.set(false);
                    continue;
                }
                ByteBuffer byteBuffer = null;
                try {
                    byteBuffer = buf.nioBuffer();
                    if (!byteBuffer.isDirect()) {
                        byteBuffer = null;
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    if (byteBuffer == null) {
                        byte[] arr = new byte[buf.readableBytes()];
                        buf.readBytes(arr, 0, buf.readableBytes());
                        ((CompletableFuture)this.stream.writeIrohStreamByteArray(arr, 0L, arr.length).thenAccept(nothing -> {
                            in.remove();
                            this.writeInFlight.set(false);
                        })).join();
                        continue;
                    }
                    assert (byteBuffer.remaining() == buf.readableBytes());
                    this.stream.writeIrohStreamByteBuffer(byteBuffer, byteBuffer.position(), byteBuffer.remaining()).join();
                    in.remove();
                    this.writeInFlight.set(false);
                }
                catch (Throwable e) {
                    in.remove(e);
                    this.writeInFlight.set(false);
                }
                continue;
            }
            in.remove((Throwable)new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)msg)));
            this.writeInFlight.set(false);
        }
        this.writeInFlight.set(false);
    }

    public ChannelConfig config() {
        return this.config;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public boolean isActive() {
        return this.stream != null && !this.closed;
    }

    public ChannelMetadata metadata() {
        return METADATA;
    }

    private class DialtoneUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private DialtoneUnsafe() {
            super((AbstractChannel)DialtoneChannel.this);
        }

        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            if (!promise.setUncancellable() || !this.ensureOpen(promise)) {
                return;
            }
            try {
                DialtoneAddress dialtoneAddress;
                if (remoteAddress instanceof DialtoneAddress) {
                    dialtoneAddress = (DialtoneAddress)remoteAddress;
                    if (DialtoneAmbientSession.INSTANCE.endpoint == null) {
                        DialtoneAmbientSession.INSTANCE.start();
                    }
                } else {
                    throw new UnsupportedOperationException();
                }
                DialtoneChannel.this.endpoint = DialtoneAmbientSession.INSTANCE.endpoint;
                ((CompletableFuture)DialtoneAmbientSession.INSTANCE.endpoint.connect(dialtoneAddress.actualAddress, "e4mc-dialtone".getBytes(StandardCharsets.UTF_8)).thenAccept(conn -> {
                    DialtoneChannel.this.connection = conn;
                    ((CompletableFuture)conn.openBi().thenAccept(bidi -> {
                        DialtoneChannel.this.stream = bidi;
                        DialtoneChannel.this.pipeline().fireChannelActive();
                        this.safeSetSuccess(promise);
                    })).exceptionally(t -> {
                        this.safeSetFailure(promise, this.annotateConnectException((Throwable)t, remoteAddress));
                        return null;
                    });
                })).exceptionally(t -> {
                    this.safeSetFailure(promise, this.annotateConnectException((Throwable)t, remoteAddress));
                    return null;
                });
            }
            catch (Throwable t2) {
                this.safeSetFailure(promise, this.annotateConnectException(t2, remoteAddress));
            }
        }
    }
}

