/*
 * Decompiled with CFR 0.152.
 */
package link.e4mc.iroh;

import java.util.concurrent.CompletableFuture;
import link.e4mc.iroh.CompletableFutureResolvable;
import link.e4mc.iroh.Connection;
import link.e4mc.iroh.Native;
import link.e4mc.iroh.Resolvable;

public class Endpoint
implements AutoCloseable {
    private long ptrEndpointBundle = 0L;
    private long ptrCallbackReceiver = 0L;

    public Endpoint(byte[][] alpns) {
        this(alpns, null);
    }

    public Endpoint(byte[][] alpns, String[] relays) {
        Native.initEndpointBundle(this, alpns, relays);
    }

    public Runnable pollCallbackLoop() {
        return Native.pollEndpointBundle(this);
    }

    public String address() {
        return Native.addrEndpointBundle(this);
    }

    public void watchAddress(Resolvable<String> resolvable) {
        Native.watchAddrEndpointBundle(this, resolvable);
    }

    public CompletableFuture<String> waitOnline() {
        CompletableFuture<String> fut = new CompletableFuture<String>();
        Native.onlineEndpointBundle(this, new CompletableFutureResolvable<String>(fut));
        return fut;
    }

    public CompletableFuture<CompletableFuture<Connection>> accept() {
        CompletableFuture fut = new CompletableFuture();
        CompletableFuture preFuture = new CompletableFuture();
        Native.acceptEndpointBundle(this, new CompletableFutureResolvable<Void>(preFuture), new CompletableFutureResolvable<Connection>(fut));
        return preFuture.thenApply(nothing -> fut);
    }

    public CompletableFuture<Connection> connect(String addr, byte[] alpn) {
        CompletableFuture<Connection> fut = new CompletableFuture<Connection>();
        Native.connectEndpointBundle(this, addr, alpn, new CompletableFutureResolvable<Connection>(fut));
        return fut;
    }

    public CompletableFuture<Void> closeAsync() {
        CompletableFuture<Void> fut = new CompletableFuture<Void>();
        Native.closeEndpointBundle(this, new CompletableFutureResolvable<Void>(fut));
        return fut;
    }

    @Override
    public void close() {
        Native.freeEndpointBundle(this);
    }

    public static String sanitizeTicket(String ticket) {
        return Native.sanitizeTicket(ticket);
    }
}

