/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.structure;

import com.seibel.distanthorizons.api.interfaces.override.levelHandling.IDhApiSaveStructure;
import com.seibel.distanthorizons.core.file.structure.ISaveStructure;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import com.seibel.distanthorizons.coreapi.DependencyInjection.OverrideInjector;
import com.seibel.distanthorizons.coreapi.util.StringUtil;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;

public class LocalSaveStructure
implements ISaveStructure {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private final ConcurrentHashMap<ILevelWrapper, File> levelWrapperToFileMap = new ConcurrentHashMap();

    @Override
    public File getSaveFolder(ILevelWrapper levelWrapper) {
        return this.levelWrapperToFileMap.computeIfAbsent(levelWrapper, newLevelWrapper -> {
            File overrideFile;
            IServerLevelWrapper serverLevelWrapper = (IServerLevelWrapper)levelWrapper;
            File saveFolder = serverLevelWrapper.getMcSaveFolder();
            IDhApiSaveStructure saveStructureOverride = OverrideInjector.INSTANCE.get(IDhApiSaveStructure.class);
            if (saveStructureOverride != null && (overrideFile = saveStructureOverride.overrideFilePath(saveFolder, levelWrapper)) != null) {
                LOGGER.info("Save folder overridden from [" + saveFolder.getPath() + "] -> [" + overrideFile.getPath() + "].", new Object[0]);
                saveFolder = overrideFile;
            }
            return saveFolder;
        });
    }

    @Override
    public File getPre23SaveFolder(ILevelWrapper levelWrapper) {
        return this.getSaveFolder(levelWrapper);
    }

    @Override
    public void close() throws Exception {
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "@(" + StringUtil.join(";", this.levelWrapperToFileMap.values()) + ")]";
    }
}

