/*
 * Decompiled with CFR 0.152.
 */
package dev.pandasystems.fallingtrees.api;

import com.mojang.logging.LogUtils;
import dev.pandasystems.fallingtrees.FallingTreesRegistriesKt;
import dev.pandasystems.fallingtrees.api.TreeData;
import dev.pandasystems.fallingtrees.api.TreeType;
import dev.pandasystems.fallingtrees.config.ClientConfig;
import dev.pandasystems.fallingtrees.config.CommonConfig;
import dev.pandasystems.fallingtrees.config.FallingTreesConfigKt;
import dev.pandasystems.fallingtrees.config.MiningOptionEnum;
import dev.pandasystems.fallingtrees.entity.TreeEntity;
import dev.pandasystems.fallingtrees.exceptions.TreeException;
import dev.pandasystems.pandalib.config.ConfigSynchronizerKt;
import dev.pandasystems.pandalib.event.server.ServerBlockEventsKt;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001,B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J/\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J'\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J7\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ/\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001f2\u0006\u0010\r\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001dH\u0007\u00a2\u0006\u0004\b \u0010!R\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R#\u0010(\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0%8\u0006\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\u00a8\u0006-"}, d2={"Ldev/pandasystems/fallingtrees/api/TreeHandler;", "", "<init>", "()V", "", "init", "Lnet/minecraft/class_1937;", "level", "Lnet/minecraft/class_2338;", "pos", "Lnet/minecraft/class_2680;", "state", "Lnet/minecraft/class_3222;", "player", "", "onBlockBreak", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;Lnet/minecraft/class_3222;)Z", "blockPos", "Lnet/minecraft/class_1657;", "destroyTree", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lnet/minecraft/class_1657;)Z", "Ldev/pandasystems/fallingtrees/api/TreeType;", "treeType", "ignoreExceptions", "Ldev/pandasystems/fallingtrees/api/TreeData;", "tryGatherTreeData", "(Ldev/pandasystems/fallingtrees/api/TreeType;Lnet/minecraft/class_2338;Lnet/minecraft/class_1937;Lnet/minecraft/class_1657;Z)Ldev/pandasystems/fallingtrees/api/TreeData;", "canPlayerChopTree", "(Lnet/minecraft/class_1657;)Z", "", "baseSpeed", "Ljava/util/Optional;", "getMiningSpeed", "(Lnet/minecraft/class_1657;Lnet/minecraft/class_2338;F)Ljava/util/Optional;", "Lorg/slf4j/Logger;", "LOGGER", "Lorg/slf4j/Logger;", "", "Ljava/util/UUID;", "Ldev/pandasystems/fallingtrees/api/TreeHandler$TreeSpeed;", "TREE_SPEED_CACHES", "Ljava/util/Map;", "getTREE_SPEED_CACHES", "()Ljava/util/Map;", "TreeSpeed", "fallingtrees-common-1.21.10"})
@SourceDebugExtension(value={"SMAP\nTreeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeHandler.kt\ndev/pandasystems/fallingtrees/api/TreeHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1869#2,2:153\n1869#2,2:155\n1869#2,2:157\n*S KotlinDebug\n*F\n+ 1 TreeHandler.kt\ndev/pandasystems/fallingtrees/api/TreeHandler\n*L\n86#1:153,2\n89#1:155,2\n95#1:157,2\n*E\n"})
public final class TreeHandler {
    @NotNull
    public static final TreeHandler INSTANCE = new TreeHandler();
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final Map<UUID, TreeSpeed> TREE_SPEED_CACHES;

    private TreeHandler() {
    }

    @NotNull
    public final Map<UUID, TreeSpeed> getTREE_SPEED_CACHES() {
        return TREE_SPEED_CACHES;
    }

    public final void init() {
        ServerBlockEventsKt.getServerBlockBreakPreEvent().plusAssign((Function)new Function4<class_1937, class_2338, class_2680, class_3222, Boolean>((Object)this){

            public final Boolean invoke(class_1937 p0, class_2338 p1, class_2680 p2, class_3222 p3) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
                return TreeHandler.access$onBlockBreak((TreeHandler)this.receiver, p0, p1, p2, p3);
            }
        });
    }

    private final boolean onBlockBreak(class_1937 level, class_2338 pos, class_2680 state, class_3222 player) {
        if (!TreeHandler.canPlayerChopTree((class_1657)player)) {
            return true;
        }
        return !TreeHandler.destroyTree(level, pos, (class_1657)player);
    }

    @JvmStatic
    public static final boolean destroyTree(@NotNull class_1937 level, @NotNull class_2338 blockPos, @NotNull class_1657 player) {
        class_2338 pos;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (level.method_8608()) {
            return false;
        }
        class_2680 blockState = level.method_8320(blockPos);
        Intrinsics.checkNotNull((Object)blockState);
        TreeType treeType = FallingTreesRegistriesKt.getTree(blockState);
        if (treeType == null) {
            return false;
        }
        TreeType tree = treeType;
        TreeData treeData = INSTANCE.tryGatherTreeData(tree, blockPos, level, player, false);
        if (treeData == null) {
            return false;
        }
        TreeData data = treeData;
        List<class_2338> blocks = data.blocks();
        Object object = FallingTreesRegistriesKt.getTreeEntity().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        TreeEntity entity = new TreeEntity((class_1299)object, level);
        entity.method_5814((double)blockPos.method_10263() + 0.5, blockPos.method_10264(), (double)blockPos.method_10260() + 0.5);
        entity.setData((class_1297)player, tree, blockPos, blocks, data.drops());
        player.method_7322(((CommonConfig)FallingTreesConfigKt.getFallingTreesCommonConfig().get()).getDisableExtraFoodExhaustion() ? 0.005f : data.foodExhaustionModifier().getExhaustion(0.005f));
        if (player.method_6047().method_7963()) {
            player.method_6047().method_7970(((CommonConfig)FallingTreesConfigKt.getFallingTreesCommonConfig().get()).getDisableExtraToolDamage() ? 1 : data.toolDamage(), (class_1309)player, class_1304.field_6173);
        }
        player.method_7259(class_3468.field_15372.method_14956((Object)player.method_6047().method_7909()));
        Iterable $this$forEach$iv = data.awardedStats();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TreeData.AwardedStat awardedStat = (TreeData.AwardedStat)element$iv;
            boolean bl = false;
            player.method_7342(awardedStat.stat(), awardedStat.amount());
        }
        $this$forEach$iv = blocks;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            pos = (class_2338)element$iv;
            boolean bl = false;
            level.method_30092(pos, class_2246.field_10124.method_9564(), 3, 0);
        }
        $this$forEach$iv = blocks;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            pos = (class_2338)element$iv;
            boolean bl = false;
            level.method_8408(pos, class_2246.field_10124);
        }
        level.method_8649((class_1297)entity);
        return true;
    }

    @Nullable
    public final TreeData tryGatherTreeData(@NotNull TreeType treeType, @NotNull class_2338 blockPos, @NotNull class_1937 level, @NotNull class_1657 player, boolean ignoreExceptions) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)treeType, (String)"treeType");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            try {
                return treeType.gatherTreeData(blockPos, level, player);
            }
            catch (TreeException e) {
                if (!ignoreExceptions) {
                    LOGGER.warn(e.getMessage());
                }
            }
            catch (Exception e) {
                if (ignoreExceptions) break block4;
                LOGGER.error("An error occurred when trying to gather tree data", (Throwable)e);
                player.method_7353((class_2561)class_2561.method_43470((String)("Error: " + e)).method_27696(class_2583.field_24360.method_36139(Color.red.getRGB())), false);
                player.method_7353((class_2561)class_2561.method_43471((String)"text.fallingtrees.tree_handler.exception.1").method_27696(class_2583.field_24360.method_36139(Color.red.getRGB())), false);
                player.method_7353((class_2561)class_2561.method_43471((String)"text.fallingtrees.tree_handler.exception.2").method_27696(class_2583.field_24360.method_36139(Color.red.getRGB())), false);
            }
        }
        return null;
    }

    @JvmStatic
    public static final boolean canPlayerChopTree(@NotNull class_1657 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        MiningOptionEnum option2 = player.method_18276() ? (MiningOptionEnum)((Object)ConfigSynchronizerKt.getSynced(FallingTreesConfigKt.getFallingTreesClientConfig(), (KProperty)((KProperty)new MutablePropertyReference0Impl(ClientConfig.INSTANCE){

            public Object get() {
                return ((ClientConfig)this.receiver).getMiningWhileCrouchingShould();
            }

            public void set(Object value) {
                ((ClientConfig)this.receiver).setMiningWhileCrouchingShould((MiningOptionEnum)((Object)value));
            }
        })).get(player)) : (MiningOptionEnum)((Object)ConfigSynchronizerKt.getSynced(FallingTreesConfigKt.getFallingTreesClientConfig(), (KProperty)((KProperty)new MutablePropertyReference0Impl(ClientConfig.INSTANCE){

            public Object get() {
                return ((ClientConfig)this.receiver).getMiningShould();
            }

            public void set(Object value) {
                ((ClientConfig)this.receiver).setMiningShould((MiningOptionEnum)((Object)value));
            }
        })).get(player));
        return ((CommonConfig)FallingTreesConfigKt.getFallingTreesCommonConfig().get()).getDisableCrouchMining() || option2 == MiningOptionEnum.CHOP_TREE;
    }

    @JvmStatic
    @NotNull
    public static final Optional<Float> getMiningSpeed(@NotNull class_1657 player, @NotNull class_2338 blockPos, float baseSpeed) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        TreeSpeed treeSpeed = TREE_SPEED_CACHES.compute(player.method_5667(), (arg_0, arg_1) -> TreeHandler.getMiningSpeed$lambda$4((arg_0, arg_1) -> TreeHandler.getMiningSpeed$lambda$3(blockPos, baseSpeed, player, arg_0, arg_1), arg_0, arg_1));
        Optional<Float> optional = Optional.ofNullable(treeSpeed).map(TreeHandler::getMiningSpeed$lambda$5);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"map(...)");
        return optional;
    }

    private static final TreeSpeed getMiningSpeed$lambda$3(class_2338 $blockPos, float $baseSpeed, class_1657 $player, UUID uUID, TreeSpeed speed) {
        if (speed == null || !speed.isValid($blockPos, $baseSpeed)) {
            class_2680 blockState = $player.method_73183().method_8320($blockPos);
            Intrinsics.checkNotNull((Object)blockState);
            TreeType treeType = FallingTreesRegistriesKt.getTree(blockState);
            if (treeType == null) {
                return null;
            }
            TreeType tree = treeType;
            class_1937 class_19372 = $player.method_73183();
            Intrinsics.checkNotNullExpressionValue((Object)class_19372, (String)"level(...)");
            TreeData treeData = INSTANCE.tryGatherTreeData(tree, $blockPos, class_19372, $player, true);
            if (treeData == null) {
                return null;
            }
            TreeData data = treeData;
            return new TreeSpeed($baseSpeed, data.miningSpeedModifier().getMiningSpeed($baseSpeed), $blockPos.method_10062());
        }
        return speed;
    }

    private static final TreeSpeed getMiningSpeed$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        return (TreeSpeed)$tmp0.invoke(p0, p1);
    }

    private static final Float getMiningSpeed$lambda$5(TreeSpeed obj) {
        TreeSpeed treeSpeed = obj;
        Intrinsics.checkNotNull((Object)treeSpeed);
        return Float.valueOf(treeSpeed.getMiningSpeed());
    }

    public static final /* synthetic */ boolean access$onBlockBreak(TreeHandler $this, class_1937 level, class_2338 pos, class_2680 state, class_3222 player) {
        return $this.onBlockBreak(level, pos, state, player);
    }

    static {
        Logger logger = LogUtils.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        TREE_SPEED_CACHES = new ConcurrentHashMap();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u000b\u001a\u00020\n2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\rR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0010\u00a8\u0006\u0011"}, d2={"Ldev/pandasystems/fallingtrees/api/TreeHandler$TreeSpeed;", "", "", "baseMiningSpeed", "miningSpeed", "Lnet/minecraft/class_2338;", "blockPos", "<init>", "(FFLnet/minecraft/class_2338;)V", "baseSpeed", "", "isValid", "(Lnet/minecraft/class_2338;F)Z", "F", "getMiningSpeed", "()F", "Lnet/minecraft/class_2338;", "fallingtrees-common-1.21.10"})
    public static final class TreeSpeed {
        private final float baseMiningSpeed;
        private final float miningSpeed;
        @Nullable
        private final class_2338 blockPos;

        public TreeSpeed(float baseMiningSpeed, float miningSpeed, @Nullable class_2338 blockPos) {
            this.baseMiningSpeed = baseMiningSpeed;
            this.miningSpeed = miningSpeed;
            this.blockPos = blockPos;
        }

        public final float getMiningSpeed() {
            return this.miningSpeed;
        }

        public final boolean isValid(@Nullable class_2338 blockPos, float baseSpeed) {
            return Intrinsics.areEqual((Object)this.blockPos, (Object)blockPos) && this.baseMiningSpeed == baseSpeed;
        }
    }
}

