/*
 * Decompiled with CFR 0.152.
 */
package dev.pandasystems.fallingtrees.trees.mushroom;

import dev.pandasystems.fallingtrees.api.TreeData;
import dev.pandasystems.fallingtrees.api.TreeType;
import dev.pandasystems.fallingtrees.config.CommonConfig;
import dev.pandasystems.fallingtrees.config.FallingTreesConfigKt;
import dev.pandasystems.fallingtrees.config.common.tree.TreeConfig;
import dev.pandasystems.fallingtrees.entity.TreeEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ)\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J%\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J%\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0015R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001d\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001f"}, d2={"Ldev/pandasystems/fallingtrees/trees/mushroom/RedMushroomTree;", "Ldev/pandasystems/fallingtrees/api/TreeType;", "<init>", "()V", "Lnet/minecraft/class_2680;", "blockState", "", "isTreeStem", "(Lnet/minecraft/class_2680;)Z", "Lnet/minecraft/class_2338;", "blockPos", "Lnet/minecraft/class_1937;", "level", "Lnet/minecraft/class_1657;", "player", "Ldev/pandasystems/fallingtrees/api/TreeData;", "gatherTreeData", "(Lnet/minecraft/class_2338;Lnet/minecraft/class_1937;Lnet/minecraft/class_1657;)Ldev/pandasystems/fallingtrees/api/TreeData;", "startPos", "", "gatherStemBlocks", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;)Ljava/util/Set;", "gatherCapBlocks", "", "capScanOffset", "[Lnet/minecraft/class_2338;", "Ldev/pandasystems/fallingtrees/config/common/tree/TreeConfig;", "getConfig", "()Ldev/pandasystems/fallingtrees/config/common/tree/TreeConfig;", "config", "BlockSearchNode", "fallingtrees-common-1.21.10"})
public final class RedMushroomTree
implements TreeType {
    @NotNull
    private final class_2338[] capScanOffset;

    public RedMushroomTree() {
        class_2338[] class_2338Array = new class_2338[]{new class_2338(-1, 0, 0), new class_2338(1, 0, 0), new class_2338(0, 0, -1), new class_2338(0, 0, 1), new class_2338(-1, -1, 0), new class_2338(1, -1, 0), new class_2338(0, -1, -1), new class_2338(0, -1, 1)};
        this.capScanOffset = class_2338Array;
    }

    @NotNull
    public final TreeConfig getConfig() {
        return ((CommonConfig)FallingTreesConfigKt.getFallingTreesCommonConfig().get()).getTrees().getMushroomTree();
    }

    @Override
    public boolean isTreeStem(@NotNull class_2680 blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return blockState.method_27852(class_2246.field_10556);
    }

    @Override
    @Nullable
    public TreeData gatherTreeData(@NotNull class_2338 blockPos, @NotNull class_1937 level, @NotNull class_1657 player) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        class_2338 blockPos2 = blockPos;
        if (this.getConfig().getRequireTool()) {
            TreeConfig.Filter filter = this.getConfig().getAllowedToolFilter();
            class_1799 class_17992 = player.method_6047();
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"getMainHandItem(...)");
            if (!filter.isValid(class_17992)) {
                return null;
            }
        }
        class_2338 class_23382 = blockPos2.method_10062();
        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"immutable(...)");
        blockPos2 = class_23382;
        TreeData.Builder builder = new TreeData.Builder();
        Set<class_2338> stemBlocks = this.gatherStemBlocks(level, blockPos2);
        Set capBlocks = new LinkedHashSet();
        stemBlocks.forEach(arg_0 -> RedMushroomTree.gatherTreeData$lambda$0(capBlocks, this, level, arg_0));
        if (capBlocks.isEmpty()) {
            return null;
        }
        List blocks = new ArrayList();
        blocks.addAll((Collection)stemBlocks);
        blocks.addAll(capBlocks);
        List drops = new ArrayList();
        if (level instanceof class_3218) {
            for (class_2338 block : blocks) {
                class_2680 blockState = ((class_3218)level).method_8320(block);
                List items = class_2248.method_9609((class_2680)blockState, (class_3218)((class_3218)level), (class_2338)block, null, (class_1297)((class_1297)player), (class_1799)player.method_6047());
                Intrinsics.checkNotNull((Object)items);
                drops.addAll(items);
            }
        }
        TreeData.Builder builder2 = builder.addBlocks(blocks).setToolDamage(blocks.size()).setFoodExhaustionModifier(arg_0 -> RedMushroomTree.gatherTreeData$lambda$1(blocks, arg_0)).addDrops(drops).setMiningSpeedModifier(arg_0 -> RedMushroomTree.gatherTreeData$lambda$2(blocks, arg_0));
        List<class_3445> list = blocks.stream().map(arg_0 -> RedMushroomTree.gatherTreeData$lambda$4(arg_0 -> RedMushroomTree.gatherTreeData$lambda$3(level, arg_0), arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        return builder2.addAwardedStats((Collection)list).build();
    }

    private final Set<class_2338> gatherStemBlocks(class_1937 level, class_2338 startPos) {
        Set blocks = new LinkedHashSet();
        Stack<class_2338> toVisit = new Stack<class_2338>();
        Set visited = new LinkedHashSet();
        toVisit.add(startPos);
        while (!toVisit.isEmpty()) {
            class_2338 current = (class_2338)toVisit.pop();
            if (visited.contains(current)) continue;
            Intrinsics.checkNotNull((Object)current);
            visited.add(current);
            class_2680 currentState = level.method_8320(current);
            Intrinsics.checkNotNull((Object)currentState);
            if (!this.isTreeStem(currentState)) continue;
            blocks.add(current);
            class_2338 neighbor = current.method_10084();
            if (visited.contains(neighbor)) continue;
            toVisit.add(neighbor);
        }
        return blocks;
    }

    private final Set<class_2338> gatherCapBlocks(class_1937 level, class_2338 startPos) {
        Set blocks = new LinkedHashSet();
        Queue toVisit = new LinkedList();
        Set visited = new LinkedHashSet();
        toVisit.add(new BlockSearchNode(startPos, 1));
        while (!toVisit.isEmpty()) {
            BlockSearchNode node = (BlockSearchNode)toVisit.poll();
            class_2338 current = node.position();
            if (visited.contains(current) || node.distance() > 6) continue;
            visited.add(current);
            class_2680 currentState = level.method_8320(current);
            if (!currentState.method_27852(class_2246.field_10240)) continue;
            blocks.add(current);
            for (class_2338 offset : this.capScanOffset) {
                class_2338 neighbor = current.method_10081((class_2382)offset);
                if (visited.contains(neighbor)) continue;
                Intrinsics.checkNotNull((Object)neighbor);
                toVisit.add(new BlockSearchNode(neighbor, node.distance() + 1));
            }
        }
        return blocks;
    }

    @Override
    public void onTreeTick(@NotNull TreeEntity entity) {
        TreeType.super.onTreeTick(entity);
    }

    private static final void gatherTreeData$lambda$0(Set $capBlocks, RedMushroomTree this$0, class_1937 $level, class_2338 stemPos) {
        Intrinsics.checkNotNullParameter((Object)stemPos, (String)"stemPos");
        class_2338 class_23382 = stemPos.method_10084();
        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"above(...)");
        $capBlocks.addAll((Collection)this$0.gatherCapBlocks($level, class_23382));
    }

    private static final float gatherTreeData$lambda$1(List $blocks, float originalExhaustion) {
        return originalExhaustion * (float)$blocks.size();
    }

    private static final float gatherTreeData$lambda$2(List $blocks, float originalMiningSpeed) {
        float speedMultiplication = ((CommonConfig)FallingTreesConfigKt.getFallingTreesCommonConfig().get()).getDynamicMiningSpeed().getSpeedMultiplication();
        float multiplyAmount = RangesKt.coerceAtMost((float)((CommonConfig)FallingTreesConfigKt.getFallingTreesCommonConfig().get()).getDynamicMiningSpeed().getMaxSpeedMultiplication(), (float)((float)$blocks.size() - 1.0f));
        return originalMiningSpeed / (multiplyAmount * speedMultiplication + 1.0f);
    }

    private static final class_3445 gatherTreeData$lambda$3(class_1937 $level, class_2338 logPos) {
        Intrinsics.checkNotNullParameter((Object)logPos, (String)"logPos");
        class_2680 blockState = $level.method_8320(logPos);
        return class_3468.field_15427.method_14956((Object)blockState.method_26204());
    }

    private static final class_3445 gatherTreeData$lambda$4(Function1 $tmp0, Object p0) {
        return (class_3445)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u000bJ\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0017\u001a\u0004\b\u0003\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0005\u0010\u000b\u00a8\u0006\u0019"}, d2={"Ldev/pandasystems/fallingtrees/trees/mushroom/RedMushroomTree$BlockSearchNode;", "Ljava/lang/Record;", "Lnet/minecraft/class_2338;", "position", "", "distance", "<init>", "(Lnet/minecraft/class_2338;I)V", "component1", "()Lnet/minecraft/class_2338;", "component2", "()I", "copy", "(Lnet/minecraft/class_2338;I)Ldev/pandasystems/fallingtrees/trees/mushroom/RedMushroomTree$BlockSearchNode;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_2338;", "I", "fallingtrees-common-1.21.10"})
    private static final class BlockSearchNode
    extends Record {
        @NotNull
        private final class_2338 position;
        private final int distance;

        public BlockSearchNode(@NotNull class_2338 position, int distance) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            this.position = position;
            this.distance = distance;
        }

        @NotNull
        public final class_2338 position() {
            return this.position;
        }

        public final int distance() {
            return this.distance;
        }

        @NotNull
        public final class_2338 component1() {
            return this.position;
        }

        public final int component2() {
            return this.distance;
        }

        @NotNull
        public final BlockSearchNode copy(@NotNull class_2338 position, int distance) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            return new BlockSearchNode(position, distance);
        }

        public static /* synthetic */ BlockSearchNode copy$default(BlockSearchNode blockSearchNode, class_2338 class_23382, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                class_23382 = blockSearchNode.position;
            }
            if ((n2 & 2) != 0) {
                n = blockSearchNode.distance;
            }
            return blockSearchNode.copy(class_23382, n);
        }

        @Override
        @NotNull
        public String toString() {
            return "BlockSearchNode(position=" + this.position + ", distance=" + this.distance + ")";
        }

        @Override
        public int hashCode() {
            int result = this.position.hashCode();
            result = result * 31 + Integer.hashCode(this.distance);
            return result;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BlockSearchNode)) {
                return false;
            }
            BlockSearchNode blockSearchNode = (BlockSearchNode)other;
            if (!Intrinsics.areEqual((Object)this.position, (Object)blockSearchNode.position)) {
                return false;
            }
            return this.distance == blockSearchNode.distance;
        }
    }
}

