/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.screen;

import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TWidgetHudElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.registry.TClientRegistries;
import io.github.thecsdev.tcdcommons.api.client.util.interfaces.IParentScreenProvider;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.client.TCDCommonsClient;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class TWidgetHudScreen
extends TScreen
implements IParentScreenProvider {
    @ApiStatus.Internal
    private final List<WidgetEntry<?>> entries = new LinkedList();
    protected final class_2960 hudScreenId;
    @Nullable
    protected class_437 parent;

    public TWidgetHudScreen(class_2561 title, class_2960 hudScreenId) throws NullPointerException {
        super(title);
        this.hudScreenId = Objects.requireNonNull(hudScreenId);
    }

    @Override
    public final class_437 getParentScreen() {
        return this.parent;
    }

    public void refresh() {
        if (this.client == null) {
            return;
        }
        this.clearChildren();
        this.init();
    }

    @Override
    @Virtual
    protected void init() {
        this.entries.removeIf(entry -> entry == null);
        for (WidgetEntry<?> entry2 : this.entries) {
            this.initEntry(entry2);
        }
    }

    protected final boolean initEntry(WidgetEntry<?> entry) {
        if (!this.containsEntry(entry)) {
            return false;
        }
        TWidgetHudElement el = new TWidgetHudElement((TElement)Objects.requireNonNull(entry.createWidget()));
        entry.lastCreatedWidget = el;
        int w = this.getWidth();
        int h = this.getHeight();
        double aX = entry.anchorX;
        double aY = entry.anchorY;
        int sX = (int)((double)w * aX);
        int sY = (int)((double)h * aY);
        int eX = (int)((double)el.getWidth() * aX);
        int eY = (int)((double)el.getHeight() * aY);
        int pX = sX - eX;
        int pY = sY - eY;
        el.setPosition(pX, pY, false);
        el.eMoved.register((__, deltaX, deltaY) -> {
            int dW = w - el.getWidth();
            int dH = h - el.getHeight();
            entry.anchorX = (double)el.getX() / (double)dW;
            entry.anchorY = (double)el.getY() / (double)dH;
        });
        return this.addChild(el, false);
    }

    public final void refreshEntry(WidgetEntry<?> entry) {
        if (entry.lastCreatedWidget == null) {
            return;
        }
        this.removeChild(entry.lastCreatedWidget);
        this.initEntry(entry);
    }

    @Override
    @Virtual
    protected void onOpened() {
        if (!TClientRegistries.HUD_SCREEN.containsKey(this.hudScreenId)) {
            TClientRegistries.HUD_SCREEN.register(this.hudScreenId, this.getAsScreen());
        }
    }

    @Override
    @Virtual
    protected void onClosed() {
        super.onClosed();
        this.parent = null;
        if (this.entries.size() != 0) {
            return;
        }
        if (Objects.equals(TClientRegistries.HUD_SCREEN.getValue(this.hudScreenId).orElse(null), this.getAsScreen())) {
            TClientRegistries.HUD_SCREEN.unregister(this.hudScreenId);
        }
        this.refresh();
    }

    @Override
    @Virtual
    public void close() {
        TCDCommonsClient.MC_CLIENT.method_1507(this.parent);
    }

    @Override
    @Virtual
    public void renderBackground(TDrawContext pencil) {
    }

    public boolean addEntry(WidgetEntry<?> entry) {
        if (entry == null || this.entries.contains(entry) || entry.whs != null && entry.whs != this) {
            return false;
        }
        entry.whs = this;
        try {
            boolean bl = this.entries.add(entry);
            return bl;
        }
        finally {
            this.refresh();
        }
    }

    public boolean containsEntry(WidgetEntry<?> entry) {
        return this.entries.contains(entry);
    }

    public boolean removeEntry(WidgetEntry<?> entry) {
        entry.whs = null;
        try {
            boolean bl = this.entries.remove(entry);
            return bl;
        }
        finally {
            this.refresh();
        }
    }

    public final void clearEntries() {
        this.entries.forEach(e -> {
            e.whs = null;
        });
        this.entries.clear();
        this.refresh();
    }

    public final int entryCount() {
        return this.entries.size();
    }

    public final class_2960 getHudScreenID() {
        return this.hudScreenId;
    }

    @Virtual
    public void setParentScreen(class_437 parent) {
        this.parent = parent;
    }

    public static abstract class WidgetEntry<T extends TElement> {
        @ApiStatus.Internal
        @Nullable
        private TWidgetHudScreen whs;
        @ApiStatus.Internal
        private TElement lastCreatedWidget;
        protected double anchorX = 0.5;
        protected double anchorY = 0.5;

        public WidgetEntry() {
        }

        public WidgetEntry(double anchorX, double anchorY) {
            this.anchorX = anchorX;
            this.anchorY = anchorY;
        }

        public final TWidgetHudScreen getHudScreen() {
            if (this.whs != null && !this.whs.containsEntry(this)) {
                this.whs = null;
            }
            return this.whs;
        }

        public final void refreshEntry() {
            TWidgetHudScreen whs = this.getHudScreen();
            if (whs != null) {
                whs.refreshEntry(this);
            }
        }

        public final void removeEntry() {
            TWidgetHudScreen whs = this.getHudScreen();
            if (whs != null) {
                whs.removeEntry(this);
            }
        }

        public abstract T createWidget();
    }
}

