/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.model;

import java.util.function.Predicate;
import me.pepperbell.continuity.api.client.EmissiveSpriteApi;
import me.pepperbell.continuity.client.config.ContinuityConfig;
import me.pepperbell.continuity.client.model.ModelObjectsContainer;
import me.pepperbell.continuity.client.util.QuadUtil;
import me.pepperbell.continuity.client.util.RenderUtil;
import net.fabricmc.fabric.api.client.model.loading.v1.wrapper.WrapperBlockStateModel;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableMesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadTransform;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_11515;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class EmissiveBlockStateModel
extends WrapperBlockStateModel {
    public EmissiveBlockStateModel(class_1087 wrapped) {
        super(wrapped);
    }

    public void emitQuads(QuadEmitter emitter, class_1920 blockView, class_2338 pos, class_2680 state, class_5819 random, Predicate<@Nullable class_2350> cullTest) {
        if (!((Boolean)ContinuityConfig.INSTANCE.emissiveTextures.get()).booleanValue()) {
            super.emitQuads(emitter, blockView, pos, state, random, cullTest);
            return;
        }
        ModelObjectsContainer container = ModelObjectsContainer.get();
        if (!container.featureStates.getEmissiveTexturesState().isEnabled()) {
            super.emitQuads(emitter, blockView, pos, state, random, cullTest);
            return;
        }
        EmissiveQuadTransform quadTransform = container.emissiveQuadTransform;
        if (quadTransform.isActive()) {
            super.emitQuads(emitter, blockView, pos, state, random, cullTest);
            return;
        }
        MutableMesh mutableMesh = container.mutableMesh;
        quadTransform.prepare(mutableMesh.emitter(), state, cullTest);
        emitter.pushTransform((QuadTransform)quadTransform);
        super.emitQuads(emitter, blockView, pos, state, random, cullTest);
        emitter.popTransform();
        mutableMesh.outputTo(emitter);
        mutableMesh.clear();
        quadTransform.reset();
    }

    @Nullable
    public Object createGeometryKey(class_1920 blockView, class_2338 pos, class_2680 state, class_5819 random) {
        if (!((Boolean)ContinuityConfig.INSTANCE.emissiveTextures.get()).booleanValue()) {
            return super.createGeometryKey(blockView, pos, state, random);
        }
        ModelObjectsContainer container = ModelObjectsContainer.get();
        if (!container.featureStates.getEmissiveTexturesState().isEnabled()) {
            return super.createGeometryKey(blockView, pos, state, random);
        }
        EmissiveQuadTransform quadTransform = container.emissiveQuadTransform;
        if (quadTransform.isActive()) {
            return super.createGeometryKey(blockView, pos, state, random);
        }
        Object subkey = super.createGeometryKey(blockView, pos, state, random);
        if (subkey == null) {
            return null;
        }
        record Key(Object subkey) {
        }
        return new Key(subkey);
    }

    protected static class EmissiveQuadTransform
    implements QuadTransform {
        protected QuadEmitter emitter;
        protected class_2680 state;
        protected Predicate<@Nullable class_2350> cullTest;
        protected boolean active;
        protected boolean calculateDefaultLayer;
        protected boolean isDefaultLayerSolid;

        protected EmissiveQuadTransform() {
        }

        public boolean transform(MutableQuadView quad) {
            if (this.cullTest.test(quad.cullFace())) {
                return false;
            }
            class_1058 sprite = RenderUtil.getSpriteFinder().find((QuadView)quad);
            class_1058 emissiveSprite = EmissiveSpriteApi.get().getEmissiveSprite(sprite);
            if (emissiveSprite != null) {
                this.emitter.copyFrom((QuadView)quad);
                this.emitter.emissive(true).diffuseShade(false).ambientOcclusion(TriState.FALSE);
                class_11515 renderLayer = quad.renderLayer();
                if (renderLayer == null) {
                    if (this.calculateDefaultLayer) {
                        this.isDefaultLayerSolid = class_4696.method_23679((class_2680)this.state) == class_11515.field_60923;
                        this.calculateDefaultLayer = false;
                    }
                    if (this.isDefaultLayerSolid) {
                        this.emitter.renderLayer(class_11515.field_60924);
                    }
                } else if (renderLayer == class_11515.field_60923) {
                    this.emitter.renderLayer(class_11515.field_60924);
                }
                QuadUtil.interpolate((MutableQuadView)this.emitter, sprite, emissiveSprite);
                this.emitter.emit();
            }
            return true;
        }

        public boolean isActive() {
            return this.active;
        }

        public void prepare(QuadEmitter emitter, class_2680 state, Predicate<@Nullable class_2350> cullTest) {
            this.emitter = emitter;
            this.state = state;
            this.cullTest = cullTest;
            this.active = true;
            this.calculateDefaultLayer = true;
            this.isDefaultLayerSolid = false;
        }

        public void reset() {
            this.emitter = null;
            this.state = null;
            this.cullTest = null;
            this.active = false;
        }
    }
}

