/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.network;

import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.api.util.interfaces.IThirdPartyStatsListener;
import io.github.thecsdev.betterstats.api.util.io.ServerPlayerStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.StatsProviderIO;
import io.github.thecsdev.betterstats.network.BetterStatsNetwork;
import io.github.thecsdev.tcdcommons.api.hooks.entity.EntityHooks;
import io.github.thecsdev.tcdcommons.api.network.CustomPayloadNetwork;
import io.github.thecsdev.tcdcommons.api.network.CustomPayloadNetworkReceiver;
import io.github.thecsdev.tcdcommons.api.util.collections.GenericProperties;
import io.github.thecsdev.tcdcommons.mixin.hooks.AccessorServerPlayer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class BetterStatsServerPlayNetworkHandler {
    public static final class_2960 CUSTOM_DATA_ID = class_2960.method_60655((String)BetterStats.getModID(), (String)"server_play_network_handler");
    private final class_3222 player;
    private final MinecraftServer server;
    public boolean hasBssInstalled = false;
    public boolean netPref_enableLiveStats = false;
    public long liveStatsLastUpdate = 0L;
    public boolean netPref_statsSharingConsent = false;

    private BetterStatsServerPlayNetworkHandler(class_3222 player) throws NullPointerException {
        this.player = Objects.requireNonNull(player);
        this.server = Objects.requireNonNull(((AccessorServerPlayer)player).getServer());
    }

    public final class_3222 getPlayer() {
        return this.player;
    }

    public final void onPlayerConnected() {
        this.sendIHaveBss();
    }

    public final void onIHaveBss(CustomPayloadNetworkReceiver.PacketContext ctx) {
        class_2540 buffer = ctx.getPacketBuffer();
        if (buffer.readableBytes() == 0) {
            return;
        }
        int netVer = buffer.readIntLE();
        if (netVer != 3) {
            return;
        }
        this.hasBssInstalled = true;
    }

    public final void onPreferences(CustomPayloadNetworkReceiver.PacketContext ctx) {
        this.netPref_enableLiveStats = ctx.getPacketBuffer().readBoolean();
        this.netPref_statsSharingConsent = ctx.getPacketBuffer().readBoolean();
    }

    public final void onMcbsRequest(CustomPayloadNetworkReceiver.PacketContext ctx) {
        class_2540 buffer = ctx.getPacketBuffer();
        switch (IThirdPartyStatsListener.TpslContext.Type.of(buffer.readInt())) {
            case SAME_SERVER_PLAYER: {
                String playerName = buffer.method_19772();
                class_3222 targetPlayer = this.server.method_3760().method_14566(playerName);
                if (targetPlayer == null) {
                    this.sendNullPlayerMcbs(playerName);
                    return;
                }
                if (this.sendPlayerMcbs(targetPlayer, false)) break;
                this.sendNullPlayerMcbs(playerName);
                break;
            }
        }
    }

    public final void sendIHaveBss() {
        class_2540 data = new class_2540(Unpooled.buffer());
        data.method_53003(3);
        CustomPayloadNetwork.sendS2C((class_3222)this.player, (class_2960)BetterStatsNetwork.S2C_I_HAVE_BSS, (ByteBuf)data);
    }

    public final boolean sendLiveStatsAttepmt() {
        if (!this.netPref_enableLiveStats) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.liveStatsLastUpdate < 300L) {
            return false;
        }
        this.liveStatsLastUpdate = currentTime;
        this.player.method_14248().method_14910(this.player);
        return true;
    }

    public final boolean sendPlayerMcbs(class_3222 targetPlayer, boolean force) throws NullPointerException {
        Objects.requireNonNull(targetPlayer);
        if (!force && !BetterStatsServerPlayNetworkHandler.of((class_3222)targetPlayer).netPref_statsSharingConsent) {
            return false;
        }
        class_2540 data = new class_2540(Unpooled.buffer());
        data.method_53002(IThirdPartyStatsListener.TpslContext.Type.SAME_SERVER_PLAYER.getIntValue());
        data.method_10814(targetPlayer.method_5477().getString());
        StatsProviderIO.write(data, ServerPlayerStatsProvider.of(targetPlayer));
        CustomPayloadNetwork.sendS2C((class_3222)this.player, (class_2960)BetterStatsNetwork.S2C_MCBS, (ByteBuf)data);
        return true;
    }

    public final void sendNullPlayerMcbs(String playerName) throws NullPointerException {
        Objects.requireNonNull(playerName);
        class_2540 data = new class_2540(Unpooled.buffer());
        data.method_53002(IThirdPartyStatsListener.TpslContext.Type.SAME_SERVER_PLAYER_NOT_FOUND.getIntValue());
        data.method_10814(playerName);
        CustomPayloadNetwork.sendS2C((class_3222)this.player, (class_2960)BetterStatsNetwork.S2C_MCBS, (ByteBuf)data);
    }

    public static final BetterStatsServerPlayNetworkHandler of(class_3222 player) throws NullPointerException {
        GenericProperties cd = EntityHooks.getCustomData((class_1297)((class_1297)Objects.requireNonNull(player)));
        @Nullable BetterStatsServerPlayNetworkHandler spnh = (BetterStatsServerPlayNetworkHandler)cd.getProperty((Object)CUSTOM_DATA_ID);
        if (spnh == null) {
            spnh = new BetterStatsServerPlayNetworkHandler(player);
            cd.setProperty((Object)CUSTOM_DATA_ID, (Object[])new BetterStatsServerPlayNetworkHandler[]{spnh});
        }
        return spnh;
    }
}

