/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui.overridden;

import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.gui.overridden.PopupGuiScreen;
import com.mamiyaotaru.voxelmap.util.VoxelMapGuiGraphics;
import java.util.ArrayList;
import net.minecraft.class_10799;
import net.minecraft.class_11876;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class Popup {
    private final class_327 fontRendererObj;
    private int x;
    private int y;
    private final PopupEntry[] entries;
    private int w;
    private final int h;
    private final int clickedDirectX;
    private final int clickedDirectY;
    private boolean shouldClose;
    private final PopupGuiScreen parentGui;
    private final int padding = 6;

    public Popup(int x, int y, int directX, int directY, int minWidth, ArrayList<PopupEntry> entries, PopupGuiScreen parentGui) {
        this.fontRendererObj = VoxelConstants.getMinecraft().field_1772;
        this.parentGui = parentGui;
        this.clickedDirectX = directX;
        this.clickedDirectY = directY;
        this.x = x - 1;
        this.y = y - 1;
        this.entries = new PopupEntry[entries.size()];
        entries.toArray(this.entries);
        this.w = minWidth;
        this.h = this.entries.length * 20;
        for (PopupEntry entry : this.entries) {
            int entryWidth = this.fontRendererObj.method_1727(entry.name);
            if (entryWidth <= this.w) continue;
            this.w = entryWidth;
        }
        this.w += this.padding * 2;
        if (x + this.w > parentGui.field_22789) {
            this.x = x - this.w + 2;
        }
        if (y + this.h > parentGui.field_22790) {
            this.y = y - this.h + 2;
        }
    }

    public int getClickedDirectX() {
        return this.clickedDirectX;
    }

    public int getClickedDirectY() {
        return this.clickedDirectY;
    }

    public boolean clickedMe(double mouseX, double mouseY) {
        boolean clicked;
        boolean bl = clicked = mouseX > (double)this.x && mouseX < (double)(this.x + this.w) && mouseY > (double)this.y && mouseY < (double)(this.y + this.h);
        if (clicked) {
            for (int t = 0; t < this.entries.length; ++t) {
                boolean entryClicked;
                if (!this.entries[t].enabled) continue;
                boolean bl2 = entryClicked = mouseX >= (double)this.x && mouseX <= (double)(this.x + this.w) && mouseY >= (double)(this.y + t * 20) && mouseY < (double)(this.y + (t + 1) * 20);
                if (!entryClicked) continue;
                this.shouldClose = this.entries[t].causesClose;
                this.parentGui.popupAction(this, this.entries[t].action);
            }
        }
        return clicked;
    }

    public boolean overMe(int x, int y) {
        return x > this.x && x < this.x + this.w && y > this.y && y < this.y + this.h;
    }

    public boolean shouldClose() {
        return this.shouldClose;
    }

    public void drawPopup(class_332 guiGraphics, int mouseX, int mouseY) {
        guiGraphics.method_51448().pushMatrix();
        float renderedTextureSize = 32.0f;
        float umin = (float)this.x / renderedTextureSize;
        float umax = (float)(this.x + this.w) / renderedTextureSize;
        float vmin = (float)this.y / renderedTextureSize;
        float vmax = (float)(this.y + this.h) / renderedTextureSize;
        VoxelMapGuiGraphics.blitFloat(guiGraphics, class_10799.field_56883, VoxelConstants.getOptionsBackgroundTexture(), (float)this.x, (float)this.y, (float)this.w, (float)this.h, umin, umax, vmin, vmax, -12566464);
        VoxelMapGuiGraphics.fillGradient(guiGraphics, this.x, this.y, this.x + this.w, this.y + 4, -16777216, -16777216, 0, 0);
        VoxelMapGuiGraphics.fillGradient(guiGraphics, this.x, this.y + this.h - 4, this.x + this.w, this.y + this.h, 0, 0, -16777216, -16777216);
        VoxelMapGuiGraphics.fillGradient(guiGraphics, this.x, this.y, this.x + 4, this.y + this.h, -16777216, 0, -16777216, 0);
        VoxelMapGuiGraphics.fillGradient(guiGraphics, this.x + this.w - 4, this.y, this.x + this.w, this.y + this.h, 0, -16777216, 0, -16777216);
        for (int t = 0; t < this.entries.length; ++t) {
            boolean hover;
            boolean bl = hover = mouseX >= this.x && mouseX <= this.x + this.w && mouseY >= this.y + t * 20 && mouseY < this.y + (t + 1) * 20;
            if (hover) {
                guiGraphics.method_74037(class_11876.field_62455);
            }
            int color = !this.entries[t].enabled ? -6250336 : (hover ? -96 : -2039584);
            guiGraphics.method_25303(this.fontRendererObj, this.entries[t].name, this.x + this.padding, this.y + this.padding + t * 20, color);
        }
        guiGraphics.method_51448().popMatrix();
    }

    public static class PopupEntry {
        protected final String name;
        protected final int action;
        protected final boolean causesClose;
        protected final boolean enabled;

        public PopupEntry(String name, int action, boolean causesClose, boolean enabled) {
            this.name = name;
            this.action = action;
            this.causesClose = causesClose;
            this.enabled = enabled;
        }
    }
}

