/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.textures.GpuTexture;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10537;
import net.minecraft.class_10539;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.lwjgl.system.MemoryUtil;

public class ImageUtils {
    public static void saveImage(String name, GpuTexture texture) {
        ImageUtils.saveImage(name, texture, 0, texture.getWidth(0), texture.getHeight(0));
    }

    public static void saveImage(String name, GpuTexture texture, int maxMipmapLevel, int width, int height) {
        TextureUtil.writeAsPNG((Path)Paths.get("", new String[0]), (String)name, (GpuTexture)texture, (int)maxMipmapLevel, i -> i);
    }

    public static BufferedImage validateImage(BufferedImage image) {
        if (image.getType() != 6) {
            BufferedImage temp = new BufferedImage(image.getWidth(), image.getHeight(), 6);
            Graphics2D g2 = temp.createGraphics();
            g2.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
            g2.dispose();
            image = temp;
        }
        return image;
    }

    public static class_1011 createNativeImageFromResourceLocation(class_2960 resourceLocation) {
        try {
            return class_10539.method_65871((class_3300)class_310.method_1551().method_1478(), (class_2960)resourceLocation).comp_3447();
        }
        catch (Exception var5) {
            return null;
        }
    }

    public static BufferedImage createBufferedImageFromResourceLocation(class_2960 resourceLocation) {
        try {
            class_1044 texture = class_310.method_1551().method_1531().method_4619(resourceLocation);
            BufferedImage image = null;
            if (texture instanceof class_1043) {
                class_1043 dynamicTexture = (class_1043)texture;
                image = ImageUtils.bufferedImageFromNativeImage(dynamicTexture.method_4525());
            } else if (texture instanceof class_10537) {
                InputStream is = ((class_3298)VoxelConstants.getMinecraft().method_1478().method_14486(resourceLocation).get()).method_14482();
                image = ImageIO.read(is);
                is.close();
                if (image.getType() != 6) {
                    BufferedImage temp = new BufferedImage(image.getWidth(), image.getHeight(), 6);
                    Graphics2D g2 = temp.createGraphics();
                    g2.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
                    g2.dispose();
                    image = temp;
                }
            }
            return image;
        }
        catch (Exception var5) {
            return null;
        }
    }

    public static class_1011 nativeImageFromBufferedImage(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        class_1011 nativeImage = new class_1011(width, height, false);
        if (image.getType() == 6) {
            byte[] is = new byte[width * height * 4];
            image.getRaster().getDataElements(0, 0, width, height, is);
            MemoryUtil.memByteBuffer((long)nativeImage.method_67769(), (int)is.length).put(is);
            return nativeImage;
        }
        VoxelConstants.getLogger().warn("ImageUtils.nativeImageFromBufferedImage: Unoptimized image format: " + image.getType(), (Throwable)new Exception());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int argb = image.getRGB(x, y);
                nativeImage.method_61941(x, y, argb);
            }
        }
        return nativeImage;
    }

    public static BufferedImage bufferedImageFromNativeImage(class_1011 image) {
        if (image.method_67769() == 0L) {
            throw new IllegalStateException("image is not allocated!");
        }
        if (image.method_4318() != class_1011.class_1012.field_4997) {
            throw new IllegalStateException("invalid format. expected RGBA, got " + String.valueOf(image.method_4318()) + "!");
        }
        int width = image.method_4307();
        int height = image.method_4323();
        BufferedImage bufferedImage = new BufferedImage(width, height, 6);
        byte[] is = new byte[width * height * image.method_4318().method_4335()];
        MemoryUtil.memByteBuffer((long)image.method_67769(), (int)is.length).get(is);
        bufferedImage.getRaster().setDataElements(0, 0, width, height, is);
        return bufferedImage;
    }

    public static BufferedImage blankImage(class_2960 resourceLocation, int w, int h) {
        return ImageUtils.blankImage(resourceLocation, w, h, 64, 32);
    }

    public static BufferedImage blankImage(class_2960 resourceLocation, int w, int h, int imageWidth, int imageHeight) {
        return ImageUtils.blankImage(resourceLocation, w, h, imageWidth, imageHeight, 0, 0, 0, 0);
    }

    public static BufferedImage blankImage(class_2960 resourceLocation, int w, int h, int r, int g, int b, int a) {
        return ImageUtils.blankImage(resourceLocation, w, h, 64, 32, r, g, b, a);
    }

    public static BufferedImage blankImage(class_2960 resourceLocation, int w, int h, int imageWidth, int imageHeight, int r, int g, int b, int a) {
        try {
            InputStream is = ((class_3298)VoxelConstants.getMinecraft().method_1478().method_14486(resourceLocation).get()).method_14482();
            BufferedImage mobSkin = ImageIO.read(is);
            is.close();
            BufferedImage temp = new BufferedImage(w * mobSkin.getWidth() / imageWidth, h * mobSkin.getWidth() / imageWidth, 6);
            Graphics2D g2 = temp.createGraphics();
            g2.setColor(new Color(r, g, b, a));
            g2.fillRect(0, 0, temp.getWidth(), temp.getHeight());
            g2.dispose();
            return temp;
        }
        catch (Exception var13) {
            VoxelConstants.getLogger().error("Failed getting mob: " + resourceLocation.toString() + " - " + var13.getLocalizedMessage(), (Throwable)var13);
            return null;
        }
    }

    public static BufferedImage blankImage(BufferedImage mobSkin, int w, int h) {
        return ImageUtils.blankImage(mobSkin, w, h, 64, 32);
    }

    public static BufferedImage blankImage(BufferedImage mobSkin, int w, int h, int imageWidth, int imageHeight) {
        return ImageUtils.blankImage(mobSkin, w, h, imageWidth, imageHeight, 0, 0, 0, 0);
    }

    public static BufferedImage blankImage(BufferedImage mobSkin, int w, int h, int r, int g, int b, int a) {
        return ImageUtils.blankImage(mobSkin, w, h, 64, 32, r, g, b, a);
    }

    public static BufferedImage blankImage(BufferedImage mobSkin, int w, int h, int imageWidth, int imageHeight, int r, int g, int b, int a) {
        BufferedImage temp = new BufferedImage(w * mobSkin.getWidth() / imageWidth, h * mobSkin.getWidth() / imageWidth, 6);
        Graphics2D g2 = temp.createGraphics();
        g2.setColor(new Color(r, g, b, a));
        g2.fillRect(0, 0, temp.getWidth(), temp.getHeight());
        g2.dispose();
        return temp;
    }

    public static BufferedImage addCharacter(BufferedImage image, String character) {
        Graphics2D g2 = image.createGraphics();
        g2.setColor(new Color(0, 0, 0, 255));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setFont(new Font("Arial", 0, image.getHeight()));
        FontMetrics fm = g2.getFontMetrics();
        int x = (image.getWidth() - fm.stringWidth("?")) / 2;
        int y = fm.getAscent() + (image.getHeight() - (fm.getAscent() + fm.getDescent())) / 2;
        g2.drawString("?", x, y);
        g2.dispose();
        return image;
    }

    public static BufferedImage eraseArea(BufferedImage image, int x, int y, int w, int h, int imageWidth, int imageHeight) {
        float scaleX = (float)image.getWidth(null) / (float)imageWidth;
        float scaleY = (float)image.getHeight(null) / (float)imageHeight;
        x = (int)((float)x * scaleX);
        y = (int)((float)y * scaleY);
        w = (int)((float)w * scaleX);
        h = (int)((float)h * scaleY);
        int[] blankPixels = new int[w * h];
        Arrays.fill(blankPixels, 0);
        image.setRGB(x, y, w, h, blankPixels, 0, w);
        return image;
    }

    public static BufferedImage loadImage(class_2960 resourceLocation, int x, int y, int w, int h) {
        return ImageUtils.loadImage(resourceLocation, x, y, w, h, 64, 32);
    }

    public static BufferedImage loadImage(class_2960 resourceLocation, int x, int y, int w, int h, int imageWidth, int imageHeight) {
        BufferedImage mobSkin = ImageUtils.createBufferedImageFromResourceLocation(resourceLocation);
        if (mobSkin != null) {
            return ImageUtils.loadImage(mobSkin, x, y, w, h, imageWidth, imageHeight);
        }
        VoxelConstants.getLogger().warn("Failed getting image: " + resourceLocation.toString());
        return null;
    }

    public static BufferedImage loadImage(BufferedImage mobSkin, int x, int y, int w, int h) {
        return ImageUtils.loadImage(mobSkin, x, y, w, h, 64, 32);
    }

    public static BufferedImage loadImage(BufferedImage mobSkin, int x, int y, int w, int h, int imageWidth, int imageHeight) {
        float scale = (float)mobSkin.getWidth() / (float)imageWidth;
        x = (int)((float)x * scale);
        y = (int)((float)y * scale);
        w = (int)((float)w * scale);
        h = (int)((float)h * scale);
        w = Math.max(1, w);
        h = Math.max(1, h);
        x = Math.min(mobSkin.getWidth() - w, x);
        y = Math.min(mobSkin.getHeight() - h, y);
        return mobSkin.getSubimage(x, y, w, h);
    }

    public static BufferedImage addImages(BufferedImage base, BufferedImage overlay, float x, float y, int baseWidth, int baseHeight) {
        int scale = base.getWidth() / baseWidth;
        Graphics gfx = base.getGraphics();
        gfx.drawImage(overlay, (int)(x * (float)scale), (int)(y * (float)scale), null);
        gfx.dispose();
        return base;
    }

    public static BufferedImage scaleImage(BufferedImage image, float scaleBy) {
        if (scaleBy == 1.0f) {
            return image;
        }
        int type = image.getType();
        if (type == 13) {
            type = 6;
        }
        int newWidth = Math.max(1, (int)((float)image.getWidth() * scaleBy));
        int newHeight = Math.max(1, (int)((float)image.getHeight() * scaleBy));
        BufferedImage tmp = new BufferedImage(newWidth, newHeight, type);
        Graphics2D g2 = tmp.createGraphics();
        g2.drawImage(image, 0, 0, newWidth, newHeight, null);
        g2.dispose();
        return tmp;
    }

    public static BufferedImage scaleImage(BufferedImage image, float xScaleBy, float yScaleBy) {
        if (xScaleBy == 1.0f && yScaleBy == 1.0f) {
            return image;
        }
        int type = image.getType();
        if (type == 13) {
            type = 6;
        }
        int newWidth = Math.max(1, (int)((float)image.getWidth() * xScaleBy));
        int newHeight = Math.max(1, (int)((float)image.getHeight() * yScaleBy));
        BufferedImage tmp = new BufferedImage(newWidth, newHeight, type);
        Graphics2D g2 = tmp.createGraphics();
        g2.drawImage(image, 0, 0, newWidth, newHeight, null);
        g2.dispose();
        return tmp;
    }

    public static BufferedImage flipHorizontal(BufferedImage image) {
        AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
        tx.translate(-image.getWidth(null), 0.0);
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        return op.filter(image, null);
    }

    public static BufferedImage into128(BufferedImage base) {
        BufferedImage frame = new BufferedImage(128, 128, base.getType());
        Graphics gfx = frame.getGraphics();
        gfx.drawImage(base, 64 - base.getWidth() / 2, 64 - base.getHeight() / 2, base.getWidth(), base.getHeight(), null);
        gfx.dispose();
        return frame;
    }

    public static BufferedImage intoSquare(BufferedImage base) {
        int dim = Math.max(base.getWidth(), base.getHeight());
        int t = 1;
        while (Math.pow(2.0, t - 1) < (double)dim) {
            ++t;
        }
        int size = (int)Math.pow(2.0, t);
        BufferedImage frame = new BufferedImage(size, size, base.getType());
        Graphics gfx = frame.getGraphics();
        gfx.drawImage(base, (size - base.getWidth()) / 2, (size - base.getHeight()) / 2, base.getWidth(), base.getHeight(), null);
        gfx.dispose();
        return frame;
    }

    public static BufferedImage pad(BufferedImage base) {
        int dim = Math.max(base.getWidth(), base.getHeight());
        int outlineWidth = 3;
        int size = dim + outlineWidth * 2;
        BufferedImage frame = new BufferedImage(size, size, base.getType());
        Graphics gfx = frame.getGraphics();
        gfx.drawImage(base, (size - base.getWidth()) / 2, (size - base.getHeight()) / 2, base.getWidth(), base.getHeight(), null);
        gfx.dispose();
        return frame;
    }

    public static BufferedImage fillOutline(BufferedImage image, boolean outline, int passes) {
        return ImageUtils.fillOutline(image, outline, false, 0.0f, 0.0f, passes);
    }

    public static BufferedImage fillOutline(BufferedImage image, boolean outline, boolean armor, float intendedWidth, float intendedHeight, int passes) {
        if (outline) {
            for (int t = 0; t < passes; ++t) {
                image = ImageUtils.fillOutline(image, true, armor, intendedWidth, intendedHeight);
            }
        }
        return ImageUtils.fillOutline(image, false, armor, intendedWidth, intendedHeight);
    }

    private static BufferedImage fillOutline(BufferedImage image, boolean solid, boolean armor, float intendedWidth, float intendedHeight) {
        float armorOutlineFractionHorizontal = intendedWidth / 2.0f - 1.0f;
        float armorOutlineFractionVertical = intendedHeight / 2.0f - 1.0f;
        BufferedImage temp = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        Graphics gfx = temp.getGraphics();
        gfx.drawImage(image, 0, 0, null);
        gfx.dispose();
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        for (int t = 0; t < image.getWidth(); ++t) {
            for (int s = 0; s < image.getHeight(); ++s) {
                int newColor;
                int color = image.getRGB(t, s);
                if ((color >> 24 & 0xFF) != 0 || (newColor = ImageUtils.sampleNonTransparentNeighborPixel(t, s, image)) == -420) continue;
                if (solid) {
                    newColor = !(!armor || (float)t <= (float)imageWidth / 2.0f - armorOutlineFractionHorizontal || (float)t >= (float)imageWidth / 2.0f + armorOutlineFractionHorizontal - 1.0f || (float)s <= (float)imageHeight / 2.0f - armorOutlineFractionVertical || (float)s >= (float)imageHeight / 2.0f + armorOutlineFractionVertical - 1.0f) ? 0 : -16777216;
                } else {
                    int red = newColor >> 16 & 0xFF;
                    int green = newColor >> 8 & 0xFF;
                    int blue = newColor & 0xFF;
                    newColor = (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
                }
                temp.setRGB(t, s, newColor);
            }
        }
        return temp;
    }

    private static int sampleNonTransparentNeighborPixel(int x, int y, BufferedImage image) {
        int color;
        if (x > 0 && ((color = image.getRGB(x - 1, y)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (x < image.getWidth() - 1 && ((color = image.getRGB(x + 1, y)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (y > 0 && ((color = image.getRGB(x, y - 1)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (y < image.getHeight() - 1 && ((color = image.getRGB(x, y + 1)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (x > 0 && y > 0 && ((color = image.getRGB(x - 1, y - 1)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (x > 0 && y < image.getHeight() - 1 && ((color = image.getRGB(x - 1, y + 1)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (x < image.getWidth() - 1 && y > 0 && ((color = image.getRGB(x + 1, y - 1)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (x < image.getWidth() - 1 && y < image.getHeight() - 1 && ((color = image.getRGB(x + 1, y + 1)) >> 24 & 0xFF) > 50) {
            return color;
        }
        return -420;
    }

    public static class_1011 fillOutline(class_1011 image, boolean outline, int passes) {
        return ImageUtils.fillOutline(image, outline, false, 0.0f, 0.0f, passes);
    }

    public static class_1011 fillOutline(class_1011 image, boolean outline, boolean armor, float intendedWidth, float intendedHeight, int passes) {
        if (outline) {
            for (int t = 0; t < passes; ++t) {
                image = ImageUtils.fillOutline(image, true, armor, intendedWidth, intendedHeight);
            }
        }
        return ImageUtils.fillOutline(image, false, armor, intendedWidth, intendedHeight);
    }

    private static class_1011 fillOutline(class_1011 image, boolean solid, boolean armor, float intendedWidth, float intendedHeight) {
        float armorOutlineFractionHorizontal = intendedWidth / 2.0f - 1.0f;
        float armorOutlineFractionVertical = intendedHeight / 2.0f - 1.0f;
        class_1011 temp = new class_1011(image.method_4307(), image.method_4323(), false);
        temp.method_4317(image);
        int imageWidth = image.method_4307();
        int imageHeight = image.method_4323();
        for (int t = 0; t < image.method_4307(); ++t) {
            for (int s = 0; s < image.method_4323(); ++s) {
                int newColor;
                int color = temp.method_61940(t, s);
                if ((color >> 24 & 0xFF) != 0 || (newColor = ImageUtils.sampleNonTransparentNeighborPixel(t, s, temp)) == -420) continue;
                if (solid) {
                    newColor = !(!armor || (float)t <= (float)imageWidth / 2.0f - armorOutlineFractionHorizontal || (float)t >= (float)imageWidth / 2.0f + armorOutlineFractionHorizontal - 1.0f || (float)s <= (float)imageHeight / 2.0f - armorOutlineFractionVertical || (float)s >= (float)imageHeight / 2.0f + armorOutlineFractionVertical - 1.0f) ? 0 : -16777216;
                } else {
                    int red = newColor >> 16 & 0xFF;
                    int green = newColor >> 8 & 0xFF;
                    int blue = newColor & 0xFF;
                    newColor = (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
                }
                image.method_61941(t, s, newColor);
            }
        }
        temp.close();
        return image;
    }

    private static int sampleNonTransparentNeighborPixel(int x, int y, class_1011 image) {
        int color;
        if (x > 0 && ((color = image.method_61940(x - 1, y)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (x < image.method_4307() - 1 && ((color = image.method_61940(x + 1, y)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (y > 0 && ((color = image.method_61940(x, y - 1)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (y < image.method_4323() - 1 && ((color = image.method_61940(x, y + 1)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (x > 0 && y > 0 && ((color = image.method_61940(x - 1, y - 1)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (x > 0 && y < image.method_4323() - 1 && ((color = image.method_61940(x - 1, y + 1)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (x < image.method_4307() - 1 && y > 0 && ((color = image.method_61940(x + 1, y - 1)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (x < image.method_4307() - 1 && y < image.method_4323() - 1 && ((color = image.method_61940(x + 1, y + 1)) >> 24 & 0xFF) > 50) {
            return color;
        }
        return -420;
    }

    public static BufferedImage trim(BufferedImage image) {
        int color;
        int t;
        int left = -1;
        int right = image.getWidth();
        int top = -1;
        int bottom = image.getHeight();
        boolean foundColor = false;
        while (!foundColor && left < right - 1) {
            ++left;
            for (t = 0; t < image.getHeight(); ++t) {
                color = image.getRGB(left, t);
                if (color >> 24 == 0) continue;
                foundColor = true;
            }
        }
        foundColor = false;
        while (!foundColor && right > left) {
            --right;
            for (t = 0; t < image.getHeight(); ++t) {
                color = image.getRGB(right, t);
                if (color >> 24 == 0) continue;
                foundColor = true;
            }
        }
        foundColor = false;
        while (!foundColor && top < bottom - 1) {
            ++top;
            for (t = 0; t < image.getWidth(); ++t) {
                color = image.getRGB(t, top);
                if (color >> 24 == 0) continue;
                foundColor = true;
            }
        }
        foundColor = false;
        while (!foundColor && bottom > top) {
            --bottom;
            for (t = 0; t < image.getWidth(); ++t) {
                color = image.getRGB(t, bottom);
                if (color >> 24 == 0) continue;
                foundColor = true;
            }
        }
        return image.getSubimage(left, top, right - left + 1, bottom - top + 1);
    }

    public static BufferedImage trimCentered(BufferedImage image) {
        int height = image.getHeight();
        int width = image.getWidth();
        int left = -1;
        int right = width;
        int top = -1;
        int bottom = height;
        boolean foundColor = false;
        while (!foundColor && left < width / 2 - 1 && top < height / 2 - 1) {
            int x;
            int color;
            int y;
            ++left;
            --right;
            --bottom;
            for (y = ++top; y < bottom; ++y) {
                color = image.getRGB(left, y);
                if (color >> 24 == 0) continue;
                foundColor = true;
            }
            for (y = top; y < bottom; ++y) {
                color = image.getRGB(right, y);
                if (color >> 24 == 0) continue;
                foundColor = true;
            }
            for (x = left; x < right; ++x) {
                color = image.getRGB(x, top);
                if (color >> 24 == 0) continue;
                foundColor = true;
            }
            for (x = left; x < right; ++x) {
                color = image.getRGB(x, bottom);
                if (color >> 24 == 0) continue;
                foundColor = true;
            }
        }
        return image.getSubimage(left, top, right - left + 1, bottom - top + 1);
    }

    public static BufferedImage colorify(BufferedImage image, float r, float g, float b) {
        BufferedImage temp = new BufferedImage(image.getWidth(), image.getHeight(), 3);
        Graphics2D gfx = temp.createGraphics();
        gfx.drawImage((Image)image, 0, 0, null);
        gfx.dispose();
        for (int x = 0; x < temp.getWidth(); ++x) {
            for (int y = 0; y < temp.getHeight(); ++y) {
                int ax = temp.getColorModel().getAlpha(temp.getRaster().getDataElements(x, y, null));
                int rx = temp.getColorModel().getRed(temp.getRaster().getDataElements(x, y, null));
                int gx = temp.getColorModel().getGreen(temp.getRaster().getDataElements(x, y, null));
                int bx = temp.getColorModel().getBlue(temp.getRaster().getDataElements(x, y, null));
                rx = (int)((float)rx * r);
                gx = (int)((float)gx * g);
                bx = (int)((float)bx * b);
                temp.setRGB(x, y, ax << 24 | rx << 16 | gx << 8 | bx);
            }
        }
        return temp;
    }

    public static BufferedImage colorify(BufferedImage image, int r, int g, int b) {
        return ImageUtils.colorify(image, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public static BufferedImage colorify(BufferedImage image, int rgb) {
        return ImageUtils.colorify(image, rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public static float percentageOfEdgePixelsThatAreSolid(BufferedImage image) {
        int color;
        int t;
        float edgePixels = image.getWidth() * 2 + image.getHeight() * 2 - 2;
        float edgePixelsWithColor = 0.0f;
        for (t = 0; t < image.getHeight(); ++t) {
            color = image.getRGB(0, t);
            if (color >> 24 != 0) {
                edgePixelsWithColor += 1.0f;
            }
            if ((color = image.getRGB(image.getWidth() - 1, t)) >> 24 == 0) continue;
            edgePixelsWithColor += 1.0f;
        }
        for (t = 1; t < image.getWidth() - 1; ++t) {
            color = image.getRGB(t, 0);
            if (color >> 24 != 0) {
                edgePixelsWithColor += 1.0f;
            }
            if ((color = image.getRGB(t, image.getHeight() - 1)) >> 24 == 0) continue;
            edgePixelsWithColor += 1.0f;
        }
        return edgePixelsWithColor / edgePixels;
    }
}

