/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.debugify.error;

import dev.isxander.debugify.error.DebugifyErrorHandler;
import dev.isxander.debugify.error.MixinErrorEntry;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Set;

public class CrashReportInjector {
    public static void addDetailsToCrashReport(StringBuilder sb) {
        Set<MixinErrorEntry> erroredFixes = DebugifyErrorHandler.getErroredFixes();
        if (!erroredFixes.isEmpty()) {
            sb.append("\n-- Debugify recovered from mixin application errors --\n");
            sb.append("Some bug fixes failed to apply, which could have led to this crash.\n");
            sb.append("This log does not mean Debugify caused the crash, but it could have.\n\n");
            for (MixinErrorEntry entry : erroredFixes) {
                sb.append(CrashReportInjector.stringifyErrorEntry(entry)).append("\n");
            }
        }
    }

    private static String stringifyErrorEntry(MixinErrorEntry entry) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        entry.throwable().printStackTrace(printWriter);
        String stacktrace = stringWriter.toString();
        return "%s fix failed to fully apply due to %s during %s\n%s".formatted(entry.fix().bugId(), entry.mixinInfo().getName(), entry.errorStage().name(), stacktrace);
    }
}

